
;ͻ;
; Code profiler.                                                            ;
;                                                                           ;
; Copyright 1995-1996 (c) Maxwell Sayles.  All Rights Reserved.             ;
;ͼ;

  LOCALS
  .586p

INCLUDE ..\xids\xids.inc

CODEBEGIN

;Ŀ;
; Variables used by timed instructions                                      ;
;;
ALIGN 16
dummy dd 0


;Ŀ;
; IRQ 0 handler                                                             ;
; Waits till PIT timer underflows then enters loop                          ;
; at each underflow it increments Flag                                      ;
; Interrupt handler                                                         ;
;;

; Number of timer ticks
; 18.2 ticks per second
; A higher number increases accuracy of test
; A number that is too large will cause an overflow in the loop counter
NUMTICKS EQU 1

Flag db 0

Int8h:
  push ds ax
  mov ds,m CS:Data32sel
  cmp Flag,NUMTICKS
  jnz @@N
    mov Second,9090h
  @@N:
  mov First,9090h
  inc Flag
  mov al,20h
  out 20h,al
  pop ax ds

  iretd


;Ŀ;
; Program entry                                                             ;
;;
Start32:

  mov bx,8
  mov edx,o Int8h
  mov ax,m Code32sel
  call SetPMInt

  xor ecx,ecx
  First dw 0FEEBh

;Ŀ;
; You may place loop init code here                                         ;
;;

  @@1:
;Ŀ;
; Instructions to be timed go right here!                                   ;
; *** Must not effect the contents of ECX ***                               ;
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


  mov dummy,eax
  fild dummy
  fabs
  fistp dummy
  mov eax,dummy


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    inc ecx
    Second LABEL WORD
    jmp @@1

  WriteDWORD ecx
  WriteLn ' number of loop interations.'

  jmp Exit32

CODEEND
