;*****
;***** (c) 1999 by crayzee
;***** do not modify and distribute for your own purposes
;***** you are allowed to use some parts in your code but mention my name there
;***** if you'll make this code better, or comment it, send it to me please
;***** crayzee@mailbox.sk
;*****

.386
.model flat,STDCALL

extrn	GetCommandLineA:PROC
extrn	lstrcat:PROC
extrn	wsprintfA:PROC
extrn	MessageBoxA:PROC
extrn	CreateFileA:PROC
extrn	GetFileSize:PROC
extrn	GetFileTime:PROC
extrn	SetFileTime:PROC
extrn	GlobalAlloc:PROC
extrn	GlobalFree:PROC
extrn	ReadFile:PROC
extrn	WriteFile:PROC
extrn	SetFilePointer:PROC
extrn	SetEndOfFile:PROC
extrn	MapFileAndCheckSumA:PROC
extrn	CloseHandle:PROC
extrn	ExitProcess:PROC

VER_MAJ			equ '1'
VER_MIN1		equ '3'
VER_MIN2		equ '3'

.data
progtitle	db 'crayzee''s PE wipe.reloc v',VER_MAJ,'.',VER_MIN1,VER_MIN2,0
cantopen	db 'Fatal error: Cannot open the file.',13,10
		db 'Usage: wipereloc',VER_MAJ,VER_MIN1,VER_MIN2,' [-e] <file_to_process>',0
cantwrite	db 'Fatal error: Cannot write to the file.',0
peinvalid	db 'Fatal error: The file is not a valid PE.',0

alignok		db 'PE file has been successfully aligned.',0

relocnotfound	db 13,10,'Error: .reloc section not found in PE.',0
relocwaswiped	db 13,10,'Error: .reloc section is not contained in the file.',0
relocisdll	db 13,10,'Error: Couldn''t wipe the .reloc section because the PE is a DLL.',0
relocok		db 13,10,'.reloc section successfully wiped out of the file.',0

truncendok	db 13,10,'End of the file has been wiped.',0
truncendround	db 13,10,'End of the file has been correctly set.',0
truncendwas	db 13,10,'End of the file already had been wiped.',0

crcnotchanged	db 13,10,'Error: Couldn''t set a correct CRC.',0
crcok		db 13,10,'A correct CRC has been set.',0

timenotrecovd	db 13,10,'Error: Couldn''t recover file''s previous time.',0
timeok		db 13,10,'File''s previous time has been recovered.',0

difference_form	db 13,10,10,'Size of the file has been changed'
		db    13,10,'from %u bytes to %u bytes.'
		db    13,10,'This is a decrease of %d bytes (%d%%).',0

text0		dd offset alignok
text1		dd offset relocok
text2		dd offset truncendok
text3		dd offset crcok
text4		dd offset timeok

.data?
hfile		dd ?
cmdline		dd ?
filename	db 256 dup(?)
prevfsize	dd ?
fsize		dd ?
alloc		dd ?
sth		dd ?
relocsize	dd ?
relocpos	dd ?
relocrva	dd ?
sectionscount	dw ?
peheaderpos	dd ?
filecrc		dd ?
fLastWriteTime	dd 2 dup (?)
fLastAccessTime	dd 2 dup (?)
fCreationTime	dd 2 dup (?)
donetext	db 1024 dup(?)
difference	db 200 dup(?)
filealign	dd ?
newfilealign	dd ?
movesize	dd ?
firstsectionpos	dd ?
doalign		db ?
isdll		db ?
truncendflag	db ?
didtruncend	db ?
pass		db ?
lastsectionend	dd ?
sizeofimage	dd ?
sizeofheaders	dd ?
memalign	dd ?

.code
start:
	call	GetCommandLineA
	mov	[cmdline], eax

;******* analyse the command line *******
	mov	edi, [cmdline]
	inc	edi
	mov	al, ' '
	repne	scasb	;look for first space
	cmp	word ptr [edi], 'e-'	;test if the -e parameter is present
	sete	[truncendflag]
	jne	go_cmdlineloop
	add	edi, 3	;there must be a space after the param
    go_cmdlineloop:
	mov	esi, offset filename
	xchg	esi, edi
	mov	bl, 0	;lfn indicator
    cmdlineloop:
	lodsb
	test	al, al
	jz	cmddone	;if there is a NULL character, quit the loop
	cmp	al, '"'
	jne	noquotes
	test	bl, bl
	setz	bl	;if bl was 0, set to 1
	jnz	cmddone	;if bl was 1, the filename ends here and we quit this loop
	jmp	cmdlineloop
    noquotes:
	stosb
	jmp	cmdlineloop

;******* open the file *******
cmddone:
	push	0
	push	0
	push	80h;FILE_ATTRIBUTE_NORMAL
	push	3;OPEN_EXISTING
	push	0
	push	1;FILE_SHARE_READ
	push	0c0000000h;GENERIC_READ or GENERIC_WRITE
	push	offset filename
	call	CreateFileA
	mov	[hfile], eax
	cmp	eax, -1
	jne	processthefile

erroropeningfile:
	push	10h;MB_ICONERROR
	push	offset progtitle
	push	offset cantopen
	push	0
	call	MessageBoxA
	jmp	exit

;******* process the file *******
processthefile:
	push	0	;for GetFileSize
	push	eax	;for GetFileSize
	push	offset fLastWriteTime
	push	offset fLastAccessTime
	push	offset fCreationTime
	push	eax
	call	GetFileTime		;store the file's times to be recovered later
	call	GetFileSize
	mov	[fsize], eax
	mov	[prevfsize], eax
	add	eax, 1000h	;because after a previous processing we could fail
	cmp	eax, -1
	je	erroropeningfile

	push	0		;for ReadFile
	push	offset sth	;for ReadFile
	push	eax;=fsize+1000h;for ReadFile

	push	eax;=fsize+1000h
	push	40h;GMEM_ZEROINIT or GMEM_FIXED
	call	GlobalAlloc
	mov	[alloc], eax

	push	eax;=alloc
	push	[hfile]
	call	ReadFile

;------- check if the file is a valid PE -------
	mov	edi, [alloc]	;store the file start to edi
	mov	esi, edi
	lodsw
	cmp	ax, 5a4dh	;'MZ'
	jne	filenotpe
	add	esi, 3ah	;here should be the address of the PE header
	lodsd
	mov	[peheaderpos], eax
	mov	esi, edi
	add	esi, eax
	lodsd
	cmp	eax, 00004550h	;'PE',0,0 signature
	jne	filenotpe
;------- get the needed PE values -------
	lodsw
	lodsw			;now we have the number of sections
	mov	[sectionscount], ax
	add	esi, 0eh	;here's the Characteristics member of PE header
	lodsw
	and	ax, 2000h;IMAGE_FILE_DLL ;find out if the PE is a DLL
	setne	[isdll]		;this will be used later
	add	esi, 020h	;here should be the SectionAlignment value
	lodsd
	mov	[memalign], eax
	lodsd			;now here's the FileAlignment value
	mov	[filealign], eax
	mov	[newfilealign], eax
	cmp	eax, [memalign]	;if the FileAlignment is bigger than SectionAlignment,
	ja	filenotpe	;then the PE must be corrupt
	cmp	[memalign], 200h;if the SectionAlignment < 200h, we cannot realign this file
	seta	[doalign]
	jb	dontstorenewalign
	cmp	eax, 200h	;if the previous alignment is below 200h, do not realign
	seta	[doalign]
	jb	dontstorenewalign
	mov	edi, esi
	sub	edi, 4
	mov	eax, 200h
	mov	[newfilealign], eax
	stosd			;store the new FileAlignment
    dontstorenewalign:
	add	esi, 060h	;here should be the directory entry of base relocations
	lodsd
	mov	[relocrva], eax

;------- wipe out the zeroes above PE headers -------
	pushad
	;find the first 0 after stub
	mov	edi, [peheaderpos]
	cmp	edi, 40h	;if the PE header is at offset less than 40h, do not
	jb	usethisnumber	;try to move it because we can really crash it
	add	edi, [alloc]
	mov	esi, edi
	dec	edi		;now edi points to the end of the section
	std			;we want a decrement search
	xor	ecx, ecx
	dec	ecx		;maximal counter
	xor	al, al
	repe	scasb		;now look for non-zero byte
	add	edi, 2		;2 bytes because repe
	cld			;back to incremental direction
	sub	edi, [alloc]
	mov	ebx, 40h
	cmp	edi, ebx	;PE header shouldn't start at offset less than 40h
	ja	usethisnumber
	mov	edi, ebx
      usethisnumber:
	mov	eax, [alloc]
	add	eax, 3ch
	mov	[eax], edi	;store the new PE header offset

	;compute the size of headers
	mov	ecx, 0f8h	;size of PE headers
	xor	eax, eax
	mov	ax, [sectionscount]
	mov	ebx, 40		;size of a section header
	mul	ebx
	add	ecx, eax	;now in ecx is a total size of all headers

	;move the headers
	mov	esi, [peheaderpos]
	mov	[peheaderpos], edi	;in edi is still the new PE header offset
	add	edi, [alloc]
	add	esi, [alloc]
	rep	movsb

	;calculate the difference and null the rest
	mov	ecx, esi
	sub	ecx, edi
	xor	al, al
	rep	stosb


;------- wipe out the zeroes below PE headers -------
wipebelowheaders:
	mov	[sizeofimage], eax	;need to null this before second pass
    ;--- at first find the first section in the file ---
	popad
	xor	eax, eax
	dec	eax
	mov	[firstsectionpos], eax
	mov	esi, [alloc]
	add	esi, [peheaderpos]
	add	esi, 0f8h	;here should start the section headers
	pushad
	xor	ecx, ecx
	mov	cx, [sectionscount]
    findfirstsectionloop:
	mov	edx, esi
	add	esi, 14h	;now we're on PointerToRawData
	lodsd
	test	eax, eax
	jz	nextfindfirstsection
	cmp	eax, [firstsectionpos]
	ja	nextfindfirstsection
	mov	[firstsectionpos], eax
    nextfindfirstsection:
	mov	esi, edx
	add	esi, 40		;the size of one section's header
	loop	findfirstsectionloop

    ;--- and then wipe out the zeroes ---
	xor	eax, eax
	mov	ax, [sectionscount]
	mov	ebx, 40		;size of section header
	mul	ebx
	add	eax, [peheaderpos]
	add	eax, 0f8h	;size of PE file header+optional header
	mov	ebx, [newfilealign]
	div	ebx
	test	edx, edx
	jz	edxzero
	inc	eax
	edxzero:
	mul	ebx		;in (edx:)eax is now the new 'SizeOfHeaders'
	mov	edi, eax
	mov	esi, [firstsectionpos]
	mov	edx, esi
	mov	ecx, [fsize]
	sub	ecx, edx
	mov	[sizeofheaders], edx
	sub	edx, eax	;if the new SizeOfHeaders is above the old one, skip this
	jbe	processsections
	mov	[sizeofheaders], eax

	add	edi, [alloc]
	add	esi, [alloc]
	sub	[fsize], edx
	add	[movesize], edx
	rep	movsb

;------- inspect the sections and remove .reloc (and move the others then) -------
processsections:
	popad			;esi should point to the section headers
	xor	ecx, ecx
	mov	cx, [sectionscount]
	mov	bl, 0
    sectionsloop:
	mov	edx, esi

	call	alignsection	;must be somewhere else because of the loop range

	cmp	[pass], 1	;wipe .reloc in the first pass only
	jae	nextsection
	cmp	[isdll], 1	;if the PE is a DLL, skip .reloc wiping
	je	nextsection
	test	bl, bl		;was .reloc section already found?
	jnz	nextsection
    findreloc:
	add	esi, 0ch	;here's the VirtualAddress = section's RVA
	lodsd
	cmp	eax, [relocrva]	;we're looking for the .reloc section
	jne	nextsection
	lodsd			;right after rva is SizeOfRawData member
	mov	[relocsize], eax
	lodsd			;and then there is PointerToRawData (if it is 0,
	mov	[relocpos], eax ; the section is not contained in the file)
	test	eax, eax	;test if the .reloc is contained in the file
	jz	relocempty	
	;remove the reloc section body
	call	wiperelocsection;must be somewhere else because of the loop range
    relocdone:
	;now remove the reloc section header
	call	wiperelocheader	;must be somewhere else because of the loop range
	mov	bl, 1
    nextsection:
	mov	esi, edx
	add	esi, 40		;the size of one section's header
	loop	sectionsloop

;------- wipe out the end of the file -------
	cmp	[pass], 0	;wipe the eof in pass 1 only (because of the flags)
	je	afterwipeend
	cmp	[truncendflag], 1	;if we shouldn't wipe the end to 4 nulls only
	je	wipeeoftotally
	mov	edi, [lastsectionend]	;then wipe it to the end of the last section
	mov	[fsize], edi
	mov	[didtruncend], 2
	jmp	afterwipeend

    wipeeoftotally:
	mov	edi, [alloc]
	add	edi, [fsize]
	dec	edi
	std			;we want a decrement search
	xor	ecx, ecx
	dec	ecx		;maximal counter
	xor	al, al
	mov	esi, edi
	repe	scasb		;now look for non-zero byte
	add	edi, 6		;2 bytes 'cause repe + 4 bytes "for sure" ;)
	cld			;back to incremental direction
	sub	esi, edi	;esi is previous and edi new size
	seta	didtruncend	;if new<old, set the was-truncated flag
	sub	edi, [alloc]
	mov	[fsize], edi
    afterwipeend:

;------- realise what happened and jump to file-writing -------
	xor	eax, eax	;we cannot move the sections twice the wanted amount
	mov	[movesize], eax	;so we null this
	mov	[lastsectionend], eax	;the pointer to last section's end must be computed
					;*after* completely aligning it...
	cmp	[pass], 0
	jne	dontsavebx
	push	bx		;store bx (there is a reloc-wiped? flag in bl) in pass 0 only
    dontsavebx:
	pushad
	cmp	[pass], 0
	sete	pass
	je	wipebelowheaders	;make the second pass
	popad
	pop	bx
	test	bl, bl
	jnz	writethefile
	mov	[text1], offset relocnotfound
	jmp	writethefile


;------- set some text if reloc is empty (must be here because of the loop range) -------
    relocempty:
	mov	[text1], offset relocwaswiped
	jmp	relocdone

;------- section aligning part (must be here because of the loop range) -------
    alignsection:
	pushad
	add	esi, 10h	;here should be the section's SizeOfRawData
	lodsd
	test	eax, eax	;if it is 0, skip this section
	jz	endalignsection

	;calculate amount of memory the section needs and add it to [sizeofimage]
	pushad
	xor	edx, edx
	mov	ebx, [memalign]
	div	ebx
	test	edx, edx
	jz	sectionsizeround
	inc	eax
	sectionsizeround:
	mul	ebx		;now eax=size of section rounded up to [SectionAlignment]
	add	[sizeofimage], eax
	popad

	mov	ebx, eax
	mov	edx, [esi]	;loaded PointerToRawData
	test	edx, edx
	jz	endalignsection	;if it is 0, skip this section
	sub	edx, [movesize]	;move the pointer if some of the sections were resized
	mov	[esi], edx	;save it back
	push	eax		;store SizeOfRawData
	push	edx		;store PointerToRawData
	mov	edi, [alloc]
	add	edi, edx
	add	edi, ebx
	dec	edi		;now edi points to the last byte of the section
	std			;we want a decrement search
	xor	ecx, ecx
	dec	ecx		;maximal counter ;)
	xor	al, al
	repe	scasb		;now look for non-zero byte
	add	edi, 2		;2 bytes because repe
	cld			;back to incremental direction
	sub	edi, [alloc]
	sub	edi, edx
	mov	eax, edi	;now in eax is the "neccessarily used" size of the section
	pop	edx		;there was the PointerToRawData stored
	pop	ebx		;there was the SizeOfRawData stored
	push	edx
	mov	ecx, edx	;we will need this when counting the last section end
	xor	edx, edx
	div	dword ptr [newfilealign]
	test	edx, edx
	jz	sectionrounded
	inc	eax
	sectionrounded:
	mul	dword ptr [newfilealign] ;now in (edx:)eax is the new section size

	;determine if this is the last section and if so, save the pointer to its end
	;also stop aligning this section if it is about to be larger then
	cmp	eax, ebx	;if new size would be above the old size, skip this section
	jbe	continuealigning;but store its end first
		add	ecx, ebx	;ebx is old SizeOfRawData, now ecx is the old end of the section
		cmp	[lastsectionend], ecx
		ja	notlastsection
		mov	[lastsectionend], ecx
	      notlastsection:
		pop	ecx	;there was a "push edx" which we need to pop
		jmp	endalignsection
      continuealigning:
	add	ecx, eax	;now in ecx is the new end of the section
	cmp	[lastsectionend], ecx	;store the new end if it is the greatest one
	ja	notlastsection_
	mov	[lastsectionend], ecx
      notlastsection_:

	mov	[esi-4], eax	;store the new section size into the section header
	mov	edi, ebx
	sub	edi, eax	;compute the old and new section size difference
	add	dword ptr [movesize], edi
	mov	ecx, [fsize]
	sub	[fsize], edi	;adjust the file size
	pop	edx		;there was the PointerToRawData stored
	sub	ecx, edx
	cmp	ecx, ebx	;check if the end of the file had been previously truncated
	jc	endalignsection
	sub	ecx, ebx	;now ecx=number of bytes from the end of the section to EOF
	mov	esi, [alloc]
	add	esi, edx	;add PointerToRawData
	add	esi, ebx	;add SizeOfRawData
	mov	edi, [alloc]
	add	edi, edx	;add PointerToRawData
	add	edi, eax	;add the new section size
	rep	movsb		;move the rest of the file
    endalignsection:
	popad
	ret
;------- end of section aligning part -------


;------- reloc section wiping part (must be here because of the loop range) -------
    wiperelocsection:
	xor	eax, eax
	mov	dword ptr [esi-8], eax	;set SizeOfRawData to 0
	mov	dword ptr [esi-4], eax	;set PointerToRawData to 0
	mov	esi, [relocpos]
	mov	edi, esi	;now edi=file offset to the begin of reloc
	mov	eax, [relocsize]
	add	esi, eax	;now esi=file offset to the end of reloc
	push	ecx		;store ecx, it's needed in the section loop 
	mov	ecx, [fsize]
	sub	[fsize], eax	;adjust the file size
	sub	ecx, esi	;now ecx=number of bytes from the end of reloc to EOF
	add	edi, [alloc]	;now edi=actual memory address to the begin of reloc
	add	esi, [alloc]	;now esi=actual memory address to the end of reloc
	rep	movsb		;move the bytes
	pop	ecx
	mov	eax, [relocsize]
	add	[movesize], eax
	ret
;------- end of reloc section wiping part -------


;------- reloc header wiping part (must be here because of the loop range) -------
    wiperelocheader:
	pushad
	mov	edi, edx	;in edi is now the offset of .reloc section header
	xor	eax, eax
	mov	ax, cx
	dec	ax		;in eax is the number of sections after .reloc
	mov	bx, 40
	mul	bx		;now in eax is the sum of sizes of all section headers after .reloc
	mov	ecx, eax	;store it into ecx
	mov	esi, edi
	add	esi, 40		;in esi is the offset of section header after .reloc
	rep	movsb		;move the section headers
	xor	ecx, ecx
	mov	cx, bx		;in ecx is 40
	xor	al, al
	rep	stosb		;null the last section
	mov	edi, [alloc]
	add	edi, [peheaderpos]
	add	edi, 6		;now edi points to the NumberOfSections member of PE header
	dec	[sectionscount]
	mov	ax, [sectionscount]
	stosw			;store there the new number of sections 
	popad
	sub	edx, 40		;must substract 1 section (coz then it is added)
	ret
;------- end of header wiping part -------


;------- write the file -------
writethefile:
	;round up the headers size & add it to image size
	xor	edx, edx
	mov	eax, [sizeofheaders]
	mov	ebx, [memalign]
	div	ebx
	test	edx, edx
	jz	headerssizeround
	inc	eax
	headerssizeround:
	mul	ebx		;now eax=headers size rounded up to SectionAlignment
	add	[sizeofimage], eax	;add it to the SizeOfImage

	;store some values into the PE header
	mov	edi, [alloc]
	add	edi, [peheaderpos]
	add	edi, 50h	;here should be the SizeOfImage value
	mov	eax, [sizeofimage]
	stosd			;store the newly calculated value
	mov	eax, [sizeofheaders]
	stosd			;store the new offset to 1st section
	mov	edi, [alloc]
	add	edi, [peheaderpos]
	add	edi, 0a0h	;here should be the directory entry of base relocations
	xor	eax, eax
	stosd			;set to 0 (means it is not contained in the file)
	stosd			;also set its size to 0

	push	0
	push	0
	push	0
	push	hfile
	call	SetFilePointer

	;write whole file
	push	0
	push	offset sth
	push	[fsize]
	push	[alloc]
	push	hfile
	call	WriteFile
	test	eax, eax
	jz	writeerror

	push	hfile
	call	SetEndOfFile

;------- set the correct checksum -------
setcrc:
	;get the correct file checksum (must be done after writing)
	push	offset filecrc
	push	offset sth
	push	offset filename
	call	MapFileAndCheckSumA
	cmp	[filecrc], 0
	je	crcnotset

	mov	eax, [peheaderpos]
	add	eax, 58h	;here should be the PE checksum
	
	;write the correct checksum
	push	0
	push	0
	push	eax
	push	hfile
	call	SetFilePointer
	cmp	eax, -1
	je	crcnotset

	push	0
	push	offset sth
	push	4
	push	offset filecrc
	push	hfile
	call	WriteFile
	test	eax, eax
	jz	crcnotset

	jmp	settime
crcnotset:
	mov	[text3], offset crcnotchanged

;------- set the time of file -------
settime:
	;recover the times of file
	push	offset fLastWriteTime
	push	offset fLastAccessTime
	push	offset fCreationTime
	push	hfile
	call	SetFileTime
	test	eax, eax
	jnz	done

	mov	[text4], offset timenotrecovd

;------- display the success message -------
done:
	;calculate the difference and %
	mov	esi, [prevfsize]
	mov	edi, [fsize]
	mov	ecx, esi
	sub	ecx, edi
	mov	eax, ecx
	mov	ebx, 100
	imul	ebx
	idiv	esi
	
	;create the difference text
	push	eax	;difference % of previous size
	push	ecx	;difference
	push	edi	;current size
	push	esi	;original (previous) size
	push	offset difference_form
	push	offset difference
	call	wsprintfA

	;create the final message
	mov	eax, offset donetext
	push	offset difference
	push	eax

	push	[text4]
	push	eax

	push	[text3]
	push	eax

	cmp	[didtruncend], 2	;if the end was set to end of last section...
	jne	trytrunc1
	mov	[text2], offset truncendround	;... say it was "correctly set"
	jmp	appendtext2
    trytrunc1:
	cmp	[didtruncend], 1	;if it was wiped to 4-bytes, say it was "wiped"
	je	appendtext2		;if it had already been wiped, say that
	mov	[text2], offset truncendwas
    appendtext2:
	push	[text2]
	push	eax

	cmp	[isdll], 1		;if the PE is a DLL say we couldn't wipe the reloc
	jne	appendtext1
	mov	[text1], offset relocisdll
    appendtext1:
	push	[text1]
	push	eax

	push	[text0]
	push	eax
	call	lstrcat
	call	lstrcat
	call	lstrcat
	call	lstrcat
	call	lstrcat
	call	lstrcat

	;display the message
	push	40h;MB_ICONINFORMATION
	push	offset progtitle
	push	offset donetext
	push	0
	call	MessageBoxA
	jmp	exit

;------- display some failure messages if there was a fatal error -------
writeerror:
	push	10h;MB_ICONERROR
	push	offset progtitle
	push	offset cantwrite
	push	0
	call	MessageBoxA
	jmp	exit

filenotpe:
	push	10h;MB_ICONERROR
	push	offset progtitle
	push	offset peinvalid
	push	0
	call	MessageBoxA

;------- shutdown -------
exit:
	push	hfile
	call	CloseHandle
	push	[alloc]
	call	GlobalFree
	push	0
	call	ExitProcess
end start