//+---------------------------------------------------------------------------
//
//  Microsoft Windows
//  Copyright (C) Microsoft Corporation, 1992 - 1996.
//
//  File:       wincrypt.h
//
//  Contents:   Cryptographic API Prototypes and Definitions
//
//----------------------------------------------------------------------------
//   email:      Lookin_I@Usa.net
//   home page:  www.geocities.com/Eureka/Park/6634
//----------------------------------------------------------------------------
Unit WinCrypt;

interface

uses windows;

function GET_ALG_CLASS(x : DWORD): DWORD;
function GET_ALG_TYPE(x : DWORD): DWORD;
function GET_ALG_SID(x : DWORD): DWORD;

Const
//
// Algorithm IDs and Flags
//

// ALG_ID crackers
//#define GET_ALG_CLASS(x)                (x & (7 << 13))
//#define GET_ALG_TYPE(x)                 (x & (15 << 9))
//#define GET_ALG_SID(x)                  (x & (511))

// Algorithm classes
ALG_CLASS_ANY                   = (0);
ALG_CLASS_SIGNATURE             = (1 shl 13);
ALG_CLASS_MSG_ENCRYPT           = (2 shl 13);
ALG_CLASS_DATA_ENCRYPT          = (3 shl 13);
ALG_CLASS_HASH                  = (4 shl 13);
ALG_CLASS_KEY_EXCHANGE          = (5 shl 13);

// Algorithm types
ALG_TYPE_ANY                    = (0);
ALG_TYPE_DSS                    = (1 shl 9);
ALG_TYPE_RSA                    = (2 shl 9);
ALG_TYPE_BLOCK                  = (3 shl 9);
ALG_TYPE_STREAM                 = (4 shl 9);

// Generic sub-ids
ALG_SID_ANY                     = (0);

// Some RSA sub-ids
ALG_SID_RSA_ANY                 = 0;
ALG_SID_RSA_PKCS                = 1;
ALG_SID_RSA_MSATWORK            = 2;
ALG_SID_RSA_ENTRUST             = 3;
ALG_SID_RSA_PGP                 = 4;

// Some DSS sub-ids
//
ALG_SID_DSS_ANY                 = 0;
ALG_SID_DSS_PKCS                = 1;
ALG_SID_DSS_DMS                 = 2;

// Block cipher sub ids
// DES sub_ids
ALG_SID_DES                     = 1;
ALG_SID_3DES			= 3;
ALG_SID_DESX			= 4;
ALG_SID_IDEA			= 5;
ALG_SID_CAST			= 6;
ALG_SID_SAFERSK64		= 7;
ALD_SID_SAFERSK128		= 8;

// KP_MODE
CRYPT_MODE_CBCI			= 6;	// ANSI CBC Interleaved
CRYPT_MODE_CFBP			= 7;	// ANSI CFB Pipelined
CRYPT_MODE_OFBP			= 8;	// ANSI OFB Pipelined
CRYPT_MODE_CBCOFM		= 9;	// ANSI CBC + OF Masking
CRYPT_MODE_CBCOFMI		= 10;	// ANSI CBC + OFM Interleaved

// RC2 sub-ids
ALG_SID_RC2                     = 2;

// Stream cipher sub-ids
ALG_SID_RC4                     = 1;
ALG_SID_SEAL                    = 2;

// Hash sub ids
ALG_SID_MD2                     = 1;
ALG_SID_MD4                     = 2;
ALG_SID_MD5                     = 3;
ALG_SID_SHA                     = 4;
ALG_SID_MAC                     = 5;
ALG_SID_RIPEMD			= 6;
ALG_SID_RIPEMD160		= 7;
ALG_SID_SSL3SHAMD5		= 8;

// Our silly example sub-id
ALG_SID_EXAMPLE                 = 80;

Type
   ALG_ID = UINT;

Const
// algorithm identifier definitions
CALG_MD2        = (ALG_CLASS_HASH or ALG_TYPE_ANY or ALG_SID_MD2);
CALG_MD4        = (ALG_CLASS_HASH or ALG_TYPE_ANY or ALG_SID_MD4);
CALG_MD5        = (ALG_CLASS_HASH or ALG_TYPE_ANY or ALG_SID_MD5);
CALG_SHA        = (ALG_CLASS_HASH or ALG_TYPE_ANY or ALG_SID_SHA);
CALG_MAC        = (ALG_CLASS_HASH or ALG_TYPE_ANY or ALG_SID_MAC);
CALG_RSA_SIGN   = (ALG_CLASS_SIGNATURE or ALG_TYPE_RSA or ALG_SID_RSA_ANY);
CALG_DSS_SIGN   = (ALG_CLASS_SIGNATURE or ALG_TYPE_DSS or ALG_SID_DSS_ANY);
CALG_RSA_KEYX   = (ALG_CLASS_KEY_EXCHANGE or ALG_TYPE_RSA or ALG_SID_RSA_ANY);
CALG_DES        = (ALG_CLASS_DATA_ENCRYPT or ALG_TYPE_BLOCK or ALG_SID_DES);
CALG_RC2        = (ALG_CLASS_DATA_ENCRYPT or ALG_TYPE_BLOCK or ALG_SID_RC2);
CALG_RC4        = (ALG_CLASS_DATA_ENCRYPT or ALG_TYPE_STREAM or ALG_SID_RC4);
CALG_SEAL       = (ALG_CLASS_DATA_ENCRYPT or ALG_TYPE_STREAM or ALG_SID_SEAL);

type
  PVTableProvStruc = ^VTableProvStruc;
  VTableProvStruc = record
      Version : DWORD;
      FuncVerifyImage : FARPROC;
      FuncReturnhWnd : FARPROC;
  end;
  _VTableProvStruc = VTableProvStruc;

  HCRYPTPROV   = THandle;
  HCRYPTKEY    = THandle;
  HCRYPTHASH   = THandle;

  PHCRYPTPROV   = PHandle;
  PHCRYPTKEY    = PHandle;
  PHCRYPTHASH   = PHandle;

Const

// dwFlags definitions for CryptAquireContext
CRYPT_VERIFYCONTEXT     = $F0000000;
CRYPT_NEWKEYSET         = $8;
CRYPT_DELETEKEYSET      = $10;

// dwFlag definitions for CryptGenKey
CRYPT_EXPORTABLE        = $00000001;
CRYPT_USER_PROTECTED    = $00000002;
CRYPT_CREATE_SALT       = $00000004;
CRYPT_UPDATE_KEY        = $00000008;

// exported key blob definitions
SIMPLEBLOB              = $1;
PUBLICKEYBLOB           = $6;
PRIVATEKEYBLOB          = $7;

AT_KEYEXCHANGE          = 1;
AT_SIGNATURE            = 2;

CRYPT_USERDATA          = 1;

// dwParam
KP_IV                   = 1;       // Initialization vector
KP_SALT                 = 2;       // Salt value
KP_PADDING              = 3;       // Padding values
KP_MODE                 = 4;       // Mode of the cipher
KP_MODE_BITS            = 5;       // Number of bits to feedback
KP_PERMISSIONS          = 6;       // Key permissions DWORD
KP_ALGID                = 7;       // Key algorithm
KP_BLOCKLEN             = 8;       // Block size of the cipher

// KP_PADDING
PKCS5_PADDING           = 1;       // PKCS 5 (sec 6.2) padding method


// KP_MODE
CRYPT_MODE_CBC          = 1;       // Cipher block chaining
CRYPT_MODE_ECB          = 2;       // Electronic code book
CRYPT_MODE_OFB          = 3;       // Output feedback mode
CRYPT_MODE_CFB          = 4;       // Cipher feedback mode
CRYPT_MODE_CTS          = 5;       // Ciphertext stealing mode

// KP_PERMISSIONS
CRYPT_ENCRYPT           = $0001;  // Allow encryption
CRYPT_DECRYPT           = $0002;  // Allow decryption
CRYPT_EXPORT            = $0004;  // Allow key to be exported
CRYPT_READ              = $0008;  // Allow parameters to be read
CRYPT_WRITE             = $0010;  // Allow parameters to be set
CRYPT_MAC               = $0020;  // Allow MACs to be used with key

HP_ALGID                = $0001;  // Hash algorithm
HP_HASHVAL              = $0002;  // Hash value
HP_HASHSIZE             = $0004;  // Hash value size

CRYPT_FAILED            = FALSE;
CRYPT_SUCCEED           = TRUE;

//#define RCRYPT_SUCCEEDED(rt)     ((rt) == CRYPT_SUCCEED)
//#define RCRYPT_FAILED(rt)        ((rt) == CRYPT_FAILED)

//
// CryptGetProvParam
//
PP_ENUMALGS             = 1;
PP_ENUMCONTAINERS       = 2;
PP_IMPTYPE              = 3;
PP_NAME                 = 4;
PP_VERSION              = 5;
PP_CONTAINER            = 6;

CRYPT_FIRST             = 1;
CRYPT_NEXT              = 2;

CRYPT_IMPL_HARDWARE     = 1;
CRYPT_IMPL_SOFTWARE     = 2;
CRYPT_IMPL_MIXED        = 3;
CRYPT_IMPL_UNKNOWN      = 4;

//
// CryptSetProvParam
//
PP_CLIENT_HWND          = 1;

PROV_RSA_FULL           = 1;
PROV_RSA_SIG            = 2;
PROV_DSS                = 3;
PROV_FORTEZZA           = 4;
PROV_MS_EXCHANGE        = 5;
PROV_SSL                = 6;

//
//STT defined Providers
//
PROV_STT_MER                    = 7;
PROV_STT_ACQ                    = 8;
PROV_STT_BRND                   = 9;
PROV_STT_ROOT                   = 10;
PROV_STT_ISS                    = 11;

MS_DEF_PROV_A       = 'Microsoft Base Cryptographic Provider v1.0';
MS_DEF_PROV         = MS_DEF_PROV_A;

MAXUIDLEN               = 64;

CUR_BLOB_VERSION        = 2;

type
PROV_ENUMALGS = record
    aiAlgid : ALG_ID;
    dwBitLen : DWORD;
    dwNameLen : DWORD;
    szName : array[0..20-1] of CHAR;
end;
_PROV_ENUMALGS = PROV_ENUMALGS;

PUBLICKEYSTRUC = record
    bType : BYTE;
    bVersion : BYTE;
    reserved : WORD;
    aiKeyAlg : ALG_ID;
end;
_PUBLICKEYSTRUC = PUBLICKEYSTRUC;

RSAPUBKEY = record
        magic : DWORD;                  // Has to be RSA1
        bitlen : DWORD;                 // # of bits in modulus
        pubexp : DWORD;                 // public exponent
end;                                    // Modulus data follows
_RSAPUBKEY = RSAPUBKEY;


function CryptAcquireContextA(
             var phProv : HCRYPTPROV;
             pszContainer : LPCTSTR;
             pszProvider : LPCTSTR;
             dwProvType : DWORD;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptAcquireContextW(
             var phProv : HCRYPTPROV;
             pszContainer : LPCWSTR;
             pszProvider : LPCWSTR;
             dwProvType : DWORD;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptAcquireContext(
             var phProv : HCRYPTPROV;
             pszContainer : PChar;
             pszProvider : PChar;
             dwProvType : DWORD;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptReleaseContext(
             hProv : HCRYPTPROV;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptGenKey(
             hProv : HCRYPTPROV;
             Algid : ALG_ID;
             dwFlags : DWORD;
             var phKey : HCRYPTKEY) : BOOL; stdcall;

function CryptDeriveKey(
             hProv : HCRYPTPROV;
             Algid : ALG_ID;
             hBaseData : HCRYPTHASH;
             dwFlags : DWORD;
             var phKey	: HCRYPTKEY) : BOOL; stdcall;

function CryptDestroyKey(
             hKey : HCRYPTKEY) : BOOL; stdcall;

function CryptSetKeyParam(
             hKey : HCRYPTKEY;
             dwParam : DWORD;
             pbData : PBYTE;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptGetKeyParam(
             hKey : HCRYPTKEY;
             dwParam : DWORD;
             pbData : PBYTE;
             pdwDataLen : DWORD;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptSetHashParam(
             hHash : HCRYPTHASH;
             dwParam : DWORD;
             pbData : PBYTE;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptGetHashParam(
             hHash : HCRYPTHASH;
             dwParam : DWORD;
             pbData : PBYTE;
             var dwDataLen : DWORD;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptSetProvParam(
             hProv : HCRYPTPROV;
             dwParam : DWORD;
             pbData : PBYTE;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptGetProvParam(
             hProv : HCRYPTPROV;
             dwParam : DWORD;
             pbData : PBYTE;
             var pdwDataLen : DWORD;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptGenRandom(
             hProv : HCRYPTPROV;
             dwLen : DWORD;
             pbBuffer : PBYTE) : BOOL; stdcall;

function CryptGetUserKey(
             hProv : HCRYPTPROV;
             dwKeySpec : DWORD;
             var phUserKey : HCRYPTKEY) : BOOL; stdcall;

function CryptExportKey(
            hKey : HCRYPTKEY;
            hExpKey : HCRYPTKEY;
            dwBlobType : DWORD;
            dwFlags : DWORD;
            pbData : PBYTE;
            var dwDataLen : DWORD) : BOOL; stdcall;

function CryptImportKey(
            hProv : HCRYPTPROV;
            pbData : PBYTE;
            dwDataLen : DWORD;
            hImpKey : HCRYPTKEY;
            dwFlags : DWORD;
            var phKey : HCRYPTKEY) : BOOL; stdcall;

function CryptEncrypt(
            hKey : HCRYPTKEY;
            hHash : HCRYPTHASH;
            Final : BOOL;
            dwFlags : DWORD;
            pbData : PBYTE;
            var dwDataLen : DWORD;
            dwBufLen : DWORD) : BOOL; stdcall;

function CryptDecrypt(
            hKey : HCRYPTKEY;
            hHash : HCRYPTHASH;
            Final : BOOL;
            dwFlags : DWORD;
            pbData : PBYTE;
            var dwDataLen : DWORD) : BOOL; stdcall;

function CryptCreateHash(
             hProv : HCRYPTPROV;
             Algid : ALG_ID;
             hKey : HCRYPTKEY;
             dwFlags : DWORD;
             var phHash : HCRYPTHASH) : BOOL; stdcall;

function CryptHashData(
             hHash : HCRYPTHASH;
             pbData : PBYTE;
             dwDataLen : DWORD;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptHashSessionKey(
             hHash : HCRYPTHASH;
             hKey : HCRYPTKEY;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptDestroyHash(
             hHash : HCRYPTHASH) : BOOL; stdcall;

function CryptSignHashA(
              hHash : HCRYPTHASH;
              dwKeySpec : DWORD;
              sDescription : LPCTSTR;
              dwFlags : DWORD;
              pbSignature : PBYTE;
              var dwSigLen : DWORD) : BOOL; stdcall;

function CryptSignHashW(
              hHash : HCRYPTHASH;
              dwKeySpec : DWORD;
              sDescription : LPCWSTR;
              dwFlags : DWORD;
              pbSignature : PBYTE;
              var dwSigLen : DWORD) : BOOL; stdcall;

function CryptSignHash(
              hHash : HCRYPTHASH;
              dwKeySpec : DWORD;
              sDescription : PChar;
              dwFlags : DWORD;
              pbSignature : PBYTE;
              var dwSigLen : DWORD) : BOOL; stdcall;

function CryptVerifySignatureA(
             hHash : HCRYPTHASH;
             pbSignature : PBYTE;
             dwSigLen : DWORD;
             hPubKey : HCRYPTKEY;
             sDescription : LPCTSTR;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptVerifySignatureW(
             hHash : HCRYPTHASH;
             pbSignature : PBYTE;
             dwSigLen : DWORD;
             hPubKey : HCRYPTKEY;
             sDescription : LPCWSTR;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptVerifySignature(
             hHash : HCRYPTHASH;
             pbSignature : PBYTE;
             dwSigLen : DWORD;
             hPubKey : HCRYPTKEY;
             sDescription : PChar;
             dwFlags : DWORD) : BOOL; stdcall;

function CryptSetProviderA(
             pszProvName : LPCTSTR;
             dwProvType : DWORD) : BOOL; stdcall;

function CryptSetProviderW(
             pszProvName : LPCWSTR;
             dwProvType : DWORD) : BOOL; stdcall;

function CryptSetProvider(
             pszProvName : PChar;
             dwProvType : DWORD) : BOOL; stdcall;


{  Warning for CryptEnumProviders !
QuickInfo
  Windows NT: Requires version 5.0 or later.
  Windows: Unsupported.             !!!!!!!!!!!!! win98 supported
  Windows CE: Unsupported.
  ...
}

function CryptEnumProvidersA(
             dwIndex : DWORD;          // in
             pdwReserved : PDWORD;     // in
             dwFlags : DWORD;          // in
             var pdwProvType : DWORD;  // out
             pszProvName : LPTSTR;     // out
             var pcbProvName :DWORD    // in/out
             ) : BOOL; stdcall;

function CryptEnumProvidersW(
             dwIndex : DWORD;          // in
             pdwReserved : PDWORD;     // in
             dwFlags : DWORD;          // in
             var pdwProvType : DWORD;  // out
             pszProvName : LPTSTR;     // out
             var pcbProvName :DWORD    // in/out
             ) : BOOL; stdcall;

function CryptEnumProviders(
             dwIndex : DWORD;          // in
             pdwReserved : PDWORD;     // in
             dwFlags : DWORD;          // in
             var pdwProvType : DWORD;  // out
             pszProvName : PChar;      // out
             var pcbProvName :DWORD    // in/out
             ) : BOOL; stdcall;

implementation

Const
   Dll = 'ADVAPI32.DLL';

function GET_ALG_CLASS(x : DWORD): DWORD;
begin
  Result := (x and (7 shl 13));
end;

function GET_ALG_TYPE(x : DWORD): DWORD;
begin
  Result := (x and (15 shl 9));
end;

function GET_ALG_SID(x : DWORD): DWORD;
begin
 Result := (x and (511));
end;

function CryptAcquireContextA; external Dll name 'CryptAcquireContextA';
function CryptAcquireContextW; external Dll name 'CryptAcquireContextW';
function CryptAcquireContext; external Dll name 'CryptAcquireContextA';
function CryptReleaseContext; external Dll name 'CryptReleaseContext';
function CryptGenKey; external Dll name 'CryptGenKey';
function CryptDeriveKey; external Dll name 'CryptDeriveKey';
function CryptDestroyKey; external Dll name 'CryptDestroyKey';
function CryptSetKeyParam; external Dll name 'CryptSetKeyParam';
function CryptGetKeyParam; external Dll name 'CryptGetKeyParam';
function CryptSetHashParam; external Dll name 'CryptSetHashParam';
function CryptGetHashParam; external Dll name 'CryptGetHashParam';
function CryptSetProvParam; external Dll name 'CryptSetProvParam';
function CryptGetProvParam; external Dll name 'CryptGetProvParam';
function CryptGenRandom; external Dll name 'CryptGenRandom';
function CryptGetUserKey; external Dll name 'CryptGetUserKey';
function CryptExportKey; external Dll name 'CryptExportKey';
function CryptImportKey; external Dll name 'CryptImportKey';
function CryptEncrypt; external Dll name 'CryptEncrypt';
function CryptDecrypt; external Dll name 'CryptDecrypt';
function CryptCreateHash; external Dll name 'CryptCreateHash';
function CryptHashData; external Dll name 'CryptHashData';
function CryptHashSessionKey; external Dll name 'CryptHashSessionKey';
function CryptDestroyHash; external Dll name 'CryptDestroyHash';
function CryptSignHashA; external Dll name 'CryptSignHashA';
function CryptSignHashW; external Dll name 'CryptSignHashW';
function CryptSignHash; external Dll name 'CryptSignHashA';
function CryptVerifySignatureA; external Dll name 'CryptVerifySignatureA';
function CryptVerifySignatureW; external Dll name 'CryptVerifySignatureW';
function CryptVerifySignature; external Dll name 'CryptVerifySignatureA';
function CryptSetProviderA; external Dll name 'CryptSetProviderA';
function CryptSetProviderW; external Dll name 'CryptSetProviderW';
function CryptSetProvider; external Dll name 'CryptSetProviderA';
function CryptEnumProvidersA; external Dll name 'CryptEnumProvidersA';
function CryptEnumProvidersW; external Dll name 'CryptEnumProvidersW';
function CryptEnumProviders; external Dll name 'CryptEnumProvidersA';

end.
