unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, WinCrypt, ComCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    ListBox1: TListBox;
    Label5: TLabel;
    Edit4: TEdit;
    Label6: TLabel;
    ListView1: TListView;
    Button1: TButton;
    ComboBox1: TComboBox;
    StatusBar1: TStatusBar;
    Button2: TButton;
    OpenDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    inFName, outFName : String;
    procedure GetCSPParams(CSP : String; dwProvType : DWORD);
  end;

  function EncryptFile(inFileName, OutFileName : String) : BOOL;
  function DecryptFile(inFileName, OutFileName : String) : BOOL;
  function WriteUserKey : BOOL;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  inFName  := ExtractFileName(ParamStr(0));
  outFName := ExtractFileName(ParamStr(0));
end;

procedure CheckCrypt(aValue : BOOL);
var
  i : integer;
  s : string;
begin
  if not aValue then begin
    i := GetLastError;
    if i <> 0 then  begin
      s := SysErrorMessage(i);
      if Length(s) = 0 then s := 'Error code #'+IntToHex(i,8);
      Raise Exception.Create(s);
    end;
  end;
end;

function GetCSPname(hProv : HCRYPTPROV) : String;
var
  dwNameLen : DWORD;
  szName : array[0..100] of CHAR;
begin
  dwNameLen := SizeOf(szName);
  CryptGetProvParam(hProv,PP_NAME,@szName[0],dwNameLen,0);
  Result := szName;
end;

function GetCSPContainerName(hProv : HCRYPTPROV) : String;
var
  dwNameLen : DWORD;
  szName : array[0..100] of CHAR;
begin
  dwNameLen := SizeOf(szName);
  CryptGetProvParam(hProv,PP_CONTAINER,@szName[0],dwNameLen,0);
  Result := szName;
end;

function GetCSPversion(hProv : HCRYPTPROV) : DWORD;
var
  dwNameLen : DWORD;
begin
  dwNameLen := SizeOf(Result);
  CryptGetProvParam(hProv,PP_VERSION,@Result,dwNameLen,0);
end;

function GetCSPimptype(hProv : HCRYPTPROV) : DWORD;
var
  dwNameLen : DWORD;
begin
  dwNameLen := SizeOf(Result);
  CryptGetProvParam(hProv,PP_IMPTYPE,@Result,dwNameLen,0);
end;

procedure GetCSPcontainerNames(hProv : HCRYPTPROV; cNames : TStrings);
var
  dwNameLen : DWORD;
  dwFlags : DWORD;
  szName : array[0..100] of CHAR;
  Res : BOOL;
begin
  cNames.Clear;
  dwNameLen := SizeOf(szName);
  dwFlags := CRYPT_FIRST;
  repeat
    Res := CryptGetProvParam(hProv,PP_ENUMCONTAINERS,@szName[0],dwNameLen,dwFlags);
    if Res then cNames.Add(szName);
    dwFlags := 0;
  until not Res;
end;

function GetCSPAlgInfo(hProv : HCRYPTPROV; var pbData : array of PROV_ENUMALGS) : integer;
var
  dwSize : DWORD;
  dwFlags : DWORD;
  Res : BOOL;
begin
  dwSize := SizeOf(PROV_ENUMALGS);
  dwFlags := CRYPT_FIRST;
  Result := low(pbData);
  repeat
    FillChar(pbData[Result], SizeOf(PROV_ENUMALGS), 0);
    Res := CryptGetProvParam(hProv,PP_ENUMALGS,@pbData[Result],dwSize,dwFlags);
    if Res then inc(Result);
    dwFlags := 0;
  until (not Res) or (Result > High(pbData));
  Dec(Result);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Res : BOOL;
  dwIndex : DWORD;
  pdwProvType : DWORD;
  pszProvName : PChar;
  pcbProvName :DWORD;
begin
  dwIndex := 0;
  ComboBox1.Items.Clear;
  repeat
    Res := CryptEnumProviders(dwIndex,nil,0,pdwProvType,nil,pcbProvName);
    if Res then begin
      pszProvName := StrAlloc(pcbProvName+1);
      Res := CryptEnumProviders(dwIndex,nil,0,pdwProvType,
             pszProvName,pcbProvName);
      ComboBox1.Items.AddObject(pszProvName,Pointer(pdwProvType));
      StrDispose(pszProvName);
      inc(dwIndex);
    end;
  until not Res;
  ComboBox1.ItemIndex := 0;
  ComboBox1Change(Self);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  with ComboBox1 do
  if (ItemIndex >= 0) and (ItemIndex < Items.Count) then
  GetCSPParams(Items[ItemIndex], DWORD(Items.Objects[ItemIndex]));
end;

procedure TForm1.Button4Click(Sender: TObject);
var
//  hProv : HCRYPTPROV;
//  hKey  : HCRYPTKEY;
//  CSP : String;
//  dwProvType : DWORD;
  s : string;
  i : integer;
begin
{  with ComboBox1 do
  if (ItemIndex >= 0) and (ItemIndex < Items.Count) then begin
    CSP := Items[ItemIndex];
    dwProvType := DWORD(Items.Objects[ItemIndex]);
  end else begin
    MessageBeep(0);
    Exit;
  end;

 if CryptAcquireContext(hProv,nil,PChar(CSP),dwProvType,0) or
    CryptAcquireContext(hProv,nil,PChar(CSP),dwProvType,CRYPT_NEWKEYSET) then
 try
   if not CryptGetUserKey(hProv,AT_SIGNATURE,hKey) then begin
     if GetLastError = NTE_NO_KEY then begin
       CheckCrypt(CryptGenKey(hProv,AT_SIGNATURE,0,hKey));
       CryptDestroyKey(hKey);
     end else
       Raise Exception.Create('Error during CryptGetUserKey');
   end else CryptDestroyKey(hKey);

   if not CryptGetUserKey(hProv,AT_KEYEXCHANGE,hKey) then begin
        if GetLastError = NTE_NO_KEY then begin
          CheckCrypt(CryptGenKey(hProv,AT_KEYEXCHANGE,0,hKey));
          CryptDestroyKey(hKey);
        end else
          Raise Exception.Create('Error during CryptGetUserKey');
   end else CryptDestroyKey(hKey);
 finally
   CryptReleaseContext(hProv, 0);
 end;
}
 WriteUserKey;

 i := GetLastError;
 s := SysErrorMessage(i);
 if Length(s) = 0 then s := 'Error code #'+IntToHex(i,8);
 StatusBar1.SimpleText := s;
end;

procedure TForm1.GetCSPParams(CSP : String; dwProvType : DWORD);
var
  hProv : HCRYPTPROV;
  s : string;
  pbData : array[0..100] of PROV_ENUMALGS;
  i, j : integer;
begin
 StatusBar1.SimpleText := '';
 Edit2.Text := '';
 Edit3.Text := '';
 Edit4.Text := '';
 ListView1.Items.Clear;
 ListBox1.Items.Clear;

// if not CryptSetProvParam(0,PP_CLIENT_HWND,Pointer(Handle),0) then
// MessageBeep(0);

 if CryptAcquireContext(hProv,nil,PChar(CSP),dwProvType,0) or
    CryptAcquireContext(hProv,nil,PChar(CSP),dwProvType,CRYPT_NEWKEYSET) then
 try
   Edit2.Text := IntToStr((GetCSPversion(hProv) shr 8)  and $FF) + '.'+IntToStr(GetCSPversion(hProv) and $FF);
   case GetCSPimptype(hProv) of
     CRYPT_IMPL_HARDWARE : s := 'HARDWARE';
     CRYPT_IMPL_SOFTWARE : s := 'SOFTWARE';
     CRYPT_IMPL_MIXED    : s := 'MIXED';
   else
     s := 'UNKNOWN';
   end;
   Edit3.Text := s;
   GetCSPcontainerNames(hProv,ListBox1.Items);
   Edit4.Text := GetCSPContainerName(hProv);
   i := GetCSPAlgInfo(hProv,pbData);
   with ListView1.Items do
   try
     BeginUpdate;
     for j := 0 to i do
     with Add, pbData[j] do begin
       case aiAlgid of
         CALG_MD2       : Caption := 'MD2';
         CALG_MD4       : Caption := 'MD4';
         CALG_MD5       : Caption := 'MD5';
         CALG_SHA       : Caption := 'SHA';
         CALG_MAC       : Caption := 'MAC';
         CALG_RSA_SIGN  : Caption := 'RSA_SIGN';
         CALG_DSS_SIGN  : Caption := 'DSS_SIGN';
         CALG_RSA_KEYX  : Caption := 'RSA_KEYX';
         CALG_DES       : Caption := 'DES';
         CALG_RC2       : Caption := 'RC2';
         CALG_RC4       : Caption := 'RC4';
         CALG_SEAL      : Caption := 'SEAL';
       else
          Caption := IntToStr(aiAlgid);
       end;

      case GET_ALG_CLASS(aiAlgid) of
        ALG_CLASS_ANY          : s := 'ANY';
        ALG_CLASS_SIGNATURE    : s := 'SIGNATURE';
        ALG_CLASS_MSG_ENCRYPT  : s := 'MSG_ENCRYPT';
        ALG_CLASS_DATA_ENCRYPT : s := 'DATA_ENCRYPT';
        ALG_CLASS_HASH         : s := 'HASH';
        ALG_CLASS_KEY_EXCHANGE : s := 'KEY_EXCHANGE';
      else s := 'UNKNOWN';
      end;
      SubItems.Add(s);

      case GET_ALG_TYPE(aiAlgid) of
        ALG_TYPE_ANY    : s := 'ANY';
        ALG_TYPE_DSS    : s := 'DSS';
        ALG_TYPE_RSA    : s := 'RSA';
        ALG_TYPE_BLOCK  : s := 'BLOCK';
        ALG_TYPE_STREAM : s := 'STREAM';
      else s := 'UNKNOWN';
      end;
      SubItems.Add(s);

      //case GET_ALG_SID(aiAlgid) of
      //end;

       SubItems.Add(IntToStr(dwBitLen));
       SubItems.Add(szName);
     end;
   finally
     EndUpdate;
   end;
   // Align columns width :(
   with ListView1.Items do
   try
     BeginUpdate;
   finally
     EndUpdate;
   end;
 finally
   CryptReleaseContext(hProv, 0);
 end;

 i := GetLastError;
 s := SysErrorMessage(i);
 if Length(s) = 0 then s := 'Error code #'+IntToHex(i,8);
 StatusBar1.SimpleText := s;

end;

//Introduction

procedure TForm1.Button2Click(Sender: TObject);
begin
   StatusBar1.SimpleText := '';
   with OpenDlg do begin
     Filter := 'All files (*.*)|*.*';
     Options := [ofPathMustExist, ofNoNetworkButton];
     Title := 'Source file for encrypt';
     InitialDir := ExtractFilePath(ParamStr(0));
     FileName := ExtractFileName(inFName);
     if Execute then begin
        inFName := FileName;
        with SaveDlg do begin
          Filter := 'All files (*.*)|*.*';
          Options := [ofPathMustExist, ofNoNetworkButton];
          Title := 'Destination file name';
          FileName := ExtractFileName(outFName);
          if Execute then begin
             outFName := FileName;
             if EncryptFile(inFName,outFName) then
                StatusBar1.SimpleText := 'Ok'
             else
                StatusBar1.SimpleText := 'Encryption error';
          end;
        end;
     end;
   end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   StatusBar1.SimpleText := '';
   with OpenDlg do begin
     Filter := 'All files (*.*)|*.*';
     Options := [ofPathMustExist, ofNoNetworkButton];
     Title := 'Source file for decrypt';
     InitialDir := ExtractFilePath(ParamStr(0));
     FileName := ExtractFileName(inFName);
     if Execute then begin
        inFName := FileName;
        with SaveDlg do begin
          Filter := 'All files (*.*)|*.*';
          Options := [ofPathMustExist, ofNoNetworkButton];
          Title := 'Destination file name';
          FileName := ExtractFileName(outFName);
          if Execute then begin
             outFName := FileName;
             if DecryptFile(inFName,outFName) then
                StatusBar1.SimpleText := 'Ok'
             else
                StatusBar1.SimpleText := 'Decryption error';
          end;
        end;
     end;
   end;
end;



/////////////////////////////////////////////
//  Examples file encryption & decryption
//  Win32 Programmer's Reference
//  section : Encryption Example
//            Decryption Example
/////////////////////////////////////////////


Const
  BLOCK_SIZE = 160;
  BUFFER_SIZE = (BLOCK_SIZE+16);

// Encryption Example
function EncryptFile(inFileName, OutFileName : String) : BOOL;

var
  hProv : HCRYPTPROV;
  hKey, hXchgKey : HCRYPTKEY;
  dwBlobLen : DWORD;
  hBlob : THandle;
  pbKeyBlob : PBYTE;
  hFile, hFileW : THandle;
  lpNumberOfBytes : DWORD;
  pbBuffer : PBYTE;
  eof : BOOL;
begin
  Result := FALSE;
  GetMem(pbBuffer, BUFFER_SIZE);
  try
    // Get handle to the default provider
    CheckCrypt(CryptAcquireContext(hProv,nil,nil,PROV_RSA_FULL,0));
    try
      // Get handle to key exchange key
      //CheckCrypt(CryptGetUserKey(hProv,AT_KEYEXCHANGE,hXchgKey));
      CheckCrypt(CryptGenKey(hProv,CALG_RSA_KEYX,0,hXchgKey)); // or CRYPT_USER_PROTECTED
      try
        // Create a random block cipher session key
        CheckCrypt(CryptGenKey(hProv,CALG_RC2,CRYPT_EXPORTABLE,hKey));
        try
          // Determine size of key blob and allocate memory
          CheckCrypt(CryptExportKey(hKey, hXchgKey, SIMPLEBLOB, 0, nil, dwBlobLen));
          hBlob := GlobalAlloc(GMEM_MOVEABLE, dwBlobLen);
          if hBlob <> 0 then
          try
             pbKeyBlob := GlobalLock(hBlob);
             if pbKeyBlob <> nil then
             try
               // Export key into a simple key blob
               CheckCrypt(CryptExportKey(hKey, hXchgKey, SIMPLEBLOB, 0, pbKeyBlob, dwBlobLen));
               // Open source file
               hFile := CreateFile(PChar(inFileName), GENERIC_READ or GENERIC_WRITE,
                        FILE_SHARE_READ, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
               if hFile = INVALID_HANDLE_VALUE then
                  Raise Exception.Create(SysErrorMessage(GetLastError));
               try
                 // Open destination file
                 hFileW := CreateFile(PChar(OutFileName), GENERIC_READ or GENERIC_WRITE,
                           0, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
                 if hFileW = INVALID_HANDLE_VALUE then
                    Raise Exception.Create(SysErrorMessage(GetLastError));
                 try
                   // Write size of key blob to destination file
                   WriteFile(hFileW, dwBlobLen, SizeOf(DWORD), lpNumberOfBytes, nil);
                   // Write key blob to destination file
                   WriteFile(hFileW, pbKeyBlob^, dwBlobLen, lpNumberOfBytes, nil);
                   repeat
                     // Encrypt source file and write to destination file
                     if not ReadFile(hFile,pbBuffer^,BLOCK_SIZE,lpNumberOfBytes,nil) then begin
                        eof := GetLastError = ERROR_HANDLE_EOF;
                        if not eof then
                           Raise Exception.Create(SysErrorMessage(GetLastError));
                     end else eof := lpNumberOfBytes <> BLOCK_SIZE;
                     // Encrypt data
                     CheckCrypt(CryptEncrypt(hKey, 0, eof, 0, pbBuffer, lpNumberOfBytes, BUFFER_SIZE));
                     // Write data to destination file
                     WriteFile(hFileW, pbBuffer^, lpNumberOfBytes, lpNumberOfBytes, nil);
                   until eof;
                   Result := TRUE;
                 finally
                   CloseHandle(hFileW);
                 end;
               finally
                 CloseHandle(hFile);
               end;
             finally
               GlobalUnlock(hBlob);
             end;
          finally
            GlobalFree(hBlob);
          end;
        finally
          CryptDestroyKey(hKey);
        end;
      finally
        CryptDestroyKey(hXchgKey);
      end;
    finally
      CryptReleaseContext(hProv, 0);
    end;
  finally
    FreeMem(pbBuffer, BUFFER_SIZE);
  end;
end;

function DecryptFile(inFileName, OutFileName : String) : BOOL;
var
  hProv : HCRYPTPROV;
  hKey : HCRYPTKEY;
  dwBlobLen : DWORD;
  hBlob : THandle;
  pbKeyBlob : PBYTE;
  hFile, hFileW : THandle;
  lpNumberOfBytes : DWORD;
  pbBuffer : PBYTE;
  eof : BOOL;
begin
  Result := FALSE;
  GetMem(pbBuffer, BUFFER_SIZE);
  try
    // Get handle to the default provider
    CheckCrypt(CryptAcquireContext(hProv,nil,nil,PROV_RSA_FULL,0));
    try
      // Open source file
      hFile := CreateFile(PChar(inFileName), GENERIC_READ or GENERIC_WRITE,
               FILE_SHARE_READ, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
      if hFile = INVALID_HANDLE_VALUE then
         Raise Exception.Create(SysErrorMessage(GetLastError));
      try
        // Read key blob length from source file and allocate memory
        if (not ReadFile(hFile,dwBlobLen,SizeOf(DWORD),lpNumberOfBytes,nil)) or
           (lpNumberOfBytes <>  SizeOf(DWORD)) then
           Raise Exception.Create('Error reading data!');
        hBlob := GlobalAlloc(GMEM_MOVEABLE, dwBlobLen);
        if hBlob <> 0 then
        try
          pbKeyBlob := GlobalLock(hBlob);
          if pbKeyBlob <> nil then
          try
            // Read key blob from source file
            if (not ReadFile(hFile,pbKeyBlob^,dwBlobLen,lpNumberOfBytes,nil)) or
               (lpNumberOfBytes <>  dwBlobLen) then
               Raise Exception.Create(SysErrorMessage(GetLastError));
            // Import key blob into CSP
            CheckCrypt(CryptImportKey(hProv, pbKeyBlob, dwBlobLen, 0, 0, hKey));
            try
              // Open destination file
              hFileW := CreateFile(PChar(OutFileName), GENERIC_READ or GENERIC_WRITE,
                        0, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
              if hFileW = INVALID_HANDLE_VALUE then
                 Raise Exception.Create(SysErrorMessage(GetLastError));
              try
                // Decrypt source file and write to destination file
                repeat
                  if not ReadFile(hFile,pbBuffer^,BLOCK_SIZE,lpNumberOfBytes,nil) then begin
                     eof := GetLastError = ERROR_HANDLE_EOF;
                     if not eof then
                        Raise Exception.Create(SysErrorMessage(GetLastError));
                  end else eof := lpNumberOfBytes <> BLOCK_SIZE;
                  CheckCrypt(CryptDecrypt(hKey, 0, eof, 0, pbBuffer, lpNumberOfBytes));
                  // Write data to destination file
                  WriteFile(hFileW, pbBuffer^, lpNumberOfBytes, lpNumberOfBytes, nil);
                until eof;
                Result := TRUE;
              finally
                CloseHandle(hFileW);
              end;
            finally
              CryptDestroyKey(hKey);
            end;
          finally
            GlobalUnlock(hBlob);
          end;
        finally
          GlobalFree(hBlob);
        end;
      finally
        CloseHandle(hFile);
      end;
    finally
      CryptReleaseContext(hProv, 0);
    end;
  finally
    FreeMem(pbBuffer, BUFFER_SIZE);
  end;
end;

////////////////////////////////////////////////////

function WriteUserKey : BOOL;
Const
  FileName = 'UserKey.mcp';

var
  hProv : HCRYPTPROV;
  hKey, hXchgKey : HCRYPTKEY;
  dwBlobLen : DWORD;
  hBlob : THandle;
  pbKeyBlob : PBYTE;
  hFileW : THandle;
  lpNumberOfBytes : DWORD;
begin
  Result := FALSE;
    // Get handle to the default provider
    if CryptAcquireContext(hProv,nil,nil,PROV_RSA_FULL,0) or
       CryptAcquireContext(hProv,nil,nil,PROV_RSA_FULL,CRYPT_NEWKEYSET) then
    try
      if not CryptGetUserKey(hProv,AT_SIGNATURE,hKey) then begin
        if GetLastError = NTE_NO_KEY then begin
          CheckCrypt(CryptGenKey(hProv,AT_SIGNATURE,0,hKey));
          CryptDestroyKey(hKey);
        end else
          Raise Exception.Create('Error during CryptGetUserKey');
      end else CryptDestroyKey(hKey);
      if not CryptGetUserKey(hProv,AT_KEYEXCHANGE,hKey) then begin
        if GetLastError = NTE_NO_KEY then begin
          CheckCrypt(CryptGenKey(hProv,AT_KEYEXCHANGE,0,hKey));
          CryptDestroyKey(hKey);
        end else
          Raise Exception.Create('Error during CryptGetUserKey');
      end else CryptDestroyKey(hKey);


      CheckCrypt(CryptGetUserKey(hProv,AT_KEYEXCHANGE,hXchgKey));
      try
        CheckCrypt(CryptGetUserKey(hProv,AT_SIGNATURE,hKey));
        try
          // Determine size of key blob and allocate memory
          CheckCrypt(CryptExportKey(hXchgKey, 0, PUBLICKEYBLOB, 0, nil, dwBlobLen));
          hBlob := GlobalAlloc(GMEM_MOVEABLE, dwBlobLen);
          if hBlob <> 0 then
          try
             pbKeyBlob := GlobalLock(hBlob);
             if pbKeyBlob <> nil then
             try
               // Export key into a simple key blob
               CheckCrypt(CryptExportKey(hXchgKey, 0, PUBLICKEYBLOB, 0, pbKeyBlob, dwBlobLen));

               // Open destination file
               hFileW := CreateFile(FileName, GENERIC_READ or GENERIC_WRITE,
                         0, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
               if hFileW = INVALID_HANDLE_VALUE then
                  Raise Exception.Create(SysErrorMessage(GetLastError));
               try
                 // Write size of key blob to destination file
                 WriteFile(hFileW, dwBlobLen, SizeOf(DWORD), lpNumberOfBytes, nil);
                 // Write key blob to destination file
                 WriteFile(hFileW, pbKeyBlob^, dwBlobLen, lpNumberOfBytes, nil);
                 Result := TRUE;
               finally
                 CloseHandle(hFileW);
               end;
             finally
               GlobalUnlock(hBlob);
             end;
          finally
            GlobalFree(hBlob);
          end;
        finally
          CryptDestroyKey(hKey);
        end;
      finally
        CryptDestroyKey(hXchgKey);
      end;
    finally
      CryptReleaseContext(hProv, 0);
    end;
end;



end.
