/*
**  UECHOS.C [UDP Echo Server Example]
**
**  UDP Echo Server
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include "wil.h"
#include "str.h"
#include "cons.h"

#define MAX_STR  128
#define MAX_BUF 1024

#define ECHO_PORT 16123

static char Buffer[MAX_BUF];
static char Temp[MAX_BUF+8];

/* display error */

static void DisplayError(int Code, LPSTR Msg)
{printf("ERROR: ");
 if(Msg) printf("%s",Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,MAX_BUF);
    printf("%s",(LPSTR)Temp);
   }
 else printf("\n");
}

/* display error & exit (before calling wilAttach) */

void SayError(LPSTR Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

void ShutDown(void)
{printf("Shutting down...");
 wilRelease();
 exit(0);
}

/*** main ***/

void main(int argc, char *argv[])
{int Code;
 int BytesRead;
 static LPSTR RemoteDotted[15];
 SOCKET Socket;

 /* check args */
 if(argc!=1)
   {printf("Usage: UECHOS\n");
    exit(1);
   }

 /* attach WINSOCK */
 printf("Attaching WINSOCK...");
 Code = wilAttach();
 printf("OK\n");
 if(Code<0) DisplayError(Code,"wilAttach fails:");
 else
   {
    wilGetDescription((LPSTR)Temp, MAX_BUF);
    printf(" Description: %s\n",(LPSTR)Temp);

    wilGetMyHostName((LPSTR)Temp, MAX_BUF);
    printf("My Host Name: %s\n",(LPSTR)Temp);

    wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
    printf("My Host Addr: %s\n",(LPSTR)Temp);

    Code = wilGetMaxUDPSize();
    printf("Max UDP Size: %d\n", Code);
   }
 /* create UDP socket */
 Socket = wilUdpSocket();
 if((int)Socket<0)
    {DisplayError((int)Code, "wilUdpSocket: ");
     exit(1);
    }
 /* bind to local port */
 Code = wilBind(Socket,0,ECHO_PORT);
 if(Code<0) DisplayError(Code,"wilBind fails: ");
 printf("Waiting for incoming UDP packets on port %d...\n", ECHO_PORT);
 /* receive UDP datagram */
 while(1)
   {BytesRead = wilReadUdpSocket(Socket, (LPSTR)Buffer, MAX_BUF, (LPSTR)RemoteDotted);
    if(BytesRead<0)
      {DisplayError((int)BytesRead, "wilReadUdpSocket: ");
       break;
      }
    if(BytesRead>0)
      {printf("Received %d bytes [%s] from %s\n", BytesRead, Buffer, RemoteDotted);
       /* echo back to client */
       Code = wilWriteUdpSocket(Socket, (LPSTR)Buffer, BytesRead, 0, 0);
       if(Code<0)
         {DisplayError((int)Code, "wilWriteUdpSocket: ");
          break;
         }
       if(Code>0) printf("Buffer echoed back to client\n");
      }
     Sleep(0);
    }
 wilCloseSocket(Socket,500);
 wilRelease();
} /* end main */


