/*
**  UECHOS.C [UDP Echo Client Example]
**
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include "wil.h"
#include "str.h"
#include "cons.h"

#define MAX_STR  128
#define MAX_BUF 1024

#define ECHO_PORT 16123

static char Temp[MAX_BUF+8];
static char Buffer[MAX_BUF+1];

/* display error */

static void DisplayError(int Code, LPSTR Msg)
{printf("ERROR: ");
 if(Msg) printf("%s",Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,MAX_BUF);
    printf("%s",(LPSTR)Temp);
   }
 else printf("\n");
}

/* display error & exit (before calling wilAttach) */

void SayError(LPSTR Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

void ShutDown(void)
{printf("Shutting down...");
 wilRelease();
 exit(0);
}

/*** main ***/

void main(int argc, char *argv[])
{int  Code;
 LPSTR TextPtr;
 LPSTR AddrPtr;
 SOCKET Socket;
 ULONG RemoteIP;
 long  BytesRead;
 /* check args */
 if(argc!=3)
   {printf("Usage: UECHOC text addr\n");
    exit(1);
   }
 TextPtr = argv[1];
 AddrPtr = argv[2];

 /* attach WINSOCK */
 printf("Attaching WINSOCK...");
 Code = wilAttach();
 printf("OK\n");
 if(Code<0) DisplayError(Code,"wilAttach fails:");
 else
   {
    wilGetDescription((LPSTR)Temp, MAX_BUF);
    printf(" Description: %s\n",(LPSTR)Temp);

    wilGetMyHostName((LPSTR)Temp, MAX_BUF);
    printf("My Host Name: %s\n",(LPSTR)Temp);

    wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
    printf("My Host Addr: %s\n",(LPSTR)Temp);

    Code = wilGetMaxUDPSize();
    printf("Max UDP Size: %d\n", Code);
   }

 /* create UDP socket */
 Socket = wilUdpSocket();
 if((int)Socket<0)
    {DisplayError((int)Code, "wilUdpSocket: ");
     exit(1);
    }

 /* get remote IP address */
 if(wilIsDotted(AddrPtr))
   {/* user entered dotted address */
    RemoteIP = wilMakeAddr(AddrPtr);
   }
 else
   {/* lookup 1st host address */
    RemoteIP = wilGetHostAddr(AddrPtr,0);
   }

 printf("RemoteIP = %x hex\n", RemoteIP);
 if(RemoteIP==0) DisplayError(Code,"wilGetHostAddr: ");

 /* bind to address (using any local port) */
 Code = wilBind(Socket,0,0);

 if(Code<0) DisplayError(Code,"wilBind fails:");

 printf("Sending UDP packet [%s] to %s on port %d\n", TextPtr, AddrPtr, ECHO_PORT);
 /* send UDP datagram */
 Code = wilWriteUdpSocket(Socket, (LPSTR)TextPtr, strlen(TextPtr),RemoteIP,ECHO_PORT);
 if(Code<0) DisplayError((int)Code, "wilWriteUdpSocket: ");
 else printf("%d bytes sent; awaiting response.\n", Code);

 /* wait for response */
 while(1)
    {BytesRead = wilReadUdpSocket(Socket, (LPSTR)Buffer, MAX_BUF, NULL);
     if(BytesRead<0)
       {DisplayError((int)BytesRead, "wilReadUdpSocket: ");
        break;
       }
     if(BytesRead>=0)
       {printf("Received %d bytes [%s] from remote.\n", BytesRead, Buffer);
        break;
       }
     Sleep(500); printf(".");
    }
 printf("Closing socket\n");
 wilCloseSocket(Socket,500);
 wilRelease();
 printf("Done.\n");
} /* end main */


