//---------------------------------------------------------------------------
//
//  FINGER.CPP
//
//  Synchronous FINGER program for Borland C Builder
//  Win32 console program.
//
//  FINGER program comparison
//
//    (1) AFINGR -- asyncronous version.
//    (2) BFINGR -- asyncronous version (using ASYNC.C functions).
//    (3) SFINGR -- synchronous version.
//    (4) CFINGR -- synchronous version (Win32 CONSOLE program).
//    (5) FINGER -- state driven version.
//

#include <vcl\condefs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <conio.h>
#include <winsock.h>

#include "wil.h"
#include "str.h"

#pragma hdrstop

#define MAX_STR  50
#define MAX_BUF 256
#define FINGER_PORT 79

static char Temp[MAX_BUF+8];
static int  InBufLen = 0;
static char InBuffer[MAX_BUF+1];
static char UserName[MAX_STR] = "";
static char HostName[MAX_STR] = "";
static SOCKET Socket = 0;
static ULONG  HostAddr = 0;
static LPSTR  Ptr;

static void DisplayError(int Code, LPSTR Msg)
{cout << "ERROR: ";
 if(Msg) cout << Msg;
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,MAX_BUF);
    cout << Temp;
   }
 cout << endl;
}

// display error & exit (before calling wilAttach)

void SayError(LPSTR Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

void ShutDown(void)
{cout << "Shutting down...";
 wilRelease();
 exit(0);
}

int Finger(void)
{char c;
 int  Code;
 // attach WINSOCK
 cout << "Attaching WINSOCK...";
 Code = wilAttach();
 cout << "OK" << endl;
 if(Code<0) DisplayError(Code,"wilAttach fails:");
 else
   {cout << " Description: ";
    wilGetDescription((LPSTR)Temp, MAX_BUF);
    cout << Temp << endl;
    cout << "My Host Name: ";
    wilGetMyHostName((LPSTR)Temp, MAX_BUF);
    cout << Temp << endl;
    cout << "My Host Addr: ";
    wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
    cout << Temp << endl;
   }
 // get next finger request from user
 while(TRUE)
   {InBufLen = 0;
    cout << endl;
    cout << "Finger Client: Type CTRL-Z to quit" << endl;
    cout << "Enter user@host: ";
    // get response
    while(TRUE)
      {// fetch & echo character
       c = (char) getch();
       putchar(c);
       // did user type ESC ?
       if(c==0x1b)
         {InBufLen = 0;
          cout << endl;
          continue;
         }
       // did user type CTRL-Z
       if(c==0x1a) ShutDown();
       // programmer note: need to handle BS here
       if(c=='\r')
         {// user has completed input
          if(InBufLen==0) ShutDown();
          cout << endl;
          InBuffer[InBufLen++] = '\0';
          // execute command
          wsprintf((LPSTR)Temp,"\r\nUser@Host: %s",(LPSTR)InBuffer);
          cout << Temp;
          // extract user & host names
          Ptr = StringChar((LPSTR)InBuffer,'@');
          if(Ptr==NULL)
            {DisplayError(Code, "Cannot recognize User@Host");
             break;
            }
          *Ptr = '\0';
          lstrcpy((LPSTR)UserName, (LPSTR)InBuffer);
          lstrcpy((LPSTR)HostName, (LPSTR)(++Ptr));
          wsprintf((LPSTR)Temp,"User ='%s'", (LPSTR)UserName);
          cout << Temp << endl;
          wsprintf((LPSTR)Temp,"Host ='%s'", (LPSTR)HostName);
          cout << Temp << endl;
          // get host name
          if(wilIsDotted((LPSTR)HostName))
            {// already have IP address
             HostAddr = wilMakeAddr((LPSTR)HostName);
            }
          else
            {// ask DNS for IP address
             HostAddr = wilGetHostAddr((LPSTR)HostName,0);
             if(HostAddr==0)
               {DisplayError(0, "Cannot get IP addess");
                break;
               }
            }
          // display remote host address
          cout << "HostAddr = ";
          wilMakeDotted(HostAddr,(LPSTR)Temp,MAX_BUF);
          cout << Temp << endl;
          // create socket
          Socket = wilTcpSocket();
          if((int)Socket<0)
            {DisplayError(Code, NULL);
             break;
            }
          // attempt to connect to remote host
          Code = wilConnect(Socket,HostAddr,FINGER_PORT);
          if(Code<0)
            {DisplayError(Code, NULL);
             break;
            }
          // wait up to 30 seconds for connection
          if(wilIsConnected(Socket,30000))
            cout << "Connected to FINGER server." << endl;
          else
            {DisplayError(0, "Cannot CONNECT");
             break;
            }
          // send user name
          wsprintf((LPSTR)Temp,"%s\r\n",(LPSTR)UserName);
          Code = wilWriteString(Socket,(LPSTR)Temp);
          if(Code<0)
            {DisplayError(Code, NULL);
             break;
            }
          // read socket
          while(1)
            {// read next string
             Code = wilReadLine(Socket,(LPSTR)InBuffer,MAX_BUF);
             if(Code==WIL_EOF) break;
             if(Code<0)
               {DisplayError(Code,"wilReadLine:");
                break;
               }
             if(Code>0)
               {wsprintf((LPSTR)Temp,">%s", (LPSTR)InBuffer);
                cout << Temp;
               }
            } //end-while(1)
          cout << "\r\nFINGER completed.";
          wilCloseSocket(Socket,500);
          break;
         }
       else
         {// add character to buffer
          if(InBufLen<MAX_BUF) InBuffer[InBufLen++] = c;
         }
      } // end-while(TRUE)
   } // end-while(TRUE)
} // end main

