/*
** ECHO_C
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include "wil.h"
#include "str.h"
#include "cons.h"

#define MAX_STR  50
#define MAX_BUF 256

#define ECHO_PORT 7

static char Temp[MAX_BUF+8];
static int  InBufLen = 0;
static char InBuffer[MAX_BUF+1];
//static char HostName[MAX_STR] = "";
static SOCKET Socket = 0;
static ULONG  HostAddr = 0;

static HANDLE ConIn;
static HANDLE ConOut;
static DWORD OldMode;
static DWORD NewMode;


/* display error */

static void DisplayError(int Code, LPSTR Msg)
{PutString(ConOut ,"ERROR: ");
 if(Msg) PutString(ConOut,Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,MAX_BUF);
    PutLine(ConOut,(LPSTR)Temp);
   }
}

/* display error & exit (before calling wilAttach) */

void SayError(LPSTR Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}


void DisplayString(LPSTR String)
{
 PutString(ConOut, String);
}

void DisplayLine(LPSTR String)
{
 PutLine(ConOut, String);
}

void DisplayChar(char Chr)
{
 PutChar(ConOut, Chr);
}

void ShutDown(void)
{DisplayLine("\r\nECHO completed.");
 if(Socket) wilCloseSocket(Socket,500);
 PutLine(ConOut,"Shutting down...");
 wilRelease();
 SetConsoleMode(ConIn, OldMode);
 exit(0);
}


/* get text from user (in InBuffer[]) */

int GetUserInput(void)
{char c;
 InBufLen = 0;
 while(TRUE)
   {/* fetch & echo character */
    c = GetChar(ConIn);
    PutChar(ConOut, c);
    /* did user type ESC ? */
    if(c==0x1b)
      {InBufLen = 0;
       DisplayString("\r\n");
       continue;
      }
    /* did user type CTRL-Z */
    if(c==0x1a) return -1;
    if(c=='\r')
      {/* user has completed input */
       InBuffer[InBufLen] = '\0';
       DisplayString("\n");
       return InBufLen;
      }
    else
      {/* add character to buffer */
       if(InBufLen<MAX_BUF) InBuffer[InBufLen++] = c;
      }
   }
}

/*** main ***/

void main(void)
{int  Code;
 BOOL  Success;
 /* get handles for stdin & stdout */
 ConIn  = GetStdHandle(STD_INPUT_HANDLE);
 ConOut = GetStdHandle(STD_OUTPUT_HANDLE);
 /* modify console mode: disable line input & line echo */
 Success = GetConsoleMode(ConIn, &OldMode);
 if(!Success) SayError("GetConsoleMode");
 NewMode = OldMode & ~ENABLE_LINE_INPUT & ~ENABLE_ECHO_INPUT;
 Success = SetConsoleMode(ConIn, NewMode);
 if(!Success) SayError("SetConsoleMode");
 /* attach WINSOCK */
 DisplayString("Attaching WINSOCK...");
 Code = wilAttach();
 DisplayLine("OK");
 if(Code<0) DisplayError(Code,"wilAttach fails:");
 else
   {DisplayString(" Description: ");
    wilGetDescription((LPSTR)Temp, MAX_BUF);
    DisplayLine((LPSTR)Temp);
    DisplayString("My Host Name: ");
    wilGetMyHostName((LPSTR)Temp, MAX_BUF);
    DisplayLine((LPSTR)Temp);
    DisplayString("My Host Addr: ");
    wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
    DisplayLine((LPSTR)Temp);
   }
 /* get host name from user */
 DisplayLine("\r\nEcho Client: Type CTRL-Z to quit");
 DisplayString("Enter Echo Server host: ");
 /* get response */
 InBufLen = GetUserInput();
 if(InBufLen<=0) ShutDown();
 /* user has completed input */
 PutChar(ConOut,'\n');
 InBuffer[InBufLen++] = '\0';
 if(wilIsDotted((LPSTR)InBuffer))
   {/* user entered dotted address */
    HostAddr = wilMakeAddr((LPSTR)InBuffer);
   }
 else
   {/* lookup host address */
    HostAddr = wilGetHostAddr((LPSTR)InBuffer,0);
    if(HostAddr==0)
      {DisplayError(0, "Cannot get IP addess");
       ShutDown();
      }
   }
 DisplayString("Server Host Addr = ");
 wilMakeDotted(HostAddr,(LPSTR)Temp,MAX_BUF);
 DisplayLine((LPSTR)Temp);
 /* create socket */
 Socket = wilTcpSocket();
 if((int)Socket<0)
   {DisplayError((int)Code, NULL);
    ShutDown();
   }
 /* attempt to connect to remote host */
 Code = wilConnect(Socket,HostAddr,ECHO_PORT);
 if(Code<0)
   {DisplayError(Code, "wilConnect: ");
    ShutDown();
   }
 /* wait up to 30 seconds for connection */
 if(wilIsConnected(Socket,30000)) DisplayLine("Connected to ECHO server.");
 else
   {DisplayError(0, "Cannot CONNECT");
    ShutDown();
   }
 /* get text from user & send to server */
 while(TRUE)
   {DisplayString("Enter text: ");
    InBufLen = GetUserInput();
    if(InBufLen<=0) ShutDown();
    /* send text */
    Code = wilWriteString(Socket,(LPSTR)InBuffer);
    if(Code<0)
      {DisplayError(Code, "wilWriteString: ");
       ShutDown();
      }
    /* get response */
    if(wilDataIsReady(Socket,5000))
      {/* read response */
       *InBuffer = '\0';
       Code = wilReadLine(Socket,(LPSTR)InBuffer,MAX_BUF);
       if(Code==WIL_EOF) ShutDown();
       if(Code<0)
         {DisplayError(Code,"wilReadLine:");
          ShutDown();
         }
       if(Code>0)
         {
          wsprintf((LPSTR)Temp,">%s", (LPSTR)InBuffer);
          DisplayLine((LPSTR)Temp);
         }
      }
   } /* end: while(TRUE)*/
} /* end main */


