/*
**  CWHO_S.C
**
**  Win32 CONSOLE mode "WHO IS" server.
**
**  This is the CONSOLE mode equivalent
**  of the WHO_S server program.
**
**  Connect using the client WHO_C.
**
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "wil.h"
#include "str.h"
#include "cons.h"

#define MAX_STR   50
#define MAX_BUF  256
#define ONE_SEC 1000

#define WHOIS_PORT 5001

static char Temp[MAX_BUF+8];
static char InBuffer[MAX_BUF+1];
static char HostName[MAX_BUF+1];
static ULONG  HostAddr = 0;
static SOCKET ListenSock = 0;
static SOCKET DataSock = 0;

static HANDLE ConIn;
static HANDLE ConOut;
static DWORD  OldMode;
static DWORD  NewMode;

/* display error */

static void DisplayError(int Code, char * Msg)
{PutString(ConOut ,"ERROR: ");
 if(Msg) PutString(ConOut,Msg);
 if(Code)
   {wilErrorText(Code,(char *)Temp,MAX_BUF);
    PutLine(ConOut,(char *)Temp);
   }
}

/* display error & exit (before calling wilAttach) */

void SayError(char *Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

void ShutDown(void)
{PutLine(ConOut,"Shutting down...");
 wilRelease();
 SetConsoleMode(ConIn, OldMode);
 exit(0);
}

void DisplayString(char *String)
{
 PutString(ConOut, String);
}

void DisplayLine(char *String)
{
 PutLine(ConOut, String);
}

void DisplayChar(char Chr)
{
 PutChar(ConOut, Chr);
}

/*** main ***/

void main(void)
{int  Code;
 BOOL  Success;
 /* get handles for stdin & stdout */
 ConIn  = GetStdHandle(STD_INPUT_HANDLE);
 ConOut = GetStdHandle(STD_OUTPUT_HANDLE);
 /* modify console mode: disable line input & line echo */
 Success = GetConsoleMode(ConIn, &OldMode);
 if(!Success) SayError("GetConsoleMode");
 NewMode = OldMode & ~ENABLE_LINE_INPUT & ~ENABLE_ECHO_INPUT;
 Success = SetConsoleMode(ConIn, NewMode);
 if(!Success) SayError("SetConsoleMode");
 /* attach WINSOCK */
 PutString(ConOut,"Attaching WINSOCK...");
 Code = wilAttach();
 PutLine(ConOut,"OK");
 if(Code<0) DisplayError(Code,"wilAttach fails:");
 else
   {PutString(ConOut," Description: ");
    wilGetDescription((char *)Temp, MAX_BUF);
    PutLine(ConOut,(char *)Temp);
    PutString(ConOut,"My Host Name: ");
    wilGetMyHostName((char *)Temp, MAX_BUF);
    PutLine(ConOut,(char *)Temp);
    PutString(ConOut,"My Host Addr: ");
    wilGetMyHostDotted(0,(char *)Temp, MAX_BUF);
    PutLine(ConOut,(char *)Temp);
   }
 PutLine(ConOut,"\r\nStarting WHOIS Server: Type any key to exit...");
 /* get local host domain name */
 if(!wilGetMyHostName((char *)HostName, MAX_BUF))
   {DisplayError(0, "Cannot get local host name");
    ShutDown();
   }
 /* get local host IP address */
 HostAddr = wilGetHostAddr((char *)HostName,0);
 if(HostAddr==0)
   {DisplayError(0, "Cannot get local IP addess");
    ShutDown();
   }
 /* create listener socket */
 ListenSock = wilTcpSocket();
 if((int)ListenSock<=0)
   {DisplayError((int)Code, "wilListen:");
    ShutDown();
   }
 /* bind address & port number */
 Code = wilBind(ListenSock, HostAddr, WHOIS_PORT);
 if(Code<=0)
   {DisplayError((int)Code, "wilBind:");
    ShutDown();
   }
 /* listen for incoming request */
 Code = wilListen(ListenSock,1);
 if(Code<=0)
  {DisplayError(Code, NULL);
   ShutDown();
  }
#if 1
 wsprintf((char *)Temp,"ListenSock=%d MyHostAddr=%lx Port=%d",
                      ListenSock, HostAddr, WHOIS_PORT);
 DisplayLine((char *)Temp);
#endif
 DisplayLine("Listening...");

 /* wait for connection attempt */
 while(TRUE)
   {/* any key press shuts us down */
    if(KeyPress(ConIn)) ShutDown();
    //DisplayChar('?');
    /* any incoming connection ? */
    if(!wilDataIsReady(ListenSock,0)) continue;
    DisplayLine("Data incoming...");
    /* accept the connection */
    DataSock = wilAccept(ListenSock,ONE_SEC);
    if((int)DataSock<=0)
      {DisplayError((int)Code, "Accept:");
       continue;
      }
    wsprintf((char *)Temp,"DataSock=%d",(int)DataSock);
    DisplayLine((char *)Temp);
    DisplayLine("Connection is accepted");
    /* wait for data to show up */
    wilDataIsReady(DataSock,1000);
    /* read socket */
    Code = wilReadString(DataSock,(char *)InBuffer,MAX_BUF);
    wsprintf((char *)Temp,"Whois [%s]", InBuffer);
    DisplayLine((char *) Temp);
    /* formulate & send response, then close socket */
    if(lstrcmpi(InBuffer,"Mike")==0)
      {wilWriteString(DataSock,"Mike Marshall <mike@marshallsoft.com>\r\n");
       wilCloseSocket(DataSock,500);
      }
    else if(lstrcmpi(InBuffer,"Pam")==0)
      {wilWriteString(DataSock,"Pam Marshall <pam@marshallsoft.com>\r\n");
       wilCloseSocket(DataSock,500);
      }
    else if(lstrcmpi(InBuffer,"Lauren")==0)
      {wilWriteString(DataSock,"Lauren Marshall <lauren@marshallsoft.com>\r\n");
       wilCloseSocket(DataSock,500);
      }
    else
      {wilWriteString(DataSock,"No such user");
       wilCloseSocket(DataSock,500);
      }
   } /* end-while(TRUE)*/
}


