;*********************************;
; WASM Command Shell              ;
; By Eric Tauck                   ;
;                                 ;
; Defines:                        ;
;                                 ;
;   RunSys  run command processor ;
;                                 ;
; Requires:                       ;
;                                 ;
;   ENVIRO.ASM                    ;
;   SHELL1.ASM                    ;
;   STACK.ASM                     ;
;   STRINGF.ASM                   ;
;*********************************;

        jmps    _shell2_end

;--- data

_SHELL_MAXPTH   EQU     70                      ;maximum bytes for pathname
_shell_cstr     DB      'COMSPEC='              ;COMSPEC string
_shell_clen     EQU     $ - OFFSET _shell_cstr  ;length of COMSPEC
_shell_carg     DB      0                       ;COMMAND.COM arguments

;========================================
; Execute (another) copy of the command
; processor COMMAND.COM (or as named by
; the COMSPEC environment variable).
;
; Out: CY= set if error (AX= 0 if
;      COMSPEC not found, else DOS error
;      code).

RunSys  PROC    NEAR
        push    di
        push    si

        call    EnvRes          ;reset environment pointer

;--- find location of COMMAND.COM using COMSPEC in the environment

_rnsys1 call    EnvGet                  ;get next string
        jc      _rnsys5                 ;jump if none
        mov     di, OFFSET _shell_cstr  ;command string
        mov     cx, _shell_clen         ;length
        push    ds
        mov     ds, dx                  ;
        mov     si, ax                  ;environment string at DS:SI
        cld
        rep
        cmpsb                           ;compare strings
        jne     _rnsys3                 ;jump if no match

;--- found COMSPEC, skip preceding delimiters (probably shouldn't be any)

_rnsys2 cmp     BYTE [si], 32           ;check if delimiter
        ja      _rnsys4                 ;jump if not
        inc     si                      ;skip it
        jmps    _rnsys2

;--- COMSPEC not found, try next environment string

_rnsys3 pop     ds
        jmps    _rnsys1

;--- found COMSPEC and skipped delimiters, run program

_rnsys4 pop     ds
        StkAll  di, _SHELL_MAXPTH       ;max bytes for COMMAND.COM pathname
        mov     ax, si                  ;source in DX:AX
        mov     cx, ds
        mov     bx, di                  ;destination in CX:BX
        call    StrCpyF                 ;copy string to local storage
        mov     ax, di                  ;COMMAND.COM address
        mov     bx, OFFSET _shell_carg  ;arguments
        call    RunPro                  ;execute
        mov     dx, ax                  ;save return code
        lahf                            ;save flags
        StkRel  _SHELL_MAXPTH           ;restore stack
        pop     si
        pop     di
        sahf                            ;restore flags
        mov     ax, dx                  ;restore return code
        ret

;--- error, could not find COMSPEC in environment

_rnsys5 sub     ax, ax          ;no error number
        pop     si
        pop     di
        stc                     ;set carry for error
        ret
        ENDP

_shell2_end
