;*********************************;
; WASM Serial I/O, Block Output   ;
; By Eric Tauck                   ;
;                                 ;
; Defines:                        ;
;                                 ;
;   ComWri  write a block of data ;
;                                 ;
; Requires:                       ;
;                                 ;
;   SERIAL1.ASM                   ;
;*********************************;

        jmps    _serial4_end

;========================================
; Write a block of serial data.
;
; In: BX= record address; AX= buffer
;     address; CX= bytes (non-zero).

ComWri  PROC    NEAR
        push    di
        push    si
        mov     di, bx
        mov     si, ax

_cmwri1 push    cx
        mov     al, [si]        ;load byte
        inc     si              ;increment pointer
        mov     bx, di          ;record address
        call    ComPut          ;send byte
        pop     cx
        loop    _cmwri1         ;loop for count

        pop     si
        pop     di
        ret
        ENDP

_serial4_end
