;***********************************************;
; WASM Message Module, Error Output             ;
; By Eric Tauck                                 ;
;                                               ;
; Defines:                                      ;
;                                               ;
;   MesErr   message to error output            ;
;   MesErrL  message plus CR+LF to error output ;
;***********************************************;

        jmps    _message2_end

_mes_crlf       DB      13, 10, 0       ;CR+LF ASCIIZ string

;========================================
; Display an ASCIIZ string to error
; output.
;
; In: AX= string address.

MesErr  PROC    NEAR

;--- determine length of string

        mov     bx, ax          ;address in BX
        jmps    _mgerr2         ;enter loop
_mgerr1 inc     bx              ;increment address
_mgerr2 cmp     BYTE [bx], 0    ;check if end of string
        jnz     _mgerr1         ;loop back if not

;--- write bytes to error device

        mov     dx, ax          ;address in DX
        mov     cx, bx          ;end address in CX
        sub     cx, dx          ;bytes to write
        mov     bx, 2           ;error device handle
        mov     ah, 40H         ;write function
        int     21H             ;execute
        ret
        ENDP

;========================================
; Display an ASCIIZ string followed by a
; carriage return and linefeed to error
; output.
;
; In: AX= string address.

MesErrL PROC    NEAR
        call    MesErr                  ;display string
        mov     ax, OFFSET _mes_crlf    ;address of CR+LF
        call    MesErr                  ;display
        ret
        ENDP

_message2_end
