;*******************************************;
; WASM Macro Processor, Debug Info          ;
; By Eric Tauck                             ;
;                                           ;
; Defines:                                  ;
;                                           ;
;   MacUnd  return undefined compile symbol ;
;   MacCur  current state (IP,stack,return) ;
;   MacStk  read stack values               ;
;   MacRet  read return values              ;
;   MacSym  return the symbol of an address ;
;                                           ;
; Requires:                                 ;
;                                           ;
;   MACRO1.ASM                              ;
;*******************************************;

        jmp     _macro2_end

_mac_ssym       DB      7, '(start)'    ;start symbol

;========================================
; Return undefined symbol.
;
; In: AX= place to put symbol.
;
; Out: CY= set if not undefined symbol or
;      symbol table info not preserved
;      (MacBug = 0).

MacUnd  PROC    NEAR
        push    di
        push    si
        push    ds

        mov     cx, _mac_undlen ;length of symbol
        mov     di, ax
        mov     si, _mac_undoff ;symbol offset
        or      si, si          ;check if exists
        jz      _mcund1         ;exit if not
        mov     ax, _mac_symseg ;load symbol segment
        or      ax, ax          ;check if preserved
        jz      _mcund1         ;exit if not
        mov     ds, ax

;--- copy symbol

        cld
        rep
        movsb                   ;copy symbol
        sub     al, al
        stosb                   ;store NUL

        pop     ds
        pop     si
        pop     di
        clc
        ret

;--- symbol not returned

_mcund1 pop     ds
        pop     si
        pop     di
        stc
        ret
        ENDP

;========================================
; Return the current state.
;
; Out: AX= current location; BX= number
;      of items on stack; CX= number of
;      items on return stack.


MacCur  PROC    NEAR
        mov     ax, _mac_codsav
        mov     bx, _mac_stksiz
        sub     bx, _mac_stksav
        shr     bx
        mov     cx, _mac_codsiz
        dec     cx
        dec     cx
        sub     cx, _mac_retsav
        shr     cx
        ret
        ENDP

;========================================
; Copy items from the stack.
;
; In: AX= place to store items; CX=
;     number of items.

MacStk  PROC    NEAR
        push    di
        push    si
        push    ds
        mov     di, ax                  ;place to put items
        mov     si, _mac_stksav         ;source offset
        mov     ds, _mac_stkseg         ;source segment
        cld
        rep
        movsw                           ;copy items
        pop     ds
        pop     si
        pop     di
        ret
        ENDP

;========================================
; Copy items from the return stack.
;
; In: AX= place to store items; CX=
;     number of items.

MacRet  PROC    NEAR
        push    di
        push    si
        push    ds
        mov     di, ax                  ;place to put items
        mov     si, _mac_retsav         ;offset
        inc     si
        inc     si                      ;adjust, point to last item
        mov     ds, _mac_codseg         ;source segment
        cld
        rep
        movsw                           ;copy items
        pop     ds
        pop     si
        pop     di
        ret
        ENDP

;========================================
; Return the last symbol before an
; address.
;
; In: AX= address; BX= place to store
;     symbol.
;
; Out: CY= no symbol returned (out of
;      range or no symbol table); AX=
;      byte offset past symbol.

MacSym  PROC     NEAR
        push    di
        push    si
        push    bp
        push    ds

        cld
        mov     di, bx
        mov     bp, ax

;--- check for special cases

        cmp     ax, _mac_codptr         ;check if address out of range
        jae     _mcsym5                 ;exit if so

        mov     dx, OFFSET _mcstar      ;beginning address
        cmp     ax, dx                  ;check if address out of range
        jb      _mcsym5

        mov     ax, _mac_symseg         ;symbol table segment
        or      ax, ax                  ;check if none
        jz      _mcsym5

;--- loop through symbol table

        mov     ds, ax          ;table segment
        sub     si, si          ;start of symbol table
        mov     bx, si
        dec     bx              ;set symbol offset to FFFF
        jmps    _mcsym2

_mcsym1 mov     dx, [si]        ;load symbol address
        pop     bx              ;address of symbol string
        inc     si              ;
        inc     si              ;skip value

_mcsym2 seg     es
        cmp     si, _mac_symptr ;check if end of table
        je      _mcsym3

        push    si
        lodsb                   ;load length of symbol
        sub     ah, ah          ;length in AX
        add     si, ax          ;point to end of symbol
        cmp     [si], bp        ;check if symbol is past
        jbe     _mcsym1         ;loop back if not
        pop     ax              ;fix stack

_mcsym3 mov     si, bx          ;symbol source
        inc     bx              ;check if FFFFH
        jnz     _mcsym4         ;jump if not

        push    es                      ;start symbol segment
        pop     ds                      ;
        mov     si, OFFSET _mac_ssym    ;start symbol offset

;--- copy symbol

_mcsym4 lodsb                   ;load length
        mov     cl, al          ;
        sub     ch, ch          ;CX gets length
        rep
        movsb                   ;copy symbol
        sub     al, al
        stosb                   ;store NUL

        sub     bp, dx          ;offset to symbol
        mov     ax, bp          ;return it in AX

        pop     ds
        pop     bp
        pop     si
        pop     di
        clc
        ret

;--- address out of range

_mcsym5 pop     ds
        pop     bp
        pop     si
        pop     di
        stc
        ret
        ENDP

_macro2_end
