;*****************************;
; WASM Interrupt Chaining     ;
; By Eric Tauck               ;
;                             ;
; Defines:                    ;
;                             ;
;   IntChn  chain interrupt   ;
;   IntRel  release interrupt ;
;   IntChk  check interrupt   ;
;                             ;
; Requires:                   ;
;                             ;
;   INTR.ASM                  ;
;*****************************;

        jmps    _intr2_end

;================================================
; Chain interrupt.
;
; In: AL= interrupt; BX= interrupt variable; CX=
;     chain routine.

IntChn  PROC    NEAR
        push    di
        mov     di, bx                  ;variable address in DI
        push    ax
        push    cx
        call    IntGet                  ;get interrupt
        mov     [di], bx                ;save offset
        mov     [di + 2], dx            ;save segment
        pop     bx                      ;restore new offset
        pop     ax                      ;restore interrupt
        mov     dx, cs                  ;segment
        call    IntSet                  ;set interrupt
        pop     di
        ret
        ENDP

;================================================
; Release interrupt.
;
; In: AL= interrupt; BX= interrupt variable.

IntRel  PROC    NEAR
        mov     dx, [bx + 2]            ;segment
        mov     bx, [bx]                ;offset
        call    IntSet                  ;set interrupt
        ret
        ENDP

;================================================
; Check if interrupt has been changed.
;
; In: AL= interrupt; DX:CX= chain routine.
;
; Out: ZF= set if unchanged.

IntChk  PROC    NEAR
        push    cx
        push    dx
        call    IntGet                  ;get interrupt
        pop     cx
        pop     ax
        cmp     bx, ax                  ;check offset
        jne     _intch1
        cmp     dx, cx                  ;check segment
_intch1 ret
        ENDP

_intr2_end
