;============================================================ INCLUDE viv.lib

jmps    macro   address
                jmp short address
endm

;
_ldbdxcx        macro   ;load dx*10000+cx bytes from file(handle bx) to ds:ax
                push    ds
                push    dx
                push    cx
                push    bx
                push    ax

_nxFFF0:        or      dx,dx
                je      _ldlast
                push    dx
                push    cx
                push    ax
                mov     dx,ax           ;start for load ds:ax
                mov     cx,0FFF0h
                mov     ah,3fh
                int     21h
                jae     _rd2
_rder:          xor     dx,dx
                diskerr
_rd2:           cmp     ax,cx
                je      _rd4
_rd_dsk_full:   mov     al,0bh
                jmp     short _rder

_rd4:           mov     ax,ds
                add     ax,0FFFh
                mov     ds,ax
                pop     ax
                pop     cx
                pop     dx
                sub     cx,0FFF0h
                sbb     dx,0
                jmp short _nxFFF0

_ldlast:        or      cx,cx
                je      _ldexit
                pop     dx
                push    dx
                mov     ah,3fh
                int     21h
                jb      _rder
                cmp     ax,cx
                jne     _rd_dsk_full
_ldexit:
                pop     ax
                pop     bx
                pop     cx
                pop     dx
                pop     ds
                ret
endm
ldbdxcx macro
call    %ldbdxcx
endm

;
_start          macro
                call    _start0
                jmp _start4
_start0:        mov     ah,30h
                int     21h
                cmp     al,03h
                jae     _start2
                mov     dx,offset @_idv
                @
                _prgexit 255
_start2:        call    _arg
                pop     ax
                cli
                push    cs
                pop     ss
                mov     sp,offset @_idvend-11
                push    ax
                mov     ax,cs
                not     ax
                add     ax,ds:[2]
                sub     ax,21h          ;for stable work: w/o last 210h bytes
                ret

; _arg analize command line 
_arg:           push    si
                push    dx
                mov     si,offset @_idvend-11
                push    si                      ;si=start of array of argv
                xor     cx,cx                   ;cx=argc(0...6)
                mov     bx,80h
                mov     al,[bx]
                xor     dx,dx
                add     dl,al                   ;dx=simvols in line
                inc     dx
                inc     dx
_arg00:         dec     dx
                je      _argend
                inc     bx
                mov     al,[bx]
                cmp     al,0dh
                je      _argend
                cmp     al," "
                je      _arg00
                mov     [si],bl                 ;save start of argument
                inc     si
                mov     [si],ch                 ;reset addr "."
                inc     cx                      ;inc argc
_arg10:         dec     dx
                je      _argend
                inc     bx
                mov     al,[bx]
                cmp     al,"."
                jne     _arg12
                cmp     [si],ch
                jne     _arg12                  ;if already enabled coord "."
                mov     [si],bl                 ;store coord "."
_arg12:         cmp     al,0dh
                je      _argend
                cmp     al," "
                jne     _arg10
                mov     byte ptr [bx],ch        ;set 0 in end of argument
                cmp     [si],ch
                jne     _arg14                  ;jmp if already enable coord(.)
                mov     [si],bl                 ;store coord(.)=coord(end)
_arg14:         inc     si
                cmp     cl,5                    ;check argc=max ?
                jbe     _arg00
_argend:        mov     byte ptr [bx],ch
                pop     bx                      ;bx=start of array of argv
                pop     dx
                pop     si
                ret
;end of _arg
                db      13,10,13,10,"          \\\\\(c)VIV/////  ",13,10,13,10
                db"          [Here is stack area  200 bytes]",13,10,13,10
@_idv           db      "needs dos 3.3 or higher",13,10,0,0,0,0,0,0,0,0,0,0,0,0
                db      0,0,0,0,0,0
@_idvend        db      0
_start4:        sti
endm

;
_prgexit        macro
                mov     ah,4ch
                int     21h
endm
prgexit macro
jmp     %prgexit
endm

;
_@              macro   ; print line cs:dx ends 0 
                pushf
                push    ds
                push    cs
                pop     ds
                push    si
                push    dx
                push    cx
                push    bx
                push    ax
                mov     si,dx
                cld
@next$:         lodsb
                cmp     al,0
                jne     @next$
                mov     cx,si
                sub     cx,dx
                dec     cx              ;cx=length ; ds:dx=start
                mov     bx,1            ;뢮 ᮮ饭 (handle=1)
                mov     ah,40h          ;᫥. 
                int     21h
                pop     ax
                pop     bx
                pop     cx
                pop     dx
                pop     si
                pop     ds
                popf
                ret
endm
@       macro
call    %@
endm

;
_filsize        macro   ; returns size(dx,ax) of file  handle bx     
                pushf
                push    si
                push    ax
                push    bx
                xor     cx,cx
                xor     dx,dx
                mov     al,1    ;set file-pointer relative current pointer
                call    _setptr
                push    cx              ;save current file-pointer (lo part)
                push    dx              ;save current file-pointer (hi part)

                xor     cx,cx
                xor     dx,dx
                mov     al,2            ;set file-pointer relative EOF
                call    _setptr
                pop     si
                pop     ax
                push    cx              ;save filesize(lo part)
                push    dx              ;save filesize(hi part)

                mov     cx,ax           ;reduce current-pointer(lo)
                mov     dx,si           ;reduce current-pointer(hi)
                mov     al,0            ;set file-pointer relative start of file
                call    _setptr
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                pop     si
                popf
                ret
_setptr:        push    bx
                mov     ah,42h
                int     21h             ;ax<-l_pointer, dx<-h_poiter
                mov     cx,ax
                jae     _gfsn
                diskerr
_gfsn:          pop     bx
                ret
endm
filsize macro
call    %filsize
endm

;
_open4rd        macro   ; oppen file cs:dx for read, returns handle in bx 
                pushf
                push    ax
                push    cx
                push    dx
                push    ds
                push cs
                pop ds
                mov     ax,3d00h
                mov     bx,0a494h
                xor     cx,cx
                int     21h
                jae     op4rd
                diskerr
op4rd:          mov     bx,ax
                pop     ds
                pop     dx
                pop     cx
                pop     ax
                popf
                ret
endm
open4rd macro
call    %open4rd
endm

;
_ax_to16        macro   ;  AX  16-筮    cs:[bx] 
                pushf
                push    ax
                push    dx
                push    ax
                call    c256to16
                mov     cs:[bx+2],ax
                pop     ax
                mov     al,ah
                call    c256to16
                mov     cs:[bx],ax
                pop     dx
                pop     ax
                popf
                ret
c256to16:;       16-.ASCII
        push    cx
        mov     ah,000  ;ᯮ. ॣ: AX,CL (⠫  )
        mov     cl,004  ;室      :AL
        shl     ax,cl   ;室    :AL(.),AH(.)
        shr     al,cl
        add     al,30h
        cmp     al,3Ah
        jb      cdig1
        add     al,7
cdig1:  xchg    ah,al
        add     al,30h
        cmp     al,3Ah
        jb      cdig2
        add     al,007
cdig2:  pop     cx
        ret
endm
ax_to16 macro
call    %ax_to16
endm

;
_diskerr        macro   ;print dskerr & exit (ax=errcode,cs:[dx]-name or dx=0)
                push cs
                pop ds
                push    dx
                mov     bx,offset _@errcode
                ax_to16
                mov     dx,offset _@diskerr0    ;start of err.-messages
                mov     bx,dx
                @
                mov     cx,offset _@diskerr1    ;end  of  err.-messages(& start "file")
_dinextsimv:    inc     bx
                cmp     bx,cx
                jbe     _din1
                jmp short _dieexit
_din1:          cmp     byte ptr [bx],0
                jne     _dinextsimv
                inc     bx
                cmp     [bx],al
                jne     _dinextsimv     ;if err.code[bx]<>al
                inc     bx
                mov     dx,offset _@ifenmsg
                @                       ;print ": "13,10
                mov     dx,bx
                @                       ;print err.-message
                pop     dx
                or      dx,dx
                jne     _din4           ;if necessary print string cs:[dx]
                jmp short _dieexit
_din4:          push    dx
                mov     dx,cx
                @                       ;print "file  "
                pop     dx
                @                       ;print filename
_dieexit:       mov     dx,offset _@workab
                @
                mov     dx,offset _@enter
                @
                _prgexit
_@diskerr0      db      13,10,"Disk error "
_@errcode       db      "     ",0
_@ifenmsg       db      ": ",13,10,0
                db      0,"disk write-protected",0
                db      2,"not found",0
                db      3,"path not found for",0
                db      4,"too many opened files",0
                db      5,"error creation file -",13,10," may be already exist directory or read-only",0
                db      6,"invalid handle (internal error)",0
                db      8,"disk full",0
                db      0ah,"error writing",0
                db      0bh,"error reading",0
_@diskerr1      db      " file:  ",0
_@workab        db      13,10,"Work aborted !",7
_@enter         db      13,10,0
endm
diskerr macro
call    %diskerr
endm
;================================================================ end viv.lib

ReadingPara2    equ     0FFFh   ;- PARA   ⥭ 2- 䠩
                                ;(100h...0FFFh)

CODE    segment
                assume  CS:CODE, DS:CODE, SS:CODE, ES:CODE
                org     100h

start:          _start
                cmp     ax,((offset @work-offset start)/10h+1)+2000h
                ja      n0
                mov     dx,offset @nem
                @
                prgexit
n0:             mov     frepara,ax              ;store FreeMem
                call    prepare
                call    prepcmp

always:         call    ldbf1
                call    ldbf2
                jmp short always

prepare:;================================================= ਣ⮢
        ;-----------------------------------------------------------open files
                push    cs
                pop     ds
                cmp     cx,2
                jb      usage
                mov     dh,0
                mov     dl,[bx]
                mov     si,dx
                mov     ax,[si]
                cmp     al,"/"
                je      usage
                cmp     al,"?"
                jne     @_0
usage:
                mov     dx,offset @usage
                @
                prgexit
@_0:
                push    dx
                mov     dx,offset @begin1
                @
                pop     dx

@_nFil:         push    cx
                push    bx
                push    dx
                open4rd                         ;bx<--handle
                @                               ;display opened filename
                mov     si,amount
                shl     si,1
                mov     [handle][si],bx
                mov     [filname][si],dx
                filsize                         ;cx,dx<--filesize
                shl     si,1
                mov     [l_fsize][si],cx
                mov     [h_fsize][si],dx
                pop     dx
                pop     bx
                pop     cx                      ;cx=argc

                inc     word ptr amount
                dec     cx
                je      @_aOp
                inc     bx
                inc     bx                      ;bx=argv(out_filename)
                mov     dh,0
                mov     dl,[bx]                 ;cs:dx=start of next filename
                push    dx
                mov     dx,offset @begin2
                @
                pop     dx
                jmp short @_nFil

@_aOp:
                mov     dx,offset @enter
                @
                ret

prepcmp:;===================================⮢  ࠢ  䠩
        ;-------------------------------------। .   
                mov si, offset l_fsize
                mov     ax,[si+2]
                cmp     ax,[si+6]
                ja      @_2ae
                jb      @_1ae
@cmp_lo:        mov     ax,[si]
                cmp     ax,[si+4]
                ja      @_2ae
@_2ae:          add     si,4
@_1ae:          lodsw   ; lo word
                mov     l_fsiz0,ax
                lodsw   ; hi word
                mov     h_fsiz0,ax
;-----------------------------------------------------------------
                mov     ax,ReadingPara2
                mov     Para2,ax

                mov     ax,frepara              ;restore Free para of Mem
                sub     ax,ReadingPara2
                mov     cl,12
                shr     ax,cl                   ;ax=number of blocks for read
                mov     amrdbl,ax

                push    ax
                mov     bx,cs
                add     bx,(offset @work-offset start)/10h + 1 + 10h
                mov     strtds1,bx
                mov     cx,ReadingPara2
                mul     cx
                add     bx,ax
                mov     strtds2,bx
                mov     es,bx
                pop     ax

                mov     cx,ReadingPara2*16
                mul     cx
                mov     cx,ax   ;==>dx,cx = amount of loading bytes for file1
                ret

ldbf1:  ;================================================loading part of file1
                push    ds
                push    dx
                push    cx

                mov     bx,h_fsiz0
                mov     ax,l_fsiz0
                sub     ax,l_fptr0
                sbb     bx,h_fptr0
                cmp     bx,dx
                ja      @_norm1
                jb      ldlast1
                cmp     ax,cx
                ja      @_norm1
                jb      ldlast1

@_norm1:
                pop     cx      ;restore dx,cx
                pop     dx      ;᫨   䠩1
                push    dx      ; 㦠 -ᨬ
                push    cx      ;
                jmp short @_na2

ldlast1:        mov     cx,ax   ;᫨  䠩1
                mov     dx,bx   ; 㧨 ⮪

@_na2:          mov     bx,handle
                mov     ax,strtds1
                mov     ds,ax
                xor     ax,ax
                ldbdxcx
                pop     cx
                pop     dx
                pop     ds
                ret

ldbf2:  ;==================================loading part of file2 and comparing
                push    dx
                push    cx
                mov     bp,strtds1
                mov     cx,amrdbl       ;counter of blocks (LEN=ReadingPara2*16)

@_nxbl2:        push    cx
                mov     bx,h_fsiz0
                mov     ax,l_fsiz0
                sub     ax,l_fptr0
                sbb     bx,h_fptr0

                or      bx,bx
                jne     @_norm2
                cmp     cx,ReadingPara2*16
                jbe     ldlast2

@_norm2:        mov     cx,ReadingPara2*16
                xor     dx,dx
                mov     bx,handle+2

                push    ds
                push    es
                pop     ds
                xor     ax,ax
                ldbdxcx
                mov     ds,bp
                add     bp,ReadingPara2
                xor     si,si
                xor     di,di
                call cmp2bl
                pop     ds

                add     word ptr l_fptr0,ReadingPara2*16
                adc     word ptr h_fptr0,0

                pop     cx
                dec     cx
                jne     @_nxbl2

                pop     cx
                pop     dx
                ret


ldlast2:;---------------------------load last bytes of file2, compare and exit
                xor     dx,dx
                mov     cx,ax
                or      ax,ax
                je      @lenEq0
                mov     bx,handle+2
                push    ds
                push    es
                pop     ds
                xor     ax,ax
                ldbdxcx
                mov     ds,bp
                add     bp,ReadingPara2
                xor     si,si
                xor     di,di
                call cmp2bl
                pop     ds
@lenEq0:
                mov     ax,l_fsize      ;
                mov     bx,h_fsize      ;⠥   䠩1
                sub     ax,l_fsize+4    ; 䠩2
                sbb     bx,h_fsize+4    ;
                jb      long2           ;if unsigned OVF ==> FileLen2 > FileLen1
                or      ax,ax
                jne     @_noteq
                or      bx,bx
                je      @_equal

@_noteq:        mov     dx,offset @longe0
                @
                mov     dx,filname
                @
                mov     dx,offset @longe1
                @
                mov     dx,filname+2
                @
                jmp short long0

long2:;---------᫨ 2 䠩  ࢮ
                mov     ax,l_fsize+4    ;
                mov     bx,h_fsize+4    ;⠥   䠩2
                sub     ax,l_fsize      ; 䠩1
                sbb     bx,h_fsize      ;
                mov     dx,offset @longe0
                @
                mov     dx,filname+2
                @
                mov     dx,offset @longe1
                @
                mov     dx,filname
                @

long0:          push    bx
                mov     bx,offset @longe3+4
                ax_to16
                pop     ax
                mov     bx,offset @longe3
                ax_to16
                mov     dx,offset @longe2
                @
                ; exit after print
                ; "VFC: file_1  longer than  file_2  by 0x???????? byte(s)",
                ; so, don't print "VFC: no differences encountered" if no
                ; differences in files with different length:
                jmp short @_pexit

@_equal:        mov     ax,differs
                or      ax,ax
                jne     @_ifdif
                mov     ax,differs+2
                or      ax,ax
                jne     @_ifdif
                mov     dx,offset @nodiff
                @
                jmp short @_pexit

@_ifdif:        mov     bx,offset @8numbh
                mov     ax,differs+2
                ax_to16

                mov     bx,offset @8numbh+4
                mov     ax,differs
                ax_to16

                mov     dx,offset @finish
                @
@_pexit:        prgexit


cmp2bl: ;====================compare 2 memory blocks  1=ds:si, 2=es:di, len=cx
        ;output: destinations as text info on the screen (in format of FC.EXE)
                push    dx
                push    cx
                push    bx
                cld
@_nxcmp:        repe cmpsb
                call    dispdif
                inc     cx
                dec     cx
                jne     @_nxcmp
@_encmp:        pop     bx
                pop     cx
                pop     dx
                ret

dispdif:;=======Input: AL=fromFile2, AH=FromFile1, DX=offset
                dec     si
                dec     di
                mov     ah,[si]
                mov     al,es:[di]
                cmp     al,ah           ;ࠡ⠥ ⮫쪮 ᫨ 
                je      @_nbdif         ;⫨稥  ᫥  (CX=0000)
                mov     bx,offset @cmpln2+10
                ax_to16
                mov     ax,word ptr cs:@cmpln2+12
                mov     word ptr cs:@cmpln2+13,ax
                mov     byte ptr cs:@cmpln2+12,20h

                mov     ax,cs:l_fptr0
                add     ax,si
                pushf
                mov     bx,offset @cmpln2+4
                ax_to16
                popf

                mov     ax,cs:h_fptr0
                adc     ax,0
                mov     bx,offset @cmpln2
                ax_to16

                mov     dx,offset @cmpln2
                @
                inc     word ptr cs:differs
                jnb     @_nbdif                 ;if no OVF
                inc     word ptr cs:differs+2
@_nbdif:        inc     di
                inc     si
                ret

;
_ldbdxcx        macro   ;load dx*10000+cx bytes from file(handle bx) to ds:ax
                push    ds
                push    dx
                push    cx
                push    bx
                push    ax

_nxFFF0:        or      dx,dx
                je      _ldlast
                push    dx
                push    cx
                push    ax
                mov     dx,ax           ;start for load ds:ax
                mov     cx,0FFF0h
                mov     ah,3fh
                int     21h
                jae     _rd2
_rder:          xor     dx,dx
                diskerr
_rd2:           cmp     ax,cx
                je      _rd4
_rd_dsk_full:   mov     al,0bh
                jmp     short _rder

_rd4:           mov     ax,ds
                add     ax,0FFFh
                mov     ds,ax
                pop     ax
                pop     cx
                pop     dx
                sub     cx,0FFF0h
                sbb     dx,0
                jmp short _nxFFF0

_ldlast:        or      cx,cx
                je      _ldexit
                pop     dx
                push    dx
                mov     ah,3fh
                int     21h
                jb      _rder
                cmp     ax,cx
                jne     _rd_dsk_full
_ldexit:
                pop     ax
                pop     bx
                pop     cx
                pop     dx
                pop     ds
                ret
endm
ldbdxcx macro
call    %ldbdxcx
endm

;**************** CALLS TO MACROSs *******************************************
%open4rd:       _open4rd
%filsize:       _filsize
%ldbdxcx:       _ldbdxcx
%@:             _@              ;print string starting cs:dx ends 0
%ax_to16:       _ax_to16
%prgexit:       _prgexit
%diskerr:       _diskerr
;
frepara dw      0               ;Free PARA of Mem
differs dw      0
        dw      0

amrdbl  dw      0       ;amount of  blocks
curdbl  dw      0       ;current reading block
amount  dw      0

Para1   dw      0
Para2   dw      0

strtds1 dw      0
strtds2 dw      0

l_fsiz0 dw      0
h_fsiz0 dw      0

l_fadd1 dw      0
h_fadd1 dw      0

l_fptr0 dw      0       ;current pointer
h_fptr0 dw      0       ;for loading files

l_fsize dw      ?
h_fsize dw      ?
        dd      ?
        dd      ?
        dd      ?
        dd      ?
        dd      ?
        dd      ?
        dd      ?
        dd      ?
        dd      ?

handle  dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?

filname dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?
        dw      ?

@cmpln2 db      0,0,0,0,0,0,0,0,":      "
@enter  db      13,10,0
@longe0 db      "VFC: ",0
@longe1 db      "  longer than  ",0
@longe2 db      "  by 0x"
@longe3 db      0,0,0,0,0,0,0,0," byte(s)",13,10,0
@nodiff db      "VFC: no differences encountered",13,10,0
@finish db      "VFC: number of different bytes: 0x"
@8numbh db      0,0,0,0,0,0,0,0,13,10,0
@work:
@nem    db      "Not enough memory: needs 150 KB of conventional memory.",13,10,0
@begin1 db      'Comparing files ',0
@begin2 db      ' and ',0
@usage  db      13,10
        db 9,"VIT (R) File Binary Comparison Utility  Version 1.01",13,10
        db 9,"Copyright (C) VIV  Wed 09.12.1998.",13,10  ;"  All rights reserved.",13,10
        db 9,"Fastest DOS file comparer. Pure ASM.",13,10,13,10
        db 9,"Usage:",13,10
        db 9,"VFC.COM   file_1  file_2",13,10,0
CODE    ends
        end     start
