
/*
 * Waterloo TCP
 *
 * Copyright (c) 1990, 1991, 1992, 1993 Erick Engelke
 *
 * Portions copyright others, see copyright.h for details.
 *
 * This library is free software; you can use it or redistribute under
 * the terms of the license included in LICENSE.H.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * file LICENSE.H for more details.
 *
 */

/*
 *   WATTCP - TCP/IP library routines
 *
 *   Copyright (c) 1990, 1991, 1992, 1993 Erick Engelke
 *
 *   Portions Copyright (c) 1993  Quentin Smart
 *   Portions Copyright (c) 1991  University of Waterloo
 *   Portions Copyright (c) 1990  National Center for Supercomputer Applications
 *   Portions Copyright (c) 1990  Clarkson University
 *   Portions Copyright (c) 1983, 1986, Imagen Corporation
 *
 *      This software is distributed in the hope that it will be useful,
 *      but without any warranty; without even the implied warranty of
 *      merchantability or fitness for a particular purpose.
 *
 *   RESTRICTIONS
 *   ------------
 *   You may freely use this library to produce programs which you may give
 *   away or sell in source format, or as compiled executables, or both.
 *
 *   You may not sell this library or a portion thereof or distribute modified
 *   versions the library code in either source or OBJect or LIBrary format
 *   without written permission from the author.  The author still maintains
 *   copyright privileges and will assert the privileges of ownership for
 *   purposes of royalties such distributions.
 *
 *   Portions of this code were written or enhanced by others and offerred
 *   to me for distribution in WATTCP under my copyright.  To my knowledge,
 *   all copyrights exercised are listed at the top of this file.  If this
 *   is incorrect, please contact me so I can rectify the situation.
 *
 *
 *   OFFICIAL SITE
 *   -------------
 *   The official distribution site for WATTCP (and many other TCP goodies)
 *   is dorm.rutgers.edu in pub/msdos/wattcp  (thanks Jim!)
 *
 *   That is where I upload the latest libraries, my own free applications
 *   and other applications I have collected and find useful.
 *
 *
 *   DOCUMENTATION
 *   -------------
 *   A programmer's reference manual I wrote is now available from the
 *   publisher.  They provide no additional support and cannot help
 *   you with any aspect of the software.  But they do pay a royalty
 *   to me which has been used to compensate my costs for developing
 *   this software and extending it, so I am very appreciative.
 *
 *   That manual is copyrighted and protected by international law.
 *   It may not be copied without the authors permission.  And its
 *   sale does not constitute a warranty or an automatic license to
 *   use WATTCP beyond the terms described in this file.
 *
 *   For payment they accept credit cards, cheques, checks, money orders
 *   and P.O.s.  Credit card orders can be processed over the telephone.
 *
 *   Note that they are located in Canada and mail to them MAY REQUIRE
 *   additional postage depending on where you live.  Also, be sure to
 *   use the entire address, including the last line.  Canada is a heck
 *   of a large country and that line really makes a difference.
 *
 *   Prices are listed in US dollars for convienence to our many
 *   international readers.  The value charged on credit card items
 *   will be the equivalent in Canadian dollars at the exchange rate
 *   of the day.
 *
 *   WATTCP Manual          $ 40  US funds for each manual orderred
 *                     ----------
 *   Shipping + Handling    $  5  US funds to North America
 *   (Air Mail)          or $ 10  US funds to anywhere else in the world
 *
 *                     ADD  $ 20  US funds IF YOU ARE USING PURCHASE ORDERS
 *                                in which case payment is due in 30 days.
 *                                Not necessary for cheques, credit cards, etc.
 *                     ----------
 *
 *          WATTCP Manual
 *          c/o Supro Network Software Inc.
 *          P.O. Box 18,
 *          Warsaw, Ont.
 *          CANADA
 *          K0L 3A0
 *
 *  Phone (705) 652-1572 and be certain to mention that you are talking
 *  about the WATTCP manual.
 *
 *  Please note, I am not involved in the processing loop for the manual
 *  and cannot tell you of the status of your order.  Use Supro's number
 *  instead.
 *
 *
 *  Developers' Meeting Place
 *  -------------------------
 *  Many of the key people involved in WATTCP frequent the
 *  comp.protocols.tcp-ip.ibmpc Usenet newgroup, and there
 *  are several people there who can answer most any question.
 *
 *  If you need my personal attention (I seem to have less and less
 *  available) you will have to Email my address below.  I cannot take
 *  phone calls relating to WATTCP at my place of occupation.
 *
 *
 *       Erick Engelke                erick@dorm.rutgers.edu
 *       48 Daytona St.
 *       Kitchener, Ont.
 *       Canada
 *
 */
#define WATTCP_C "WATTCP_C"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <stdarg.h>
#include <conio.h>
#include <sys\types.h>
#include <ctype.h>

typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned char ubyte;
typedef signed char byte;


#ifndef _wattcp_tcp_h
#define _wattcp_tcp_h


#ifndef WTCP_VER

/* handle some early dumb naming conventions */
#define dbuginit()      dbug_init()

/* Kernal version (major major minor minor) */
#define WTCP_VER 0x0102

/*
 * Typedefs and constants
 */

//#ifndef byte
//typedef unsigned char byte;
//#endif  byte
#ifndef word
typedef unsigned short word;
#endif
#ifndef longword
typedef unsigned long longword;
#endif 

#if 0
typedef struct {
    ubyte undoc[ 4300 ];
} tcp_Socket;

typedef struct {
    ubyte undoc[ 2200 ];
} udp_Socket;
#endif

typedef struct sockaddr {
    word        s_type;
    word        s_port;
    longword    s_ip;
    ubyte        s_spares[6];    /* unused in TCP realm */
} sockaddr;

#define sockaddr_in sockaddr

typedef struct in_addr {
    longword    s_addr;
} in_addr;


#define MAX_COOKIES     10
#define MAX_NAMESERVERS 10

#define TCP_MODE_BINARY 0
#define TCP_MODE_ASCII  1
#define UDP_MODE_CHK    0       /*default to checksum */
#define UDP_MODE_NOCHK  2
#define TCP_MODE_NAGLE  0       /* Nagle algorithm */
#define TCP_MODE_NONAGLE 4

extern sock_init();
/*
 *   s is the pointer to a udp or tcp socket
 */

extern int sock_enqueue(void  *s, ubyte *dp, int len);
extern sock_flush( void  *s );
extern sock_flushnext( void  *s);
extern sock_puts( void  *s, ubyte *dp );
extern int sock_gets( void  *s, ubyte *dp, int n );
extern ubyte sock_putc( void  *s, ubyte c );
extern int sock_getc( void  *s );
extern word sock_dataready( void  *s );
extern sock_abort( void *s );
extern sock_printf( void  *s, char *format, ... );
extern sock_scanf( void  *s, char *format, ... );
extern int sock_mode( void *s, word mode );        /* see TCP_MODE_... */
extern void db_write( char *msg );
extern void dbug_init();
extern void dbug_printf(char *,... );

/*
 * TCP or UDP specific stuff, must be used for open's and listens, but
 * sock stuff is used for everything else
 */
extern int tcp_established(void *s);
extern char *rip( char *s );
extern longword resolve( char *name);
extern int reverse_addr_lookup(longword ipaddr, char *name);
/*
 * less general functions
 */
extern longword aton( char *text );
extern int isaddr( char *text );
extern tcp_cbreak( word mode );
extern longword intel( longword x );
extern word intel16( word x );

/*
 * timers
 */

	/*
	 * TCP/IP system variables - do not change these since they
	 *      are not necessarily the source variables, instead use
	 *      ip_Init function
	 */
extern longword my_ip_addr;
extern longword sin_mask;       /* eg.  0xfffffe00L */
extern word sock_delay;

	/*
	 * tcp_init/tcp_shutdown
	 *      - init/kill all tcp and lower services
	 *      - only call if you do not use sock_init
	 * (NOT RECOMMENDED)
	 */
extern tcp_shutdown();
extern int tcp_init();

/*
 * things you probably won't need to know about
 */
	/*
	 * sock_debugdump
	 *      - dump some socket control block parameters
	 * used for testing the kernal, not recommended
	 */
extern sock_debugdump( void *s);
	/*
	 * tcp_config - read a configuration file
	 *            - if special path desired, call after sock_init()
	 *            - null reads path from executable
	 * see sock_init();
	 */
extern tcp_config( char *path );
	/*
	 * tcp_tick - called periodically by user application in sock_wait_...
	 *          - returns 1 when our socket closes
	 */
extern void tcp_tick( void  );
	/*
	 * Retransmitter - called periodically to perform tcp retransmissions
	 *          - normally called from tcp_tick, you have to be pretty
	 *            low down to use this one
	 */
extern tcp_Retransmitter();
	/*
	 * tcp_set_debug_state - set 1 or reset 0 - depends on what I have done
	 */
extern tcp_set_debug_state( word x );


extern int _last_cookie;
extern longword _cookie[MAX_COOKIES];

	/*
	 * name domain constants
	 */

extern char *def_domain;
extern longword def_nameservers[ MAX_NAMESERVERS ];


/*
 * sock_wait_... macros
 */
/*
 * sock_wait_established()
 *      - waits then aborts if timeout on s connection
 * sock_wait_input()
 *      - waits for received input on s
 *      - may not be valid input for sock_Gets... check returned length
 * sock_tick()
 *      - do tick and jump on abort
 * sock_wait_closed();
 *      - discards all received data
 *
 * jump to sock_err with contents of *statusptr set to
 *       1 on closed
 *      -1 on timeout
 *
 */

extern unsigned long set_timeout( unsigned int seconds );
extern unsigned long set_ttimeout( unsigned int ticks );


 
#define sock_wait_established( s, seconds, fn, statusptr ) \
    if (_ip_delay0( s, seconds, fn, statusptr )) goto sock_err;
#define sock_wait_input( s, seconds, fn , statusptr ) \
    if (_ip_delay1( s, seconds, fn, statusptr )) goto sock_err;
#define sock_wait_closed(s, seconds, fn, statusptr )\
    if (_ip_delay2( s, seconds, fn, statusptr )) goto sock_err;

/* user initialization file */
extern void (*usr_init)();

extern void outs( char * string );

/*
 * Send an icmp echo request using specified ttl and tos.
 * if(icmp_id != NULL) store copy of the id there
 */
extern int _send_ping( longword host, longword countnum, ubyte ttl,
					    ubyte tos, longword *theid );
/* backward compatibility */
#define _ping( h, c ) _send_ping( h, c, 250, 0, NULL )
extern longword _chk_ping( longword host , longword *ptr);
extern void _arp_register( longword use, longword instead_of );



extern int _eth_init();
extern ubyte *_eth_formatpacket( void *eth_dest, word eth_type );
extern int _eth_send( word len);
extern void _eth_free( void *buf);
extern ubyte *_eth_arrived( word *type_ptr);
extern void _eth_release();



/* bsd-similar stuff */

extern int sock_rbsize( void *s );
extern int sock_rbused( void *s );
extern int sock_rbleft( void *s );
extern int sock_tbsize( void *s );
extern int sock_tbused( void *s );
extern int sock_tbleft( void *s );


#endif /* WTCP_VER */

#endif /* ndef _wattcp_tcp_h */

#ifndef _wattcp_wattcp_h
#define _wattcp_wattcp_h


#define WATTCPH

#define SOCKESTABLISHED 1
#define SOCKDATAREADY   2
#define SOCKCLOSED      4

#define IP_TYPE     0x0008

/*
#define DEBUG
*/
/*
#define MoveW( a , b, c ) movmem( a, b,c )
#define busyouta(c) (putch(c))
*/


#define set_mstimeout( x ) (set_timeout(0)+ (x / 55))

#define MAX_GATE_DATA 12
#define MAX_STRING 50   /* most strings are limited */

#define MAXVJSA     1440 /* 10 s */
#define MAXVJSD     360  /* 10 s */
#define SAFETYTCP  0x538f25a3L
#define SAFETYUDP  0x3e45e154L
#define TRUE        1
#define true        TRUE
#define FALSE       0
#define false       FALSE

#define EL_INUSE        0x0001
#define EL_DELAY        0x0002
#define EL_TCP          0x0004
#define EL_SERVER       0x0008
#define EL_ASCII        0x0010
#define EL_NEVER        0x0020

/* These are Ethernet protocol numbers but I use them for other things too */
#define UDP_PROTO  0x11
#define TCP_PROTO  0x06
#define ICMP_PROTO 0x01


typedef int (*procref)();

//typedef unsigned long longword;     /* 32 bits */
//typedef unsigned short word;        /* 16 bits */
//typedef unsigned char byte;         /*  8 bits */
typedef ubyte eth_address[6];


/* undesirable */
extern longword MsecClock();
#define clock_ValueRough() MsecClock()

#define TICKS_SEC 18


#define PD_ETHER 1
#define PD_SLIP  6

extern word sock_inactive;      /* in pcbootp.c */
extern word _pktdevclass;
extern word _mss;
extern word _bootptimeout;      /* in pcbootp.c */
extern longword _bootphost;     /* in pcbootp.c */
extern word _bootpon;

/* The Ethernet header */
typedef struct {
    eth_address     destination;
    eth_address     source;
    word            type;
} eth_Header;

/* The Internet Header: */
#define HDRLENVER 0x45
typedef struct {
//    unsigned      hdrlen  : 4;
//    unsigned      ver     : 4;
	byte hdrlen_ver;                                                                        // 1
    ubyte           tos;
    word            length;
    word            identification;
    word            frags;
//    unsigned        frags : 3;
//    unsigned        fo    : 13;
    ubyte           ttl;
    ubyte           proto;
    word            checksum;
    longword        source;
    longword        destination;
} in_Header;


//#define in_GetVersion(ip) ( (ip)->ver )
//#define in_GetHdrlen(ip)  ( (ip)->hdrlen )  /* 32 bit word size */

#define in_GetVersion(ip) ( (ip)->hdrlen_ver >> 4 )
#define in_GetHdrlen(ip)  ( (ip)->hdrlen_ver & 0xf )  /* 32 bit word size */

#define in_GetHdrlenubytes(ip)  ( in_GetHdrlen(ip) << 2 ) /* 8 bit ubyte size */
#define in_GetTos(ip)      ( (ip)->tos)

#define in_GetTTL(ip)      ((ip)->ttl)
#define in_GetProtocol(ip) ((ip)->proto )

typedef struct {
    word            srcPort;
    word            dstPort;
    word            length;
    word            checksum;
} udp_Header;

#define UDP_LENGTH ( sizeof( udp_Header ))

typedef struct {
    word            srcPort;
    word            dstPort;
    longword        seqnum;
    longword        acknum;
    word            flags;
    word            window;
    word            checksum;
    word            urgentPointer;
} tcp_Header;

#define tcp_FlagFIN     0x0001
#define tcp_FlagSYN     0x0002
#define tcp_FlagRST     0x0004
#define tcp_FlagPUSH    0x0008
#define tcp_FlagACK     0x0010
#define tcp_FlagURG     0x0020
#define tcp_FlagDO      0xF000
#define tcp_GetDataOffset(tp) (intel16((tp)->flags) >> 12)

/* The TCP/UDP Pseudo Header */
typedef struct {
    longword    src;
    longword    dst;
    ubyte        mbz;
    ubyte        protocol;
    word        length;
    word        checksum;
} tcp_PseudoHeader;

/*
 * TCP states, from tcp manual.
 * Note: close-wait state is bypassed by automatically closing a connection
 *       when a FIN is received.  This is easy to undo.
 */
#define tcp_StateLISTEN  0      /* listening for connection */
#define tcp_StateSYNSENT 1      /* syn sent, active open */
#define tcp_StateSYNREC  2      /* syn received, synack+syn sent. */
#define tcp_StateESTAB   3      /* established */
#define tcp_StateESTCL   4      /* established, but will FIN */
#define tcp_StateFINWT1  5      /* sent FIN */
#define tcp_StateFINWT2  6      /* sent FIN, received FINACK */
#define tcp_StateCLOSWT  7      /* received FIN waiting for close */
#define tcp_StateCLOSING 8      /* sent FIN, received FIN (waiting for FINACK) */
#define tcp_StateLASTACK 9      /* fin received, finack+fin sent */
#define tcp_StateTIMEWT  10     /* dally after sending final FINACK */
#define tcp_StateCLOSEMSL 11
#define tcp_StateCLOSED  12     /* finack received */

#define tcp_MaxBufSize 2048         /* maximum ubytes to buffer on input */



/*
 * UDP socket definition
 */
typedef struct _udp_socket {
    struct _udp_socket *next;
    word            ip_type;            /* always set to UDP_PROTO */
    char           *err_msg;            /* null when all is ok */
    char           *usr_name;
    void          (*usr_yield)();
    ubyte            rigid;
    ubyte            stress;
    word            sock_mode;          /* a logical OR of bits */
    longword        usertimer;          /* ip_timer_set, ip_timer_timeout */
    procref         dataHandler;
    eth_address     hisethaddr;         /* peer's ethernet address */
    longword        hisaddr;            /* peer's internet address */
    word            hisport;            /* peer's UDP port */
    longword        myaddr;
    word            myport;
    word            locflags;

    int             queuelen;
    ubyte           *queue;

    int             rdatalen;           /* must be signed */
    word            maxrdatalen;
    ubyte           *rdata;
    ubyte            rddata[ tcp_MaxBufSize + 1];         /* if dataHandler = 0, len == 512 */
    longword        safetysig;
} udp_Socket;
/*
 * TCP Socket definition
 */


typedef struct _tcp_socket {
    struct _tcp_socket *next;
    word            ip_type;        /* always set to TCP_PROTO */
    char           *err_msg;
    char           *usr_name;
    void          (*usr_yield)();
    ubyte            rigid;
    ubyte            stress;
    word            sock_mode;      /* a logical OR of bits */

    longword        usertimer;      /* ip_timer_set, ip_timer_timeout */
    procref         dataHandler;    /* called with incoming data */
    eth_address     hisethaddr;     /* ethernet address of peer */
    longword        hisaddr;        /* internet address of peer */
    word            hisport;        /* tcp ports for this connection */
    longword        myaddr;
    word            myport;
    word            locflags;

    int             queuelen;
    ubyte           *queue;

    int             rdatalen;       /* must be signed */
    word            maxrdatalen;
    ubyte           *rdata;
    ubyte            rddata[tcp_MaxBufSize+1];    /* received data */
    longword        safetysig;
    word            state;          /* connection state */

    longword        acknum;
    longword        seqnum;         /* data ack'd and sequence num */
    long            timeout;        /* timeout, in milliseconds */
    ubyte            unhappy;        /* flag, indicates retransmitting segt's */
    ubyte            recent;         /* 1 if recently transmitted */
    word            flags;          /* tcp flags word for last packet sent */

    word            window;         /* other guy's window */
    int             datalen;        /* number of ubytes of data to send */
				    /* must be signed */
    int             unacked;        /* unacked data */

    ubyte           cwindow;        /* Van Jacobson's algorithm */
    ubyte           wwindow;

    word            vj_sa;          /* VJ's alg, standard average */
    word            vj_sd;          /* VJ's alg, standard deviation */
    longword        vj_last;        /* last transmit time */
    word            rto;
    ubyte           karn_count;     /* count of packets */
    ubyte            tos;            /* priority */
    /* retransmission timeout proceedure */
    /* these are in clock ticks */
    longword        rtt_lasttran;       /* last transmission time */
    longword        rtt_smooth;         /* smoothed round trip time */
    longword        rtt_delay;          /* delay for next transmission */
    longword        rtt_time;           /* time of next transmission */

    word            mss;
    longword        inactive_to;           /* for the inactive flag */
    int             sock_delay;

    ubyte            data[tcp_MaxBufSize+1]; /* data to send */
} tcp_Socket;

/* sock_type used for socket io */
typedef union {
    udp_Socket udp;
    tcp_Socket tcp;
} sock_type;

extern eth_address _eth_addr;
extern eth_address _eth_brdcast;

/*
 * ARP definitions
 */
#define arp_TypeEther  0x100            /* ARP type of Ethernet address */

/* harp op codes */
#define ARP_REQUEST 0x0100
#define ARP_REPLY   0x0200

/*
 * Arp header
 */
typedef struct {
    word            hwType;
    word            protType;
    word            hwProtAddrLen;  // hw and prot addr len
    word            opcode;
    eth_address     srcEthAddr;
    longword        srcIPAddr;
    eth_address     dstEthAddr;
    longword        dstIPAddr;
} arp_Header;

#define ETH_MSS 1400  // MSS for Ethernet

 // Ethernet interface:

extern int  _eth_init( void );
extern void  _eth_release( void );

extern void *_eth_hardware(ubyte *p);

extern int  ip_timer_expired(udp_Socket *s);


extern _chk_socket( tcp_Socket *s );
extern char *inet_ntoa( char *s, longword x );
extern int sock_write( sock_type *, ubyte *, int );
extern int sock_read( sock_type *, ubyte *, int );
extern int sock_fastread( sock_type *, ubyte *, int );
extern void psocket( tcp_Socket *s );
extern longword inet_addr( char *s );
extern char *sockerr( tcp_Socket *s );
extern char *sockstate( tcp_Socket *s );
extern int sock_fastwrite( sock_type *, ubyte *, int );
extern getpeername( tcp_Socket *s, void *dest, int *len );
extern getsockname(  tcp_Socket *s, void *dest, int *len );
extern longword gethostid();
extern longword sethostid( longword ip );
extern char *getdomainname( char *name, int length );
extern char *setdomainname( char *string );
extern char *gethostname( char *name, int length );
extern char *sethostname( char *string );
extern word ntohs( word a );
extern word htons( word a );
extern longword ntohl( longword x );
extern longword htonl( longword x );

extern int _arp_resolve( longword ina, void *ethap, int nowait );

extern _survivebootp;
extern int sock_established( tcp_Socket *s);
extern sock_stats( tcp_Socket *s, word *days, word *inactive, word *cwindow, word *avg, word *sd );
extern int addwattcpd( void (*p)() );
extern int delwattcpd( void (*p)() );
extern int tap_add( void *socket, void *userid );


/*
 * socket macros
 */

/*
 * sock_wait_established()
 *      - waits then aborts if timeout on s connection
 * sock_wait_input()
 *      - waits for received input on s
 *      - may not be valid input for sock_gets... check returned length
 * sock_tick()
 *      - do tick and jump on abort
 * sock_wait_closed();
 *      - discards all received data
 *
 * jump to sock_err with contents of *statusptr set to
 *       1 on closed
 *      -1 on timeout
 *
 */

extern _ip_delay0( sock_type *s, int timeoutseconds, procref fn, int *statusptr );
extern _ip_delay1( sock_type *s, int timeoutseconds, procref fn, int *statusptr );
extern _ip_delay2( sock_type *s, int timeoutseconds, procref fn, int *statusptr );

// in UDP_NDS.C


extern int _last_nameserver;
extern char *_hostname;


/*
 * Send an icmp echo request using specified ttl and tos.
 * if(icmp_id != NULL) store copy of the id there
 */
/* backward compatibility */

extern void * _pkt_eth_init( void );
extern void pkt_release( void );
extern int pkt_send( char *buffer, int length );
extern void pkt_buf_wipe( void );
extern void pkt_buf_release( char *ptr );
extern void * pkt_received( void );



extern void _add_server( int *counter, int max1, longword *array, longword value );
extern word debug_on;
extern longword gethostid( void );

extern void * _tcp_lookup( longword hisip, word hisport, word myport );

extern int tcp_open(tcp_Socket *s, word lport, longword ina, word port, procref datahandler);
extern int udp_open(udp_Socket *s, word lport, longword ina, word port, procref datahandler);
extern int tcp_listen(tcp_Socket *s, word lport, longword ina, word port, procref datahandler, word timeout);
extern void sock_close(sock_type * );

void outch( char ch );          /* print character to stdio */
void outs( char *s);    /* print a ASCIIZ string to stdio */
void outsn( char  *s,int n);    /* print a string with len max n */
void outhex( char ch );
void outhexes( char *ch, int n );
void qmove( void * src, void * dest, int len );
int  qcmp( void  *src, void  *dest, int len );
void _keep( int status, int paragraphs );
int  sem_up( void  * ptr );
int chk_timeout( unsigned long timeout );

unsigned short inchksum( void  *ptr, int len);  /* IP checksum */

void movmem( void *src, void * dst, int size );


#endif /* ndef _wattcp_wattcp_h */

/******** the following is stolen from NCSA which came from CUTCP *********/
/* I have not implemented these, but someone may wish to in the future so */
/* I kept them around.                                                    */
/**************************************************************************/

/*
 * "vendor" data permitted for Stanford boot clients.
 */
struct vend {
	ubyte    v_magic[4];    /* magic number */
	longword v_flags;       /* flags/opcodes, etc. */
	ubyte    v_unused[56];  /* currently unused */
};

#define VM_STANFORD     "STAN"  /* v_magic for Stanford */
#define VM_RFC1048      "\143\202\123\143"

/* v_flags values */
#define VF_PCBOOT       1       /* an IBMPC or Mac wants environment info */
#define VF_HELP         2       /* help me, I'm not registered */
#define TAG_BOOTFILE_SIZE       13     /* tag used by vend fields rfc 1048 */


/*
 *
 * Ethernet Interface
 */

extern ubyte *_eth_FormatPacket(), *_eth_WaitPacket();

typedef struct ether {
    ubyte       dest[6];
    ubyte       src[6];
    word        type;
    ubyte       data[ 1500 ];
} ether;


#define ETH_MIN 60              /* Minimum Ethernet packet size */



#ifndef _wattcp_icmp_h
#define _wattcp_icmp_h

typedef struct icmp_unused {
    ubyte       type;
    ubyte       code;
    word        checksum;
    longword    unused;
    in_Header   ip;
    ubyte       spares[ 8 ];
} icmp_unused;

typedef struct icmp_pointer {
    ubyte       type;
    ubyte       code;
    word        checksum;
    ubyte       pointer;
    ubyte       unused[ 3 ];
    in_Header   ip;
} icmp_pointer;
typedef struct icmp_ip {
    ubyte       type;
    ubyte       code;
    word        checksum;
    longword    ipaddr;
    in_Header   ip;
} icmp_ip ;
typedef struct icmp_echo {
    ubyte       type;
    ubyte       code;
    word        checksum;
    word        identifier;
    word        sequence;
    longword index;
} icmp_echo;

typedef struct icmp_timestamp {
    ubyte       type;
    ubyte       code;
    word        checksum;
    word        identifier;
    word        sequence;
    longword    original;       /* original timestamp */
    longword    receive;        /* receive timestamp */
    longword    transmit;       /* transmit timestamp */
} icmp_timestamp;

typedef struct icmp_info {
    ubyte       type;
    ubyte       code;
    word        checksum;
    word        identifier;
    word        sequence;
} icmp_info;

typedef union  {
	struct icmp_unused      unused;
	struct icmp_pointer     pointer;
	struct icmp_ip          ip;
	struct icmp_echo        echo;
	struct icmp_timestamp   timestamp;
	struct icmp_info        info;
} icmp_pkt;

typedef struct _pkt {
    in_Header   in;
    icmp_pkt    icmp;
    in_Header   data;
} _pkt;

#define ICMPTYPE_ECHOREPLY       0
#define ICMPTYPE_UNREACHABLE     3
#define ICMPTYPE_TIMEEXCEEDED    11

typedef enum ICMP_UnreachableCodes
{
   ICMP_UNREACH_NET = 0,
   ICMP_UNREACH_HOST = 1,
   ICMP_UNREACH_PROTO = 2,
   ICMP_UNREACH_PORT = 3,
   ICMP_UNREACH_FRAGNEEDED = 4,
   ICMP_UNREACH_SRCROUTEFAILED = 5
} ICMP_UnreachableCodes;

typedef enum ICMP_TimeExceededCodes
{
   ICMP_EXCEEDED_TTL = 0,
   ICMP_EXCEEDED_FRAGREASM = 1
} ICMP_TimeExceededCodes;

/* a user-installed ICMP handler */
typedef int (*icmp_handler_type)( in_Header *ip );

/* install a user ICMP handler, or NULL to disable */
void set_icmp_handler( icmp_handler_type user_handler );

extern void ip_timer_init(udp_Socket *s, int seconds);

extern void _arp_add_gateway( char *data , longword ip );

int udp_write(udp_Socket *s, ubyte *datap, int len, word offset);


#endif /* ndef _wattcp_icmp_h */
