//
// U D P L I B . C
//

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

#include "wattcp.h"

extern void tcp_tick();
extern tcp_shutdown();

// largest chunk of data which we will pass through the network. this is
// well below the Internet's minimum MTU value so we can be assured that
// even after we tack on our own header information the complete packet
// will be passed along without being fragmented. Our packet buffer sizes
// are tied to this value.
#define MTU 542

// resolved IP address in network byte order
typedef unsigned long ipaddr;

// structure for the header data tacked on by our driver
typedef struct _PktHdr {
	unsigned long seq;              // sender's sequence number
	unsigned length;                // length of packet data
} PktHdr;

// structure for data sent in each UDP packet we send/receive
typedef struct _Packet {
	PktHdr hdr;                     // our header information
	unsigned char data[MTU];        // application's packet data
} Packet;

// structure for internal packet buffers - adds an in-use flag
typedef struct _PacketBuffer {
	int validData;                  // does this buffer contain data?
	ipaddr src;                     // source node
	Packet p;                       // packet data
} PacketBuffer;

// number of incoming packets to buffer before we start dropping them
#define NBUFFERS 15

unsigned dropped=0;                     // number of packets we had to drop
                                        // due to lack of buffer space
                                        // if NBUFFERS is set correctly this
                                        // value should remain at 0
unsigned badlen=0;                      // number of packets received with
                                        // an incorrect length
unsigned long seq=0;                    // packet sequence number
                                        // used in the current implementation
                                        // to reorder out-of-sequence packets
                                        // we increment this value with each
                                        // packet that we send
unsigned port=0;                        // currently open port
udp_Socket listen;                      // socket used for listening
udp_Socket talk;                        // socket used for talking
PacketBuffer packets[NBUFFERS];         // incoming packet buffers

//
// D A T A H A N D L E R
//
// Description: Incoming packet processor. Called by tcp_tick() for
//     each incoming UDP packet. Copies the data into an available buffer
//     and extracts the source node information from the packet's UDP
//     pseudoheader.
//
// Parameters:
//     s (in) - Pointer to the UDP socket.
//     dp (in) - Pointer to the incoming data buffer.
//     len (in) - Length of the data.
//     ph (in) - Packet pseudoheader.
//     up (in) - Upcall routine pointer - unused.
//
int dataHandler(udp_Socket * s, byte *dp, int len, void *ph, void * up)
{
int i;
Packet *data = (Packet *)dp;
int r_len;

	s=s;	//compiler warning!
	up = up;	// compiler warning!

	// look for a free data buffer
        for (i=0; i<NBUFFERS; ++i)
		if (packets[i].validData == 0)
			break;

        if (i == NBUFFERS) {
                dropped++;              // bump the dropped packet count
                return(0);              // Yikes!! no free packet buffers
                }

	if (len > 0) {
                // perform sanity check on the packet length
                r_len = data->hdr.length + sizeof(PktHdr);
                if (r_len == len) {
                        // copy data to buffer, flag buffer as in use
                        memcpy(&packets[i].p, dp, len);
                        packets[i].src = intel(((tcp_PseudoHeader *)ph)->src);
                                        // ph->src is in Intel byte order;
                                        // convert it to network byte order
                                        // so as to match resolved IP addr
                        packets[i].validData = 1;
                        }
                else
                        badlen++;        // packet length mismatch
		}

        return(len);
}


//
// S P C _ C L O S E
//
// Description: Shutdown the currently open port (if any).
//
// Returns:
//     0 if successful,
//     1 if an error occurred.
//

int udplib_close(void)
{

        sock_close(&listen);            // this is OK even if the socket was
                                        // not opened previously
        port = 0;
        return (0);
}


//
// S P C _ O P E N
//
// Description: Open the specified UDP port for send/receive. NOTE: under
//     the current implementation, only one port can bo open at a time;
//     if this function is called while another port is already open, that
//     port will be closed so that the requested port may be opened.
//
// Parameters:
//     p (in) - Port to open.
//
// Returns:
//     0 if port successfully opened,
//     1 if error.
//

int udplib_open(unsigned p)
{

        if (port)
                udplib_close();

        port = p;
//        if (!udp_open(&listen, port, 0xffffffff, port, dataHandler))
        if (!udp_open(&listen, port, -1, port, dataHandler))
        		return (1);

        return (0);
}




//
// S P C _ D E I N I T
//
// Description: Shut down the driver.
//
// Returns:
//     0 if successful
//

int udplib_deinit(void)
{

        if (port)
                udplib_close();

        tcp_shutdown();
        return (0);
}

//
// S P C _ I N I T
//
// Description: Initialize the driver.
//
// Returns:
//     0 if successful
//

int udplib_init(unsigned int * my_ip)
{
	if (!sock_init()) return 0;
	*my_ip = my_ip_addr;
	port = 0;

	return (1);
}


//
// S P C _ S E N D
//
// Description: Send the data in the transfer buffer to the node specified in
//     the transfer buffer's node field.
//
// Returns:
//     0 if successful,
//     1 if an error occurred.
//

int udplib_send(unsigned int ipaddr, int len, void * data )
{
	static Packet sendbuf;          // where outgoing packets are assembled

	if (!port)
		return (1);     // D'OHH! Gotta open the port before you send

	// set up the packet for transmission
	sendbuf.hdr.seq = seq++;
	sendbuf.hdr.length = len;
	memcpy(sendbuf.data, data, len );

	// this sequence is the WATTCP equivalent to a BSD sendto() call
	if (udp_open(&talk, port, ipaddr, port, dataHandler)) {
			udp_write(&talk, (unsigned char *)&sendbuf, len+sizeof(PktHdr), 0);
			sock_close(&talk);
			return (1);
	}
	return (0);
}


//
// S P C _ R E C V
//
// Description: Get available data, if any, and place it into the transfer
//     buffer. If more than one packet is waiting, return the oldest one.
//
// Returns:
//     0 if data was placed into the xfer buffer,
//     1 if no data available or an error occurred.
//

void udplib_tick()
{
	tcp_tick();         // tell WATTCP to process incoming packets
}

int udplib_receive(unsigned int *ipaddress, void * data )
{
	int i, index_of_oldest=-1;              // packet buffer indices
	unsigned long oldest=0xffffffffL;       // oldest packet so far
	PacketBuffer *packet;                   // packet being processed
	int ret_length;

GetAnotherPacket:
	udplib_tick();

	// assume no packets will be waiting
 	ret_length = 0;

        // check the packet buffers for new data
        // if more than one packet is waiting, return the oldest one
        for (i=0; i<NBUFFERS; ++i) {
                if (!packets[i].validData)
                        continue;

                if (packets[i].p.hdr.seq < oldest) {
                        oldest = packets[i].p.hdr.seq;
                        index_of_oldest = i;
                        }
                }

        if (oldest == 0xffffffffL || index_of_oldest < 0)
                return (0);             // no packets waiting

        // point to the packet we're working on
        packet = &packets[index_of_oldest];
        if (packet->p.hdr.length > MTU) {
                // whoa - packet is too big!?!?!?!?
                packet->validData = 0;
					goto GetAnotherPacket;
                }

        // copy the data into the xfer buffer
        *ipaddress = packet->src;
        ret_length = packet->p.hdr.length;
        memcpy(data, packet->p.data, packet->p.hdr.length );
        packet->validData = 0;

        return ret_length;     // success
}


//
// S P C _ G E T _ D R I V E R _ S T A T U S
//
// Description: Placeholder for a driver status function. This could be used
//     to inquire about such things as ICMP errors or the number of dropped
//     packets. Currently does nothing.
//
// Returns:
//     0 if successful (at doing nothing).
//

int udplib_get_status(void)
{
	return (0);
}

int udplib_resolve( unsigned int *ipaddress, char * name )
{
	*ipaddress = resolve( name );
	return 0;
}

char * udplib_inet2a( unsigned int ipaddr, char * buffer )
{
	return inet_ntoa( buffer, ipaddr );
}


