#include "wattcp.h"
#include "dpmi.h"

// FRAGSUPPORT enables support for packet reassembly of fragmented packets
//#define FRAGSUPPORT

// fragfix -- just a note this is intel
#define IP_DF       0x0040      // Don't fragment bit set for FRAG Flags

#define MAXBUFS	5			//maximum number of Ethernet buffers
#define BUFSIZE	2100

ubyte pkt_interrupt;
ushort pkt_ip_handle;
ushort pkt_arp_handle;
ubyte pkt_interface_num=0;

int _pktipofs = 0;	// offset from header to start of pkt

#define INT_FIRST 0x60
#define INT_LAST  0x80
#define PD_DRIVER_INFO	0x1ff
#define PD_ACCESS 	0x200
#define PD_RELEASE	0x300
#define PD_SEND		0x400
#define PD_GET_ADDRESS	0x600
#define CARRY 		1	     /* carry bit in flags register */

ubyte eth_addr[ 6 ];
char *pkt_line = "PKT DRVR";


extern void asmpkt_start();
extern void asmpkt_entry();
extern void asmpkt_stop();

extern ushort asmpkt_maxbufs, asmpkt_maxlen, asmpkt_bufs, asmpkt_bufseg;

#define PKT_SIZE (BUFSIZE + 2)
ubyte * pktbuf;	// first ubyte is busy flag, 2nd spare

ushort pktasm_real_seg = 0;
ushort pktasm_real_off = 0;

ubyte *pcpkt_callback;
ushort *pcpkt_ip_type;		/* these are intelled values */
ushort *pcpkt_arp_type;

void pktasminit()
{
	uint code_length;
	ushort dos_selector;

	pcpkt_ip_type = dpmi_real_malloc( 2, &dos_selector );
	pcpkt_arp_type = dpmi_real_malloc( 2, &dos_selector );

	*pcpkt_ip_type = 0x0008;		/* these are intelled values */
	*pcpkt_arp_type = 0x608;

//	printf( "start = 0x%08x\n", (int)asmpkt_start );
//	printf( "cfunc = 0x%08x\n", (int)asmpkt_entry );
//	printf( "cstop = 0x%08x\n", (int)asmpkt_stop );

	pktbuf = (ubyte *)dpmi_real_malloc( MAXBUFS*(BUFSIZE + 2), &dos_selector );

	asmpkt_maxbufs = MAXBUFS;
	asmpkt_maxlen = BUFSIZE;
	asmpkt_bufs = DPMI_real_offset( pktbuf );
	asmpkt_bufseg = DPMI_real_segment( pktbuf );

	code_length = (uint)asmpkt_stop - (uint)asmpkt_start;
	pcpkt_callback = dpmi_real_malloc( code_length, &dos_selector );

	// Copy it down into real mode area
	memcpy( pcpkt_callback, asmpkt_start, code_length );
	pcpkt_callback += ((uint)asmpkt_entry-(uint)asmpkt_start);

//	printf( "pktbuf located at %04x:%04x\n", asmpkt_bufseg, asmpkt_bufs );
//	printf( "asmpkt located at %04x:%04x\n", DPMI_real_segment(pcpkt_callback), DPMI_real_offset(pcpkt_callback) );
//	printf( "pcpkt_callback = %08x\n", pcpkt_callback  );
}

int show_pkt_info = 0;

int pkt_init(void)
{
	dpmi_real_regs regs;
	ushort * tmp;
	ubyte  * temp;
	int i;
	int pd_type;

	pktasminit();
	pkt_buf_wipe();
	for (pkt_interrupt = INT_FIRST; pkt_interrupt <= INT_LAST; ++pkt_interrupt ) {
		temp = dpmi_get_real_vector( pkt_interrupt );
		if ( temp )	{
			if ( !memcmp( &(temp[3]), pkt_line, strlen( pkt_line )))
				break;
		}
	}

	if ( pkt_interrupt > INT_LAST ) {
		return 1;
	}

	if (show_pkt_info) printf( "Packet driver found on int 0x%x\n", pkt_interrupt );

	//INT 60 - FTP Packet Driver - BASIC FUNC - RESET INTERFACE
	memset(&regs,0,sizeof(regs));
	regs.eax = 0x0700;
	regs.ebx = 0;
	dpmi_real_int386x( pkt_interrupt, &regs );

	// lets find out about the driver
	memset(&regs,0,sizeof(regs));
	regs.eax = PD_DRIVER_INFO;
	dpmi_real_int386x( pkt_interrupt, &regs );

	// handle old versions, assume a class and just keep trying
	if (regs.flags & CARRY) {
#if 1
		printf("ERROR old type packet driver.\n\r");
		return 1;
#else
		for ( class = 0; class < 2; ++class ) {
			_pktdevclass = (class) ? PD_SLIP : PD_ETHER;

			for (pd_type = 1; pd_type < 128; ++pd_type ) {
				regs.eax = PD_ACCESS | _pktdevclass;  /* ETH, SLIP */
				regs.ebx = pd_type;		/* type */
				regs.edx = 0;			/* if number */
				regs.ecx = (_pktdevclass == PD_SLIP ) ? 0 : sizeof( *pcpkt_ip_type);
				regs.ds = FP_SEG( pcpkt_ip_type );
				regs.esi = FP_OFF( pcpkt_ip_type );
				regs.es = FP_SEG( _pktentry);
				regs.edi = FP_OFF( _pktentry);
				intr( pkt_interrupt, &regs );
				if ( ! (regs.r_flags & CARRY) ) break;
			}

			if (pd_type == 128 ) {
				//printf("ERROR initializing packet driver\n\r");
				return 1;
			}
			
			// we have found a working type, so kill it
			regs.r_bx = regs.r_ax;	// handle
			regs.r_ax = PD_RELEASE;
			intr( pkt_interrupt, &regs );
		}
#endif
	} else {
		pd_type = regs.edx & 0xFFFF;
		_pktdevclass = ((regs.ecx & 0xFFFF) >> 8);
		if (show_pkt_info) printf( "Type: %d ", _pktdevclass );
		switch ( _pktdevclass ) {
		case PD_ETHER: 
			_pktipofs = 14;
			if (show_pkt_info) printf( "(Ethernet)\n" );
			break;
		case PD_SLIP: 
			_pktipofs = 0;
			if (show_pkt_info) printf( "(SLIP)\n" );
			break;
		default: 
			if (show_pkt_info) printf( "(Unknown)\n" );
			//printf("ERROR: only Ethernet or SLIP packet drivers allowed\n\r");
			return( 1 );
		}
		
		
	   // DS:SI -> name
	   // AL = driver functions supported
		if (show_pkt_info) printf( "Support: 0x%02x (", regs.eax & 0xFF );
		switch( regs.eax & 0xFF )	{
		case 0x01: if (show_pkt_info) printf( "basic" ); break;
		case 0x02: if (show_pkt_info) printf( "basic and extended" ); break;
		case 0x05: if (show_pkt_info) printf( "basic and high-performance" ); break;
		case 0x06: if (show_pkt_info) printf( "basic, high-performance, and extended" ); break;
		case 0xFF: if (show_pkt_info) printf( "not installed" ); break;
		default:	  if (show_pkt_info) printf( "unknown" ); break;
		}
		if (show_pkt_info) printf( ")\n" );

		if (show_pkt_info) printf( "Version: %d\n", regs.ebx & 0xFFFF );
		if (show_pkt_info) printf( "Name: '%s'\n", (ubyte *)((regs.ds<<4)+(regs.esi & 0xFFFF)) );
		if (show_pkt_info) printf( "Interface #:%d\n", regs.ecx & 0xFF );
		if (show_pkt_info) printf( "Type: %d\n", pd_type  );
		pkt_interface_num	 = regs.ecx & 0xFF;
	}

	memset(&regs,0,sizeof(regs));
	regs.eax = PD_ACCESS | _pktdevclass;
	regs.ebx = 0xffff;		// any type 
	regs.edx = pkt_interface_num;			// if number
	regs.ecx = (_pktdevclass == PD_SLIP) ? 0 : 2;	//sizeof( pkt_ip_type );
	tmp = dpmi_get_temp_low_buffer( 2 );
	regs.ds = DPMI_real_segment(pcpkt_ip_type);
	regs.esi = DPMI_real_offset(pcpkt_ip_type);
	regs.es = DPMI_real_segment(pcpkt_callback);			//FP_SEG( _pktentry);
	regs.edi = DPMI_real_offset(pcpkt_callback);		//FP_OFF( _pktentry);

   dpmi_real_int386x( pkt_interrupt, &regs );

	// handle old versions, assume a class and just keep trying
	if (regs.flags & CARRY) {
		//printf( "ERROR # 0x%x accessing packet driver\n", (regs.edx & 0xFFFF) >> 8 );
		return 1;
	}
	pkt_ip_handle = regs.eax & 0xFFFF;

	//printf( "IP handle: %d\n", pkt_ip_handle );

	if (_pktdevclass != PD_SLIP) {
		memset(&regs,0,sizeof(regs));
		regs.eax = PD_ACCESS | _pktdevclass;
		regs.ebx = 0xffff;		// any type 
		regs.edx = pkt_interface_num;			// if number
		regs.ecx = (_pktdevclass == PD_SLIP) ? 0 : 2;	//sizeof( pkt_ip_type );
		regs.ds = DPMI_real_segment(pcpkt_arp_type);
		regs.esi = DPMI_real_offset(pcpkt_arp_type);
		regs.es = DPMI_real_segment(pcpkt_callback);			//FP_SEG( _pktentry);
		regs.edi = DPMI_real_offset(pcpkt_callback);		//FP_OFF( _pktentry);
	
	   dpmi_real_int386x( pkt_interrupt, &regs );
	
		// handle old versions, assume a class and just keep trying
		if (regs.flags & CARRY) {
			//printf( "ERROR # 0x%x accessing packet driver\n", (regs.edx & 0xFFFF) >> 8 );
			return 1;
		}
		pkt_arp_handle = regs.eax & 0xFFFF;
	
		//printf( "ARP handle: %d\n", pkt_arp_handle );
	}


	// get ethernet address
	memset(&regs,0,sizeof(regs));
	temp = dpmi_get_temp_low_buffer( sizeof(eth_addr) );
	regs.eax = PD_GET_ADDRESS;
	regs.ebx = pkt_ip_handle;
	regs.es = DPMI_real_segment(temp);
	regs.edi = DPMI_real_offset(temp);
	regs.ecx = sizeof( eth_addr );
	dpmi_real_int386x( pkt_interrupt, &regs );
	if ( regs.flags & CARRY ) {
		//printf("ERROR reading ethernet address\n" );
		return 1;
	}
	memcpy( eth_addr, tmp, sizeof( eth_addr ) );
	if (show_pkt_info) {
		printf( "Ethernet address: " );
		for (i=0; i<sizeof(eth_addr); i++ )
			printf( "%02x ", eth_addr[i] );
		printf( "\n" );
	}

	return 0;
}





typedef struct pkt_info {
	uint packets_in;
	uint packets_out;
	uint bytes_in;
	uint bytes_out;
	uint errors_in;
	uint errors_out;
	uint packets_dropped;
} pkt_info;

void pkt_release()
{
	pkt_info * tmp;
	dpmi_real_regs regs;

	memset(&regs,0,sizeof(regs));
	tmp = dpmi_get_temp_low_buffer( sizeof(pkt_info) );

	//INT 60 - FTP Packet Driver - EXTENDED FUNC - GET STATISTICS
	regs.eax = 0x1800;
	regs.ebx = 0;
	regs.ds = DPMI_real_segment(tmp);
	regs.esi = DPMI_real_offset(tmp);
	dpmi_real_int386x( pkt_interrupt, &regs );

	if ( regs.flags & CARRY )	{
		if (show_pkt_info) printf( "No packet stats available\n" );
	} else {
		tmp = (pkt_info *)((regs.ds <<4) + (regs.esi & 0xFFFF));
	
		if (show_pkt_info) {
			printf( "Packet Stats:\n" );
			printf( "-------------\n" );
			printf( "Packets in: %d\n", tmp->packets_in );
			printf( "Packets out: %d\n", tmp->packets_out);
			printf( "Bytes in: %d\n", tmp->bytes_in);
			printf( "Bytes out: %d\n", tmp->bytes_out);
			printf( "Errors in: %d\n", tmp->errors_in);
			printf( "Errors out: %d\n", tmp->errors_out);
			printf( "Packets dropped: %d\n", tmp->packets_dropped);
		}
	}

	if ( _pktdevclass != PD_SLIP ) {
		memset(&regs,0,sizeof(regs));
	
		regs.eax = PD_RELEASE;
		regs.ebx = pkt_arp_handle;
		dpmi_real_int386x( pkt_interrupt, &regs );
	
		if (regs.flags & CARRY )	{
			//printf( "ERROR releasing ARP handle\n");
		} else {
			if (show_pkt_info) printf( "ARP handle released OK\n" );
		}
	}

	memset(&regs,0,sizeof(regs));

	regs.eax = PD_RELEASE;
	regs.ebx = pkt_ip_handle;
	dpmi_real_int386x( pkt_interrupt, &regs );

	if (regs.flags & CARRY )	{
		//printf( "ERROR releasing IP handle\n");
	} else {
		if (show_pkt_info) printf( "IP handle released OK\n" );
	}

}


int pkt_send( char *buffer, int length )
{
	dpmi_real_regs regs;
	int retries;
	
//	printf( "Sending packet at %08x, len=%d\n", buffer, length );

	retries = 5;
	while (retries--) {
		memset(&regs,0,sizeof(regs));
		regs.eax = PD_SEND;
		regs.ds = DPMI_real_segment(buffer);
		regs.esi = DPMI_real_offset(buffer);
		regs.ecx = (uint)length;
		dpmi_real_int386x( pkt_interrupt, &regs );
		if ( regs.flags & CARRY )
			continue;
		return( 0 );
	}
//	printf( "Packet send failed.\n" );
	return( 1 );
}

// return a buffer to the pool
void pkt_buf_wipe()
{
    memset( pktbuf, 0, sizeof( ubyte ) * MAXBUFS * (BUFSIZE+ 2));
}

void pkt_buf_release( char *ptr )
{
	ptr -= (2 + _pktipofs);
//	printf( "Releasing packet at 0x%08x, mark: 0x%02x\n", ptr, *ptr );
	*ptr = 0;
}

void * pkt_received( void )
{
    word old;
    int i;
    word oldin, newin;	/* ip sequence numbers */
    eth_Header  * temp_e = NULL;
    in_Header   * temp;
    extern int active_frags;

    /* check if there are any */
    old = oldin = 0xffff;

	
//	printf( "Checking for recieved packets\n" );

    // Do frag timeout bit sad if we got the bit of one we're about to kill
    for ( i = 0 ; i < MAXBUFS; ++i ) {

		if ( pktbuf[i*PKT_SIZE+0] != 1 ) continue;

//		printf( "Found packet %d\n", i );

        // check if fragmented - SLIP supported
	temp = (in_Header *) &pktbuf[ (i*PKT_SIZE) + 2 ];
        if ( _pktdevclass == PD_ETHER ) {
            temp_e = (eth_Header *) temp;
// fragfix -- next line did pointer arith so incorrectly added
//               ... * sizeof(typeof(*temp)) instead of ... * 1
//            temp += sizeof( eth_Header );
            temp = (in_Header *)((ubyte*)temp + sizeof(eth_Header));
        }

        newin = *((word *)(&pktbuf[i*PKT_SIZE+4+2+_pktipofs]));
//printf( "newin = %d, oldin = %d\n", newin, oldin );
        if ( newin <= oldin ) {
            oldin = newin;
            old = i;
        }
    }
	if ( old == 0xffff )
		return NULL;

	return &pktbuf[old*PKT_SIZE+2];
//   return( (old == 0xffff) ? NULL : &pktbuf[old*PKT_SIZE+2] );
}

void * _pkt_eth_init()
{
	if ( pkt_init() ) {
//		printf("Program halted\n");
		return NULL;
	}
	return eth_addr;
}


                             
