#include "wattcp.h"

/*
 * ICMP - RFC 792
 */



/* constants */

extern void _udp_cancel( in_Header *ip );

static word icmp_id = 0;

static longword ping_hcache = 0;	/* host */
static longword ping_tcache = 0;	/* time */
static longword ping_number = 0;
extern word multihomes;

/*
 * icmp_Reply - format a reply packet
 *  	      - note that src and dest are NETWORK order not host!!!!
 */
void icmp_Reply( struct _pkt *p, longword src, longword dest, int icmp_length )
{
    in_Header *ip;
    icmp_pkt *icmp;

    ip = &p->in;
    memset( ip, 0, sizeof( in_Header ));
    icmp = &p->icmp;

    /* finish the icmp checksum portion */
    icmp->unused.checksum = 0;
    icmp->unused.checksum = ~inchksum( icmp, icmp_length );

    /* encapsulate into a nice ip packet */
	ip->hdrlen_ver = HDRLENVER;
    //ip->ver = 4;
    //ip->hdrlen = 5;
    ip->length = intel16( sizeof( in_Header ) + icmp_length);
    ip->tos = 0;
    ip->identification = intel16( icmp_id ++);	/* not using ip id */
//    ip->frag = 0;
    ip->ttl = 250;
    ip->proto = ICMP_PROTO;
    ip->checksum = 0;
    ip->source = src;
    ip->destination = dest;
    ip->checksum = ~ inchksum( ip, sizeof( in_Header ));

    _eth_send( intel16( ip->length ));
}



icmp_handler( in_Header *ip )
{
	icmp_pkt *icmp, *newicmp;
	_pkt *pkt;
	int len, code;
	in_Header *ret;

	len = in_GetHdrlenubytes( ip );
	icmp = (icmp_pkt*)((ubyte *)ip + len);
	len = intel16( ip->length ) - len;
	if ( inchksum( icmp, len ) != 0xffff ) {
		return( 1 );
	}

	code = icmp->unused.code;
	ret = & (icmp->ip.ip);

	switch ( icmp->unused.type) {
	case 0 : /* icmp echo reply received */
		/* icmp_print( icmp, "received icmp echo receipt"); */

		/* check if we were waiting for it */
		ping_hcache = intel( ip->source );
		ping_tcache = set_timeout( 1 ) - *(longword *)(&icmp->echo.identifier );
		if (ping_tcache > 0xffffffffL)
		    ping_tcache += 0x1800b0L;
		ping_number = *(longword*)( ((ubyte*)(&icmp->echo.identifier)) + 4 );
		/* do more */
		break;

	case 3 : /* destination unreachable message */
		if (code < 6) {
		    if (ret->proto == UDP_PROTO)
				_udp_cancel( ret );
		}
		break;

	case 4  : /* source quench */
		break;

	case 5  : /* redirect */
		break;

	case 8  : /* icmp echo request */

                // don't reply if the request was made by ourselves
                // such as a problem with Etherslip pktdrvr
                if  ( (longword) (ip->destination - intel( my_ip_addr)) > multihomes )
                    return( 1 );

                // do arp and create packet
                /* format the packet with the request's hardware address */
                pkt = (_pkt *)_eth_formatpacket( (void *)_eth_hardware((void *)ip), 8);

		newicmp = &pkt->icmp;

		movmem( icmp, newicmp, len );
		newicmp->echo.type = 0;
		newicmp->echo.code = code;

		/* use supplied ip values in case we ever multi-home */
		/* note that ip values are still in network order */
		icmp_Reply( pkt,ip->destination, ip->source, len );


		break;

	case 11 : /* time exceeded message */
		break;

	case 12 : /* parameter problem message */
		break;

	case 13 : /* timestamp message */
		/* send reply */
		break;

	case 14 : /* timestamp reply */
		/* should store */
		break;

	case 15 : /* info request */
		/* send reply */
		break;

	case 16 : /* info reply */
		break;

    }
    return( 1 );
}


