#include "wattcp.h"

#define MY_IP		"MY_IP"
#define IP              "IP"
#define NETMASK 	"NETMASK"
#define GATEWAY 	"GATEWAY"
#define HOSTNAME	"HOSTNAME"
#define SOCKDELAY	"SOCKDELAY"
#define ETHIP		"ETHIP"
#define MSS			"MSS"
#define INACTIVE        "INACTIVE"
#define INCLUDE         "INCLUDE"
#define MULTIHOMES      "MULTIHOMES"


#define is_it( x ) if (!strcmp(name,x))

/*
 * _inet_atoeth - read src, dump to ethernet buffer
 *		  and return pointer to end of text string
 */
char *_inet_atoeth( char *src, ubyte *eth )
{
    word count, val;
    ubyte ch, icount;

    val = count = icount = 0;
    while ((ch = toupper(*src++)) != 0 ) {
        if (ch == ':' ) continue;
        if (ch == ',' ) break;

        if ((ch -= '0') > 9) ch -= 7;
        val = (val << 4) + ch;

        if ( icount ) {
            eth[ count++ ] = val;
            if (count > 5) break;
            val = icount = 0;
        } else
            icount = 1;
    }
    if ( *src == ',' ) ++src;
    return( src );
}

static void ethip( char *s )
{
    eth_address temp_eth;
    char *temp;

    if (( temp = _inet_atoeth( s, temp_eth )) != NULL ) {
	if (!memcmp( temp_eth, _eth_addr, sizeof( eth_address ))) {
            my_ip_addr = inet_addr( temp );
        }
    }
}

word sock_delay = 30;
word sock_inactive = 0;  /* defaults to forever */
word multihomes = 0;
void (*usr_init)() = NULL;

static set_values(char *name, char *value )
{
	strupr(name);

	is_it( MY_IP ) {
		my_ip_addr = resolve( value );
	} else is_it( IP ) {
		my_ip_addr = resolve( value );
	} else is_it( NETMASK) {
		sin_mask = resolve( value );
	} else is_it( GATEWAY)
		_arp_add_gateway( value , 0L );
	else is_it( HOSTNAME ) strncpy(_hostname, value, MAX_STRING );
	else is_it( SOCKDELAY ) sock_delay = atoi( value );
	else is_it( ETHIP )  ethip( value );
	else is_it( MSS ) _mss = atoi( value );
	else is_it( INACTIVE ) sock_inactive = atoi( value );
	else is_it( MULTIHOMES ) multihomes = atoi( value );
}

char *watfname = "WATTCP.CFG";

tcp_config( char *path )
{
    char name[80];	//, *temp;
    char value[80], ch[2];
    int  quotemode;
    int mode;
	FILE * f;

	path = path;	// warning killer

#ifndef __WATCOMC__
    if (!path) {
	if ((path = getenv( watfname )) != NULL ) {
	    path = strcpy( name, path );
	    strcat( name, "\\");
	} else {
	    strcpy( name, _argv[0] );
	    path = ( *name && (name[1] == ':')) ? &name[2] : name;
	    if (!(temp = strrchr( path, '\\' ))) temp = path;
	    *(++temp) = 0;
	}
/*
        strcpy( name, path );
        strcat( name, "\\");
*/
        strcat( name, watfname );
    } else
        strcpy( name, path );
#else
	strcpy( name, "wattcp.cfg" );
#endif

	f = fopen( watfname, "rt" );
    if ( !f ) {
	    return( -1 );
	}
    *name = *value = mode = ch[1] = quotemode = 0;
    while ( fread( ch, 1, 1, f ) == 1) {
	switch( *ch ) {
	    case  '\"': quotemode ^= 1;
			break;
	    case  ' ' :
	    case  '\t': if (quotemode) goto addit;
			break;

	    case  '=' : if (quotemode) goto addit;
			if (!mode) mode = 1;
			break;
	    case  '#' :
	    case  ';' : if (quotemode) goto addit;
			mode = 2;
			break;
	    case  '\n':
	    case  '\r': if (*name && *value)
			    set_values(name, value);
			*name = *value = quotemode = mode = 0;
			break;
	    default   :
addit:
      			switch (mode ) {
			case 0 : strcat(name, ch);
				 break;
			case 1 : strcat(value, ch);
				 break;
			}
			break;
	}
    }
    fclose(f);
    return( 0 );
}


