#include "wattcp.h"

#define TICKER (*(volatile int *)0x46C)

static ubyte hour = 0;
static unsigned long date = 0;

void movmem( void *src, void * dst, size_t size )
{
	memmove( dst, src, size );
}

longword intel( longword x )
{
	longword tmp;
	ubyte * src, * dst;
	int i;
	src = (ubyte *)&x;
	dst = (ubyte *)&tmp;
	for (i=0; i<4; i++ )
		dst[i] = src[3-i];
	return tmp;
}

word intel16( word x )
{
	word tmp;
	swab( (void *)&x, (void *)&tmp, 2 );
	return tmp;
}


/* IP checksum */
unsigned short inchksum_sub(void *buf, int cnt);
#pragma aux inchksum_sub parm [esi] [ecx] modify exact [esi edi eax ebx ecx edx] = \
	"mov bl, cl"	\
	"shr ecx, 2"	\
	"xor edx, edx"	\
	"cld"	\
	"jcxz	remain"	\
	"clc" \
"deloop:	lodsd"	\
	"adc	edx,eax"	\
	"loop	deloop"	\
	"adc	edx,0"	\
"remain: xor	ecx,ecx" \
	"test bl, 2"	\
	"jz	remai1"	\
	"lodsw" \
	"mov	cx,ax"	\
"remai1:	test	bl, 1"	\
	"jz	done1"	\
	"xor	eax,eax"	\
	"lodsb"	\
	"add	ecx,eax"\
"done1:	add	edx,ecx"\
 	"adc edx, 0"	\
"done:	mov	eax,edx"\
	"and	eax, 0ffffh "\
	"shr	edx, 16 "\
	"add	eax,edx"\
	"btr	eax, 16"\
	"jnc	done2"	\
	"inc	eax"	\
"done2: "


unsigned short inchksum(void *buf, int cnt)
{
	return inchksum_sub(buf, cnt);
}

unsigned long set_timeout( unsigned short seconds )
{
  return TICKER + date + (1165 * (unsigned long)seconds) / 64;
}

unsigned long set_ttimeout( unsigned int ticks )
{
  return TICKER + date + ticks;
}

int chk_timeout( unsigned long timeout )
{
  unsigned long time;
  time = TICKER;
  if ( ((byte *)(&time))[2] != hour )
  {
    if ( ((byte *)(&time))[2] < hour ) 
      date += 0x1800B0;
    hour = ((byte *)(&time))[2];
  }
  time += date;
  return (time > timeout);
}

/*
 * aton()
 *	- converts [a.b.c.d] or a.b.c.d to 32 bit long
 *	- returns 0 on error (safer than -1)
 */

longword aton( char * text )
{
	int i, cur;
	longword ip;

	ip = 0;

	if ( *text == '[' )
		++text;
	for ( i = 24; i >= 0; i -= 8 ) {
		cur = atoi( text );
		ip |= (longword)(cur & 0xff) << i;
		if (!i) return( ip );

		if (!(text = strchr( text, '.')))
			return( 0 );	/* return 0 on error */
		++text;
	}
	return 0;
}

/*
 * isaddr
 *	- returns nonzero if text is simply ip address
 */
int isaddr( char * text )
{
	char ch;
	while ( ch = *text++ ) {
		if ( isdigit(ch) ) continue;
		if ( ch == '.' || ch == ' ' || ch == '[' || ch == ']' )
			continue;
		return( 0 );
	}
	return( 1 );
}



char *rip( char *s )
{
    char *temp;

    if (temp = (char *)strchr( s, '\n')) *temp = 0;
    if (temp = (char *)strchr( s, '\r')) *temp = 0;
    return( s );
}
