#ifndef _DPMI_H
#define _DPMI_H

typedef struct dpmi_real_regs {
    unsigned int edi;
    unsigned int esi;
    unsigned int ebp;
    unsigned int reserved_by_system;
    unsigned int ebx;
    unsigned int edx;
    unsigned int ecx;
    unsigned int eax;
    unsigned short flags;
    unsigned short es,ds,fs,gs,ip,cs,sp,ss;
} dpmi_real_regs;

#pragma intrinsic( inp );
#pragma intrinsic( outp );
#pragma intrinsic( _enable );
#pragma intrinsic( _disable );

#define DPMI_real_segment(P)	((((unsigned int) (P)) >> 4) & 0xFFFF)
#define DPMI_real_offset(P)	(((unsigned int) (P)) & 0xF)

// Initializes dpmi. Returns zero if failed.
extern int dpmi_init(int verbose);
// Returns a pointer to a temporary dos memory block. Size must be < 1024 bytes.
extern void *dpmi_get_temp_low_buffer( int size );
extern void *dpmi_real_malloc( int size, unsigned short *selector );
extern void dpmi_real_free( unsigned short selector );
extern void dpmi_real_int386x( unsigned char intno, dpmi_real_regs * rregs );
extern void dpmi_real_call(dpmi_real_regs * rregs);
extern int dpmi_lock_region(void *address, unsigned length);
extern int dpmi_unlock_region(void *address, unsigned length);
// returns 0 if failed...
extern int dpmi_allocate_selector( void * address, int size, unsigned short * selector );
extern int dpmi_modify_selector_base( unsigned short selector, void * address );
extern int dpmi_modify_selector_limit( unsigned short selector, int size  );

extern char * dpmi_get_real_vector( int intno );



// Sets the PM handler. Returns 0 if succssful
extern int dpmi_set_pm_handler(unsigned intnum, void far * isr );

extern unsigned int dpmi_virtual_memory;
extern unsigned int dpmi_available_memory;
extern unsigned int dpmi_physical_memory;
extern unsigned int dpmi_dos_memory;

#endif
