.286

_TEXT16 SEGMENT BYTE PUBLIC USE16 'CODE'
        ASSUME  cs:_TEXT16

;**
;** The real-mode packet callback handler
;**
	PUBLIC	asmpkt_start_, asmpkt_entry_, asmpkt_stop_
	PUBLIC	_asmpkt_maxbufs, _asmpkt_maxlen, _asmpkt_bufs, _asmpkt_bufseg

asmpkt_start_:
	_asmpkt_maxbufs		dw	1		; CS:0
	_asmpkt_maxlen		dw	2		; CS:2
	_asmpkt_bufs		dw	3		; CS:4
	_asmpkt_bufseg		dw	4		; CS:6

asmpkt_entry_:

	pushf

	cli		; no interruptions now

	or	AL, AL
	jnz	encue	; branch if was a 1 and must encue packet now

	; buffer request operation
	; to check our buffers we will need the same DS seg, set it now
        push    CX
	push	DS
        mov     DI, WORD PTR cs:[6]		;CS:bufseg
        mov     DS, DI

	; check the packet length
	cmp	CX, WORD PTR cs:[2]		; maxlen
	jg	no_fnd		; pretend none were found

	
	mov	DI, WORD PTR cs:[4]		;CS:bufs
	mov	CX, WORD PTR cs:[0]		;CS:maxbufs
	mov	AL, 0ffh

srcloop:
	test    AL, byte ptr DS:[DI]
	jz	found
	add	DI, WORD PTR CS:[2] 		;maxlen
	add	DI, 2
	loop	srcloop

no_fnd: xor	DI, DI		; for whatever error, throw away the buffer
	mov	DS, DI		; by returning 0000:0000
	sub	DI, 2

found:  push	DS
	pop	ES
	add	DI, 2
	pop	DS
	pop	CX
	popf
	retf

	; encue packet
	;
encue:	or	SI, SI
	jz	no_enqu		; not a valid pointer, cannot encue
	push	SI
	sub	SI, 2
	mov	AL, 1		; should be already, but just in case
        mov     byte ptr DS:[SI], AL
	pop	SI
no_enqu:popf
	retf
	

; Save end of this code so we can calculate the size
asmpkt_stop_:

_TEXT16 ENDS

END

