unit Win_Dos;
{ FILE: WIN_DOS.PAS

  Purpose: to provide some WinDos emulation for Delphi 1.x

  History:
    first version: 30 November 1998, Dr A Olowofoyeku

}

{$ifndef Ver80}
     !!!! requires Delphi 1.x
{$endif}

interface

{WinDOS TDateTime equivalent}
Type
  TDateTimeRec = packed record
    Year,Month,Day,Hour,Min,Sec,MSec: Word;
  end;

Procedure PackTime(VAR T: TDateTimeRec; VAR Time: Longint);
Procedure UnpackTime(CONST aTime: Longint; VAR DT: TDateTimeRec);
Function  GetEnvVAR(CONST Env:String) : String;
Procedure GetFAttr(VAR f; VAR  l:Word);
Procedure SetFAttr(VAR f; CONST l:Word);
Function  FileExpand(Dest, Name: pChar): pChar;

Const
DosError : Integer = 0;

implementation

Uses Wintypes,Winprocs,Sysutils;

{/////////////////////////////////////////////////////////}
Procedure UnpackTime(CONST aTime: Longint; VAR DT: TDateTimeRec);
VAR
T:TDateTime;
Begin
{$i+}
  Try
    T := FileDatetoDateTime(aTime);
    Try
    With Dt do begin
       DecodeDate(T, Year, Month, Day);
       DecodeTime(T, Hour, Min, Sec, Msec);
    end;
    Except End;
  DosError:=0;
  Except End;
  {$i-}
End;
{/////////////////////////////////////////////////////////}
Procedure PackTime(VAR T: TDateTimeRec; VAR Time: Longint);
VAR
aDate,aTime:TDateTime;
Begin
Try
    With T do begin
      aDate := EncodeDate(Year, Month, Day);
      aTime := EncodeTime(Hour, Min, Sec, Msec);
    end;
   Time:=DateTimeToFileDate(aDate+aTime);
  DosError:=0;
 Except End;
End;
{/////////////////////////////////////////////////////////}
Function GetEnvVAR(CONST Env:String) : String;
VAR
p2 : pChar;
i  : Word;
s  : String;

Begin
    Result := '';
    {$ifdef Win32}
     p2 := GetEnvironmentStrings;
    {$else}
     p2 := GetDOSEnvironment;
    {$endif}
    while p2[0] <> #0 do
    begin
      s := StrPas(p2);
      if (Pos(UpperCase(Env), UpperCase(s)) = 1) then
      begin
        i := Pos('=', s);
        If i=0 then i := pos(#32, s);
        Delete(s,1,i);
        Result := s;
        Exit;
      end;
      while (p2[0] <> #0) do Inc(p2); { goto end of current }
      Inc(p2); { point to next }
    end;
    {$ifdef Win32}
      FreeEnvironmentStrings(p2);
    {$endif}
End;
{/////////////////////////////////////////////////////////}
Procedure GetFAttr;
Begin
  l := FileGetAttr(StrPas(TFileRec(f).Name));
  If l < 0 then DosError := l else DosError:=0;
End;
{/////////////////////////////////////////////////////////}
Procedure SetFAttr;
Begin
  DosError := FileSetAttr(StrPas(TFileRec(f).Name), l);
End;
{/////////////////////////////////////////////////////////}
Function FileExpand(Dest, Name: pChar): pChar;
VAR
s:string;
Begin
   s:=ExpandFileName(Strpas(Name));
   Strpcopy(Dest, s);
   s:=s+#0;
   FileExpand := @s[1];
   DosError:=0;
End;
{/////////////////////////////////////////////////////////}

end.
