Unit W32Types;
{ FILE: W32TYPES.PAS

 Purpose:
 This unit implements some data types/structures for Win32 API programming
 using BPW 7.x and/or Delphi. The main unit of this package (TPW32.PAS)
 uses these data types/structures

 Okay, so the data types contain my own interpretations (and some of
 Christian Ghisler and Claus Ziegler's interpretations) of the C data
 structures used in MS documentation of the Win32 API. These
 interpretations may or may not suit you. They work for me, but your
 mileage may vary.

 History:
 November 15 1995: 1st version by Dr A Olowofoyeku (the African Chief)
}

interface
{$F+}
Uses {$ifndef Ver80}WinDos{$else}Win_Dos, SysUtils{$endif};

{********* Win3232 types ***************}
{some general constants}
Const
Infinite=Longint($FFFFFFFF);
Invalid_Handle_Value=Longint(-1);
Invalid_Handle=Invalid_Handle_Value;

{/////////////////////////////////////////////////////////}
Const
{ drive types }
Drive_Unknown  = 0;
Drive_NotExist = 1;
Drive_Removable= 2;
Drive_Fixed    = 3;
Drive_Remote   = 4;
Drive_CDROM    = 5;
Drive_RamDISK  = 6;

DriveTypes:array[0..6] of pchar=
('Unknown','Invalid','Removeable','Fixed','Network','CDROM','Ram');

{/////////////////////////////////////////////////////////}
{ file types }
Const
File_Type_Unknown = $0000;
File_Type_Disk    = $0001;
File_Type_Char    = $0002;
File_Type_Pipe    = $0003;

{/////////////////////////////////////////////////////////}
{file modes }
Const
Generic_Read      = Longint($80000000);
Generic_Write     = Longint($40000000);
File_Share_Read   = $00000001;
File_Share_Write  = $00000002;

Create_New        = 1;
Create_Always     = 2;
Open_Existing     = 3;
Open_Always       = 4;
Truncate_Existing = 5;

{/////////////////////////////////////////////////////////}
{ file attributes }
Const
File_Attribute_ReadOnly       = $00000001;
File_Attribute_Hidden         = $00000002;
File_Attribute_System         = $00000004;
File_Attribute_Directory      = $00000010;
File_Attribute_Archive        = $00000020;
File_Attribute_Normal         = $00000080;
File_Attribute_Temporary      = $00000100;
File_Attribute_Atomic_Write   = $00000200;
File_Attribute_XAction_Write  = $00000400;

{/////////////////////////////////////////////////////////}
{processes}
Const
  DEBUG_PROCESS           = $000000001;
  DEBUG_ONLY_THIS_PROCESS = $000000002;
  CREATE_SUSPENDED        = $000000004;
  DETACHED_PROCESS        = $000000008;
  CREATE_NEW_CONSOLE      = $000000010;
  NORMAL_PRIORITY_CLASS   = $000000020;
  IDLE_PRIORITY_CLASS     = $000000040;
  HIGH_PRIORITY_CLASS     = $000000080;
  REALTIME_PRIORITY_CLASS = $000000100;
  CREATE_NEW_PROCESS_GROUP= $000000200;
  CREATE_NO_WINDOW        = $008000000;


{/////////////////////////////////////////////////////////}
{file dialogs}
const
  ofn_ReadOnly             = $00000001;
  ofn_OverWritePrompt      = $00000002;
  ofn_HideReadOnly         = $00000004;
  ofn_NoChangeDir          = $00000008;
  ofn_ShowHelp             = $00000010;
  ofn_EnableHook           = $00000020;
  ofn_EnableTemplate       = $00000040;
  ofn_EnableTemplateHandle = $00000080;
  ofn_NoValidate           = $00000100;
  ofn_AllowMultiSelect     = $00000200;
  ofn_ExtentionDifferent   = $00000400;
  ofn_PathMustExist        = $00000800;
  ofn_FileMustExist        = $00001000;
  ofn_CreatePrompt         = $00002000;
  ofn_ShareAware           = $00004000;
  ofn_NoReadOnlyReturn     = $00008000;
  ofn_NoTextFileCreate     = $00010000;
{///////////////////////////////}
{status}
Const
  STATUS_WAIT_0           = $00000000;
  STATUS_ABANDONED_WAIT_0 = $00000080;
  STATUS_USER_APC         = $000000C0;
  STATUS_TIMEOUT          = $00000102;
  STATUS_PENDING          = $00000103;
  STILL_ACTIVE            = STATUS_PENDING;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{general Win32 types}
type
  Handle   = Longint;
  W32Handle= Longint;
  DWORD    = Longint;
  longfile = longint;
  LRESULT  = LONGINT;
  UINT     = Word;
  HKEY     = Handle;
  W32HWnd  = Handle; {Don't want to tamper with Wintypes.HWnd itself}
{/////////////////////////////////////////////////////////}
{beziers}
Type
    Tagpoint=array[0..3] of record
    x,y:longint;
end;
{/////////////////////////////////////////////////////////}
{file finding}
  type
  tFILETIME=
  record
    dwLowDateTime,
    dwHighDateTime:longint;
  end;
  pFILETIME=^tFILETIME;

{WIN32_FIND_DATA structure: for Win32 Findfirst and Findnext functions}
type
  WIN32_FIND_DATA=record
    dwFileAttributes:longint;
    ftCreationTime,
    ftLastAccessTime,
    ftLastWriteTime:tFileTime{array[0..1] of longint};
    nFileSizeHigh,
    nFileSizeLow,
    dwReserved0,
    dwReserved1:longint;
    cFileName:array[0..259] of char;         {long filename}
    cAlternateFileName:array[0..13] of char; {short filename}
  end;
  pWIN32_FIND_DATA=^WIN32_FIND_DATA;

 Type
  tSYSTEMTIME=record
    Year,
    Month,
    DayOfWeek,
    Day,
    Hour,
    Min,
    Sec,
    Milliseconds:word;
  end;
{/////////////////////////////////////////////////////////}
{processes}
Type
  tStartupInfo=record
    cb:longint;
    lpReserved,
    lpDesktop,
    lpTitle:pchar;
    dwX,
    dwY,
    dwXSize,
    dwYSize,
    dwXCountChars,
    dwYCountChars,
    dwFillAttribute,
    dwFlags:longint;
    wShowWindow,
    cbReserved2:word;
    lpReserved2:^byte;
    hStdInput,
    hStdOutput,
    hStdError:longint;
  end;

  Type
  PROCESS_INFORMATION=record
    hProcess,
    hThread,
    dwProcessId,
    dwThreadId:longint;
  end;

{/////////////////////////////////////////////////////////}
{memory}
Type
 MemoryStatus=Record
     dwLength:longint;
     dwMemoryLoad:longint;
     dwTotalPhys:longint;
     dwAvailPhys:longint;
     dwTotalPageFile:longint;
     dwAvailPageFile:longint;
     dwTotalVirtual:longint;
     dwAvailVirtual:longint;
 End;
{/////////////////////////////////////////////////////////}
{Hooks}
Type
T32HookProc=function(Wnd: W32HWnd; Msg, wParam: Longint; lParam: Longint): Longint;

Type
HHook = Longint;
T32EventMsg=Record   {EventMsg record for hook functions}
   Message : Uint;
   ParamL  : Uint;
   ParamH  : Uint;
   Time    : Longint;
End;
{/////////////////////////////////////////////////////////}
{file dialogs; doesn't work!}
Type
T32OpenFilename = record
  lStructSize: Longint;
  hWndOwner: W32HWnd;
  hInstance: Handle;
  lpstrFilter: PChar;
  lpstrCustomFilter: PChar;
  nMaxCustFilter: Longint;
  nFilterIndex: Longint;
  lpstrFile: PChar;
  nMaxFile: Longint;
  lpstrFileTitle: PChar;
  nMaxFileTitle: Longint;
  lpstrInitialDir: PChar;
  lpstrTitle: PChar;
  Flags: Longint;
  nFileOffset: Longint;
  nFileExtension: Longint;
  lpstrDefExt: PChar;
  lCustData: Longint;
  lpfnHook: T32HookProc;
  lpTemplateName: PChar;
end;
{/////////////////////////////////////////////////////////}
{My own SearchRec-like record for 32-bit file functions;
 externally mimics WinDos.Tsearchrec; but has long filename support}
Type
T32SearchRec=Record
    Attr:  Longint;               {the file's attributes}
    Time:  Longint;
    Size:  Longint;
    Name:  array[0..13] of Char;  {the short filename}
    lName: Array[0..259] of char; {the long file name; or copy of short name in Win16}
    lDateTime : {$ifdef Ver80}TDateTimeRec{$else}TDateTime{$endif};
    hHandle   : longint;    {the record's 32-bit handle; don't ever change this!}
    hAttrib   : longint;    {attribute passed to W32findfirst(); don't ever change this!}
    tSs       : TSearchRec; {holds a TSearchRec for 16 bit compatibility}
end;

Type
T32FileProc=Procedure(Var sR:T32SearchRec);
{procedural type for my LocateFiles() function}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{ versioninfo }
Type
  OSVersionInfo = record
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    szCSDVersion: array[0..127] of Char;
  end;

implementation

End.

{November 15 1995, Dr A Olowofoyeku}
