{ **************************************************************** }
{ * Program: prodemo1 - example how easy it is to work with      * }
{ *                     the process unit                         * }
{ *                                                              * }
{ *                                                              * }
{ * Process (c) 1996 by Dieter Pawelczak                         * }
{ *                                                              * }
{ **************************************************************** }
uses process,dutils,crt;

var filename:string;
    ff:text;
    totalbytes,bytesread:longint;
    mainend:boolean;
    pid1,pid2,pid3:integer;

procedure readtask; { This task will read from an ascii textfile }
var i:word;
    key:byte;
    ch:char;
begin
  assign(ff,filename);reset(ff);
  repeat
    read(ff,ch);
    delay(1);inc(bytesread);
    write(ch);
  until  eof(ff);
  close(ff);
  kill_task(pid1);  { End of Task 1 }
end;


procedure percentagetask; { shows percentage of bytes read }
var r1,r2:real;
    i,wper:word;
begin
  cwin2(40,1,77,4,48+15);   { create colour window with attributes 48+15 }
  repeat
    print(50,1,filename);     { print filename }
    r1:=bytesread;
    r2:=100.0;
    if totalbytes<>0 then r2:=r1 / totalbytes * 100;
    wper:=trunc(r2) div 3;
    for i:=0 to wper do print(42+i,2,chr(177)); { print scrollbar }
    print(52,3,twodecs(r2)+'%'); { print percentage }
    delay_task(0);
  until 1=0;                   { endless loop }
end;

procedure keytask;
var key:char;
    color:byte;
begin
  color:=0;
  repeat
    color:=(color+1) mod 14+1;
    cprint(1,25,'Press ESC to exit..',color);
    if keypressed then key:=readkey;
    delay(10);
  until key=#27;
  mainend:=true;
  kill_task(pid3);
end;

begin
  filename:='process.doc';
  if paramstr(1)<>'' then filename:=paramstr(1);
  if not fileexist(filename) then
    begin
      writeLn('File not found:',filename);
      halt(0);
    end;
  totalbytes:=filelength(filename);
  bytesread:=0;
  pid1:=create_process(@readtask,20000,1,'READ');
  pid2:=create_process(@percentagetask,8000,0,'PERCENT');
  pid3:=create_process(@keytask,8000,0,'PERCENT');
  clrscr;
  twin1(1,4,80,24);
  window(2,5,79,23);
  Init_multitasking;
  repeat
    delay_task(6);
  until mainend;
  done_multitasking;
  clear_tasks;
  window(1,1,80,25);
  gotoxy(1,25);
end.

