{**********************************************************************}
{*                                                                    *}
{*     UNIT PROCESS  Version 3.2 Apr/99                               *}
{*                                                                    *}
{*     (c) 1996-1998 by Dieter Pawelczak                              *}
{*                                                                    *}
{**********************************************************************}

{$A+,B-,D+,E+,F-,G-,I-,L+,N+,O-,R-,S-,V+,X+}

unit process;

interface

{ Import }

uses dutils,crt;

var testi:byte;

{****************** Procedure and Function Export *********************}

{* Definition: process = any valid process defined by its pid         *}
{*             task    = running / active process                     *}


function create_process(addr:pointer;stacksize,wait:word;Taskid:string):integer;
  { success: returns PID else errorcode: -1 Stacksize too small }
  {                                      -2 Too less Memory     }
procedure kill_process(pid:word);  { kills a process (pid<>get_current_pid) }
procedure kill_task(pid:word);     { kills the task and forces task switch  }
procedure stop_process(pid:word);  { stops a process }
procedure continue_process(pid:word); { continues a process }
procedure delay_task(counts:word); { delays a task and forces task switch }
procedure Done_Multitasking;       { Stops the int8 handling }
procedure Init_Multitasking;       { Starts the int8 handling }
procedure set_thread_time(typ:word);{sets timer for the task switch }
procedure clear_tasks;             { clears the task kernel, restores pic }
procedure wait_dos;                { if dos is active, forces task switch else disable task switch }
procedure ok_dos;                  { enables task switch after dos command }
procedure task_priority(pid:word;waits:word); { maximum priority for task, delays other task at least for waits}
procedure end_priority(pid:word);  { restores task priorities before task_priority }
procedure task_list;               { lists all tasks and statistics }
procedure set_delay(pid,counts:word); { alters delay time for process }
function EXEC_EXE(FN,PARAM:String;addr:pointer):integer; { loads exe into addr and executes it }
function create_EXE(FN,PARAM:String;addr:pointer;wait:word;Taskid:string):integer;{ loads exe into addr and starts new process}
function run_multitasking:Boolean; { tests, if int8 handler is installed }
function IsNotKilled(pid:word):Boolean; { tests, if process not killed }
function IsKilled(pid:word):Boolean; { tests, if process killed }
function IsNotStopped(pid:word):Boolean; { tests if process not stopped }
function IsStopped(pid:word):Boolean; { tests, if process stopped }
function get_taskid(pid:word):String; { returns task ID string }
function process_exist(pid:word):Boolean; { tests, if process exist }
function get_signal:integer; { gets signal for the current task }
function wait_signal:integer; { waits for a signal for the current task ( task is suspended until signal occurs ) }
function send_signal(pid:word;signal:integer):boolean; { sends a signal to process, returns false if process killed }
procedure clear_signal; { clears a signal of a task }
function read_message:string; { reads a message for a task }
procedure send_message(Message:string); { sends a message to a process }
procedure clear_message; { clears a message of a task }
function stackload(pid:word):real; { This function shows the stack use
                                     of a process while execution in percent }
function get_current_pid:word; { gets the pid of the current task }
function unit_version:word; { returns the version of the unit }
function kernel_version:word; { returns the version of the kernel }

type taskpriorityfunc=procedure(x,y:word); { other programs may need access to this function }

type endpriorityfunc=procedure(x:word); { other programs may need access to this function }

type drivers=record       { used in driver unit }
       name:string[8];
       PSP:Pointer;
       MEM:Pointer;
       RCS,RDS,RSS,RSP,length:Word;
       START:Pointer;
       end;

type driverarray=record   { used in driver unit }
       driver:Array[1..10] of Drivers;
       maxdrivers:Byte;
       end;

type drvptr=^driverarray;

type tasktype=record
     flag:byte;             { flag:  1 = bit 0 = 1      exist     }
     waitinit:word;         {        2 = bit 1 = 1  not killed    }
     waitcount:word;        {        4 = bit 2 = 1  not stopped   }
     tbp,tsp,tss:word;      {        8 = bit 3 = 1      run       }
     calls:word;            { number of calls for statistics      }
     t1d:char;t2d:char;     { Taskid!                             }
     mpd:byte;              { mother process ID                   }
     sgn:integer;           { signal                              }
     dos:Boolean;           { Doing a DOS function                }
     end;
    kernel=record           { kernel accessible from all programs }
    task:array[0..50] of tasktype;
    waitbuffer:array[0..50] of byte;    { used by task_priority   }
    Stackpointers:array[0..50] of pointer;
    Stackptrsize:array[0..50] of word;
    taskcount:byte;
    maxtask:byte;
    mainexit:procedure;                 { exit procedure          }
    message:string;                     { message string          }
    taskpriority:taskpriorityfunc;      { export these functions  }
    endpriority:endpriorityfunc;
    driver:drvptr;                      { export driver           }
    KernelVersion:Word;
    ID:word;                            { identifies Kernel       }
    old8:pointer;
    exitsave:pointer;
    indos: ^boolean;                    { INDOS flag              }
    immediate:Boolean;                  { don't switch task flag = immediate return }
     end;

{ Global Variables }

var  exitsave:pointer;
     breakflag:boolean;
     K:^kernel;
     mpid:byte;
     initmt:boolean;
     old8,old1b:pointer;    { old interrupt vectors }
     mainstack:word;
     switchtimer:integer;   { timer for task switch 0 = 55ms, 2 = 27.5 ms, 3 = 18.3 ms ... }
     switchcount:integer;   { counter for the switch timer }

implementation

{ private types and variables }

var execall:pointer;

type EXEBUFFER=Array[0..32767] of Byte; { buffer to load exe-files }

type ptrtyp=record          { used for the relocation }
     ofs,seg:word;
     end;

type relotab=Array[0..16380] of ptrtyp; { relocation table }
type relotabptr=^relotab;

var errorc:word;  { counter to determine a state of all processes killed }


procedure end_task; { procedure used to kill a task defined as a far procedure }
begin               { will be called by a far task after the end; keyword      }
kill_task(get_current_pid);
end;

function get_taskid(pid:word):String;
begin
  get_taskid:=k^.task[pid].t1d+k^.task[pid].t2d;
end;


procedure kill_process(pid:word);
begin
k^.task[pid].flag:=k^.task[pid].flag and (1+4+8); { set kill flag }
end;


procedure stop_process(pid:word);                 { set stop flag }
begin
k^.task[pid].flag:=k^.task[pid].flag and (1+2+8);
end;


procedure continue_process(pid:word);              { reset stop flag }
begin
k^.task[pid].flag:=k^.task[pid].flag and (1+2+8) or 4;;
end;

procedure kernelerror;
begin
    writeLn('Fatal Error: Kernel Version conflict - Can`t access multitasking kernel!');
    halt(225);
end;

procedure new1b; interrupt;     { New Break Interrupt }
begin
asm
  cli;
end;
if breakflag then
begin
exitproc:=k^.exitsave;
word(ptr(0,8*4)^):=ofs(k^.old8^);       { restore int 8 without DOS call}
word(ptr(0,8*4+2)^):=seg(k^.old8^);
writeLn('Process[',get_current_pid,']: USERBREAK');
if shiftpressed then task_list;
word(ptr(0,$7e*4)^):=0;                 { destroy kernel id }
word(ptr(0,$7e*4+2)^):=0;
asm
      mov dx,43h
      mov al,00110110b
      out dx,al
      mov al,0ffh
      mov dx,40h
      out dx,al
      mov al,0ffh
      out dx,al  { restore PIC }
      mov al,20h
      out 20h,al                    { in case of HW int: send EOI }
end;
halt(3);
end;
asm sti;end;
end;



procedure delay_task(counts:word);      { forces a task switch and delays the current task }
var dax,dbx,dcx,ddx,ddi,dsi,des,dds,dobp,dbp,dsp,dss:word;
begin
asm
  cli
  mov dax,ax                            { save all registers on stack }
  mov dbx,bx
  mov dcx,cx
  mov ddx,dx
  mov ddi,di
  mov dsi,si
  mov ax,es
  mov des,ax
  mov ax,ds
  mov dds,ax
  mov ax,sp
  mov dsp,ax
  mov ax,ss
  mov dss,ax
  mov ax,[bp]
  mov dobp,ax
  mov dbp,bp
(*  FSAVE SS:[8]                        { TO ENABLE FPU SUPPORT  } *)
end;
with k^.task[k^.taskcount] do           { if task doesn't exist, task is created now }
  begin
   tsp:=dsp;                            { store the task's stack }
   tss:=dss;
   tbp:=dbp;
   flag:=flag and (2+4) or 1;           { exit is true, run is false }
   waitcount:=counts;
   if counts=0 then waitcount:=waitinit;{ delay_task(0)              }
  end;
  errorc:=0;
repeat                                  { find new task, which exits, if not killed, }
  asm cli;end;                          { not stopped and is allowed to run by its priority }
  inc(k^.taskcount);if k^.taskcount>k^.maxtask then k^.taskcount:=0;
  if k^.task[k^.taskcount].dos then if not k^.indos^ then k^.task[k^.taskcount].waitcount:=0;
  inc(errorc);if errorc>300 then begin writeLn('TASK OVERFLOW ERROR');halt(224);end;
  if k^.task[k^.taskcount].waitcount<>0 then dec(k^.task[k^.taskcount].waitcount);
  until (k^.task[k^.taskcount].flag and 7=7) and (k^.task[k^.taskcount].waitcount=0) and (not k^.indos^ or
     (k^.indos^ and not k^.task[k^.taskcount].dos));
with k^.task[k^.taskcount] do           { OK, new task found }
  begin
   dbp:=tbp;                            { store new stack }
   dss:=tss;
   dsp:=tsp;
   dos:=false;
   flag:=flag or 1 or 8; { exit is true, run is true }
   inc(calls);
  end;
asm
  mov ax,dss                            { load new stack }
  mov bx,dbp
  mov cx,dsp
  mov ss,ax
  mov sp,cx
  mov bp,bx
  mov ax,dds                            { load stored registers from stack }
  mov ds,ax
  mov ax,des
  mov es,ax
  mov di,ddi
  mov si,dsi
  mov dx,ddx
  mov cx,dcx
  mov bx,dbx
  mov ax,dax
(*  FRSTOR SS:[8]                        { TO ENABLE FPU SUPPORT  } *)
  sti                                   { continue new task }
end;
end;



procedure transfer;            { new interrupt 8 }
var dax,dbx,dcx,ddx,ddi,dsi,des,dds,dobp,dbp,dsp,dss:word;
label ende;
begin
asm
  cli
  mov dax,ax                            { save all registers on stack }
  mov dbx,bx
  mov dcx,cx
  mov ddx,dx
  mov ddi,di
  mov dsi,si
  mov ax,es
  mov des,ax
  mov ax,ds
  mov dds,ax
  mov ax,sp
  mov dsp,ax
  mov ax,ss
  mov dss,ax
  mov ax,[bp]
  mov dobp,ax
  mov ax,0000                           { Value of DSEG will be initialized in the main procedure}
  mov ds,ax
  mov es,ax
  mov dbp,bp
  mov al,0bh
  out 0a0h,al                           { check HW-IRQs }
  out 20h,al
  jmp @next
@next:
  nop
  nop
  in al,20h
  mov testi,al
  cmp al,1
  je @next2
@next3:
  jmp ende
@next2:
  in al,0a0h
  cmp al,0
  jne @next3
end;
with k^.task[k^.taskcount] do           { if task doesn't exit, create task now }
  begin
   tsp:=dsp;
   tss:=dss;
   tbp:=dbp;
   flag:=flag and (2+4) or 1; { exit is true, run is false }
   waitcount:=waitinit;
  end;
errorc:=0;
if not  k^.immediate  then { if immediate flag is set, don't alter the task an return to the old task }
repeat                     { else find a new task, which is allowed to run }
inc(k^.taskcount);if k^.taskcount>k^.maxtask then k^.taskcount:=0;
if (k^.task[k^.taskcount].waitcount<>0) and (k^.task[k^.taskcount].flag>=7) then dec(k^.task[k^.taskcount].waitcount);
inc(errorc);if errorc>300 then begin writeLn('TASK OVERFLOW ERROR');halt(224);end;
until (k^.task[k^.taskcount].flag and 7=7)
        and (k^.task[k^.taskcount].waitcount=0)
        and (not k^.indos^ or  (k^.indos^ and not k^.task[k^.taskcount].dos));
with k^.task[k^.taskcount] do  { new task found }
  begin
   dbp:=tbp;                   { store stack for new task }
   dss:=tss;
   dsp:=tsp;
   flag:=flag or 1 or 8;
   dos:=false;
   inc(calls);
  end;
k^.immediate:=false;           { reset immediate flag }
Ende:
dec(switchcount);              { check if old int8 should be called ... }
if switchcount<=0 then
  begin
  switchcount:=switchtimer;
  INLINE($9C/                     { PUSHF                ; save Flags    }
         $FF/$1E/old8);           { CALL FAR [Timer_Alt] ; call int 8    }
  end else
  begin
    asm
      mov al,32
      out 32,al                 { if old int8 is not called send EOI itself }
    end;
  end;
asm
  mov ax,dss                    { load new stack }
  mov bx,dbp
  mov cx,dsp
  mov ss,ax
  mov sp,cx
  mov bp,bx
  mov ax,dds                    { load all registers }
  mov ds,ax
  mov ax,des
  mov es,ax
  mov di,ddi
  mov si,dsi
  mov dx,ddx
  mov cx,dcx
  mov bx,dbx
  mov ax,dax
  mov sp,bp
  pop bp
(*  FRSTOR SS:[8]                        { TO ENABLE FPU SUPPORT  } *)
  sti
  iret                         { return to new task }
end;
end;



procedure kill_task(pid:word);
{ kill_task kills a process and forces a task switch                           }
{ with kill_task, a task can kill itself:                                      }
{ With the kill flag set, the task is never called again after the task switch }
var dax,dbx,dcx,ddx,ddi,dsi,des,dds,dobp,dbp,dsp,dss,einsprofs,einsprseg:word;
begin
asm
  cli
  mov dax,ax
  mov dbx,bx
  mov dcx,cx
  mov ddx,dx
  mov ddi,di
  mov dsi,si
  mov ax,es
  mov des,ax
  mov ax,ds
  mov dds,ax
  mov ax,sp
  mov dsp,ax
  mov ax,ss
  mov dss,ax
  mov ax,[bp]
  mov dobp,ax
  mov dbp,bp
(*  FSAVE SS:[8]                        { TO ENABLE FPU SUPPORT  } *)
end;
with k^.task[pid] do
  begin
   flag:=1;  { run false,killed true, exist true}
  end;
errorc:=0;
repeat
inc(k^.taskcount);if k^.taskcount>k^.maxtask then k^.taskcount:=0;
if k^.task[k^.taskcount].waitcount<>0 then dec(k^.task[k^.taskcount].waitcount);
inc(errorc);if errorc>300 then begin writeLn('TASK OVERFLOW ERROR');halt(224);end;
until (k^.task[k^.taskcount].flag and 7=7)  and (k^.task[k^.taskcount].waitcount=0) and (not k^.indos^ or
  (k^.indos^ and not k^.task[k^.taskcount].dos));
with k^.task[k^.taskcount] do
  begin
   dbp:=tbp;
   dss:=tss;
   dsp:=tsp;
   dos:=false;
   flag:=flag or 1 or 8;
   inc(calls);
  end;
asm
  mov ax,dss
  mov bx,dbp
  mov cx,dsp
  mov ss,ax
  mov sp,cx
  mov bp,bx
  mov ax,dds
  mov ds,ax
  mov ax,des
  mov es,ax
  mov di,ddi
  mov si,dsi
  mov dx,ddx
  mov cx,dcx
  mov bx,dbx
  mov ax,dax
  sti
(*  FRSTOR SS:[8]                        { TO ENABLE FPU SUPPORT  } *)
end;
end;

function EXEC_EXE(FN,PARAM:String;addr:pointer):integer;
{ function to load and execute an .EXE file             }
{ warning: Don't execute programs which don't come from }
{          you! DOS is not emulated, therefore these    }
{          programs can only use restricted system      }
{          resources (See the .DOC file)                }
var ff:file;
  pseg,pofs:word;
  P:Array[0..40] of ^EXEBuffer;
  ReTab:Relotabptr;
  test:word;
  Buf:Array[0..13] of Word;
  Elemente:word;
  startss:word;
  startsp:word;
  realcs:word;
  realds:word;
  reales:word;
  startip:word;
  startcsrel:word;
  startelemente:word;
  Numread:word;
  gesamt:longint;
  startp:^pointer;
  laenge:longint;
  i:word;
  realss:word;
  ds:file;
begin
if not fileexist(FN) then EXEC_EXE:=-1
else
begin
pseg:=seg(addr^);
pofs:=ofs(addr^);
{ initialize memory blocks for the .EXE Program: }
{ First Block: 256 Bytes PSP, Rest = 39*8K Blocks = 312 KBytes}
if pofs<>0 then begin pseg:=pseg+(pofs+15)div 16;pofs:=0;end;
p[0]:=ptr(pseg,pofs); { PSP }
p[1]:=ptr(pseg+16,pofs);
for i:=1 to 39 do p[i+1]:=ptr(pseg+16+i*512,pofs);
{ Pointer located to program memory }
wait_dos;
assign(ff,fn);reset(ff,1);
assign(ds,'TEMP.TMP');rewrite(ds,1);
Blockread(FF,Buf,SizeOf(Buf),Numread);
{ Load EXE-HEADER in Buf }
  Elemente:=Buf[3];
  startss:=Buf[7];
  startsp:=Buf[8];
  startip:=Buf[10];
  startcsrel:=Buf[11];
  startelemente:=buf[12];
ok_dos;
for i:=0 to 255 do p[0]^[i]:=0;
{ INIT PSP }
p[0]^[0]:=$CD;p[0]^[1]:=$20;p[0]^[3]:=$A0;p[0]^[2]:=$00;p[0]^[$32]:=$00;
p[0]^[$33]:=$14;p[0]^[$18]:=1;p[0]^[$19]:=1;p[0]^[$20]:=1;p[0]^[$21]:=0;
p[0]^[$34]:=lo(seg(p[0]));p[0]^[$35]:=hi(seg(p[0]));
p[0]^[$36]:=lo(ofs(p[0])+$18);p[0]^[$37]:=hi(ofs(p[0])+$18);
for i:=$22 to $2B do p[0]^[i]:=$FF;
p[0]^[$2c]:=$a0;p[0]^[$2d]:=$00;
{ Copy Parameter line }
p[0]^[$80]:=length(param);
param:=param+chr(13);
for i:=1 to length(param) do p[0]^[i+$80]:=ord(param[i]);
gesamt:=0;
task_priority(get_current_pid,3);
{ calculate size of relocation table }
getmem(retab,(longint(buf[4])*16-28));  { getmem = non reentrant pascal function }
end_priority(get_current_pid);
wait_dos;
{ load relocation table }
if startelemente>28 then Blockread(ff,retab^,startelemente-28);
Blockread(FF,retab^,buf[4]*16-startelemente,Numread);
ok_dos;
Numread:=8192;i:=1;
laenge:=Buf[1]+Buf[2]*512; { EXE length from EXE-HEADER }
while (Numread=8192) and (gesamt<laenge)do { load EXE program into memory }
begin
wait_dos;
   Blockread(FF,p[i]^,8192,Numread);
   Blockwrite(ds,p[i]^,Numread);
   test:=ioresult;
ok_dos;
   gesamt:=gesamt+Numread;
   inc(i);
end;
wait_dos;
close(ff);
ok_dos;
{ Calculate the program vectors: CS,DS,ES,SS }
realcs:=seg(p[1]^)+startcsrel;
realds:=seg(p[1]^)-16;
reales:=seg(p[1]^)-16;
realss:=seg(p[1]^)+Startss;
{ Relocation }
if elemente<>0 then for i:=0 to elemente-1 do
  begin
  word(ptr(retab^[i].seg+realcs,retab^[i].ofs)^):=
    word(ptr(retab^[i].seg+realcs,retab^[i].ofs)^)+realcs;
  end;
task_priority(get_current_pid,3);
freemem(retab,(buf[4]*16-28) div 4); { Free relocation table }
end_priority(get_current_pid);
startp:=ptr(Realds,$FA);             { setup start vector into program PSP }
startp^:=ptr(realcs,startip);

asm
  mov di,ds
  mov si,ss
  mov ds,realds
  mov es,reales
  mov ax,realss
  mov bx,startsp
  mov cx,sp
  mov sp,bx
  mov ss,ax
  push si
  push cx
  push di
  push bp
  mov di,0
  mov si,0
  mov ax,0
  mov cx,0
  mov dx,0
  end;

  INLINE($FF/$1E/$FA/$00);      { CALL FAR  EXE PROGRAM }
  { note, as DS already points to the program, the start vector must be part }
  { of the program, therefore the start vector is stored in the program PSP at $FA }
  asm
  pop bp { an .EXE program never returns, but a user program could return... }
  pop ds
  pop bx
  pop si
  mov ss,si
  mov sp,bx
  end;
end;
end;

function create_EXE(FN,PARAM:String;addr:pointer;wait:word;Taskid:string):integer;
{ function to install an .EXE file as a new process     }
{ warning: Don't execute programs which don't come from }
{          you! DOS is not emulated, therefore these    }
{          programs can only use restricted system      }
{          resources (See the .DOC file)                }
var taskcount,pseg,pofs:word;
var ff:file;
  P:Array[0..20] of ^EXEBuffer;
  ReTab:Relotabptr;
  Buf:Array[0..13] of Word;
  Elemente:word;
  startss:word;
  startsp:word;
  realcs:word;
  realds:word;
  reales:word;
  startip:word;
  startcsrel:word;
  startelemente:word;
  Numread:word;
  gesamt,laenge:longint;
  i:word;
  realss:word;
begin
if (k^.id<>27315) or (kernel_version<>unit_version) then kernelerror;
if not fileexist(FN) then create_EXE:=-1
else
begin
pseg:=seg(addr^);
pofs:=ofs(addr^);
asm cli;end;
{ Create Program Memory: 256 Bytes PSP, 32K Program blocks }
if pofs<>0 then begin pseg:=pseg+(pofs+15)div 16;pofs:=0;end;
p[0]:=ptr(pseg,pofs);
p[1]:=ptr(pseg+16,pofs);
for i:=1 to 19 do p[i+1]:=ptr(pseg+16+i*2048,pofs);
{ Ok,all Pointer located to program memory }
wait_dos;
assign(ff,fn);reset(ff,1);
{ Load EXE-HEAD in Buf }
Blockread(FF,Buf,SizeOf(Buf),Numread);
ok_dos;
  Elemente:=Buf[3];
  startss:=Buf[7];
  startsp:=Buf[8];
  startip:=Buf[10];
  startcsrel:=Buf[11];
  startelemente:=buf[12];
{ INIT PSP }
for i:=0 to 255 do p[0]^[i]:=0;
p[0]^[0]:=$CD;p[0]^[1]:=$20;p[0]^[3]:=$A0;p[0]^[2]:=$00;p[0]^[$32]:=$00;
p[0]^[$33]:=$14;p[0]^[$18]:=1;p[0]^[$19]:=1;p[0]^[$20]:=1;p[0]^[$21]:=0;
p[0]^[$34]:=lo(seg(p[0]));p[0]^[$35]:=hi(seg(p[0]));
p[0]^[$36]:=lo(ofs(p[0])+$18);p[0]^[$37]:=hi(ofs(p[0])+$18);
p[0]^[$2c]:=$a0;p[0]^[$2d]:=$00;
for i:=$22 to $2B do p[0]^[i]:=$FF;
{ Copy Parameter Line }
p[0]^[$80]:=length(param);
param:=param+chr(13);
for i:=1 to length(param) do p[0]^[i+$80]:=ord(param[i]);
gesamt:=0;
task_priority(get_current_pid,3);
getmem(retab,(buf[4]*16-28) div 4);
end_priority(get_current_pid);
wait_dos;
if startelemente>28 then Blockread(ff,retab^,startelemente-28);
   Blockread(FF,retab^,buf[4]*16-startelemente,Numread);
ok_dos;
Numread:=32768;i:=1;
laenge:=Buf[1]+Buf[2]*512; { Program length from the .EXE Header }
while (Numread=32768) and (gesamt<laenge)do { load the complete program }
begin
  wait_dos;
  Blockread(FF,p[i]^,32768,Numread);
  ok_dos;
  gesamt:=gesamt+Numread;
  inc(i);
end;
wait_dos;
close(ff);
ok_dos;
{ Calculate the program start vectors CS,DS,ES,SS }
realcs:=seg(p[1]^)+startcsrel;
realds:=seg(p[1]^)-16;
reales:=seg(p[1]^)-16;
realss:=seg(p[1]^)+Startss;
{ Relocation }
for i:=0 to elemente-1 do
  begin
  word(ptr(retab^[i].seg+realcs,retab^[i].ofs)^):=
    word(ptr(retab^[i].seg+realcs,retab^[i].ofs)^)+realcs;
  end;
task_priority(get_current_pid,3);
freemem(retab,(buf[4]*16-28) div 4);
end_priority(get_current_pid);
{ Create New task }
{ If last task is killed, and the task had been created by this unit, }
{ this unit is able to free the task                                  }
if (k^.task[k^.maxtask-1].flag and 2=0) and (k^.task[k^.maxtask-1].mpd=mpid) then
  begin
  if k^.stackpointers[k^.maxtask-1]<>NIL then
  begin
  task_priority(get_current_pid,3);
    freemem(k^.stackpointers[k^.maxtask-1],k^.stackptrsize[k^.maxtask-1]);
    k^.stackptrsize[k^.maxtask-1]:=0;
    k^.task[k^.maxtask-1].flag:=0; { exit false, killed true, stopped true }
    dec(k^.maxtask);
  end_priority(get_current_pid);
  end;
  end;

{ Enter new task in kernel }
taskcount:=k^.maxtask;
while k^.task[k^.maxtask].flag>=1 do
  begin
    inc(k^.maxtask);
    inc(taskcount);
  end;
  k^.stackptrsize[taskcount]:=startsp;
  k^.stackpointers[taskcount]:=NIL;
with k^.task[taskcount] do
begin
   { Ok, set properties for the new task }
   calls:=0;
   tbp:=startsp-12;      { Stacktop - 12 as Basepointer }
   tsp:=tbp-$20;
   tss:=realss;
   t1d:=taskid[1];
   t2d:=taskid[2];
   mpd:=Mpid;
   word(ptr(tss,tbp-2)^):=0; { register values }
   word(ptr(tss,tbp-4)^):=0;
   word(ptr(tss,tbp-6)^):=0;
   word(ptr(tss,tbp-8)^):=0;
   word(ptr(tss,tbp-$A)^):=0;
   word(ptr(tss,tbp-$C)^):=0;
   word(ptr(tss,tbp-$E)^):=REALES;
   word(ptr(tss,tbp-$10)^):=REALDS;
   word(ptr(tss,tbp-$12)^):=0;
   word(ptr(tss,tbp-$14)^):=tbp;
   word(ptr(tss,tbp-$16)^):=tsp;
   word(ptr(tss,tbp+$2)^):=startip;
   word(ptr(tss,tbp+$4)^):=realcs;
   word(ptr(tss,tbp+$8)^):=ofs(end_Task);
   word(ptr(tss,tbp+$0A)^):=seg(end_Task);
   word(ptr(tss,tbp)^):=0;
(* asm
     mov ax,tss
     mov es,ax
     FSAVE es:[8]                        { TO ENABLE FPU SUPPORT  }
   end;  *)
   { enable task: }
   flag:=7;  {not killed , not stopped, exist but no run }
   waitcount:=wait;waitinit:=wait;
   { return pid }
   create_exe:=taskcount;
end;
asm sti;end;
end;
end;


function get_signal:integer;
begin
{ if another process has already killed the task, the signal -1 is returned! }
if k^.task[k^.taskcount].flag and 2=0 then get_signal:=-1 else
get_signal:=k^.task[k^.taskcount].sgn;
end;

function wait_signal:integer;
begin
{ if another process has already killed the task, the task never returns! }
while (k^.task[k^.taskcount].sgn=0) do delay_task(0);
wait_signal:=k^.task[k^.taskcount].sgn;
end;

procedure clear_signal;
begin
asm cli;end;
k^.task[k^.taskcount].sgn:=0;
asm sti;end;
end;

function send_signal(pid:word;signal:integer):boolean;
begin
{ if other process is killed or doesn't exist function returns false }
if (k^.task[pid].flag and 3<>3)  then send_signal:=false
 else begin k^.task[pid].sgn:=signal;send_signal:=true; end;
end;

function IsNotKilled(pid:word):Boolean;
begin
IsNotKilled:=k^.task[pid].flag and 2=2;
end;

function IsKilled(pid:word):Boolean;
begin
IsKilled:=k^.task[pid].flag and 2=0;
end;

function IsNotStopped(pid:word):Boolean;
begin
IsNotstopped:=not k^.task[pid].flag and 4=4;
end;

function IsStopped(pid:word):Boolean;
begin
IsStopped:=k^.task[pid].flag and 4=0;
end;

function process_exist(pid:word):Boolean;
begin
process_exist:=(k^.task[pid].flag and 1=1) and (k^.task[pid].flag and 2=2);
end;

procedure set_delay(pid,counts:word);
begin
k^.task[pid].waitinit:=counts;
k^.task[pid].waitcount:=counts;
end;

function get_current_pid:word;
begin
get_current_pid:=k^.taskcount;
end;

procedure clear_message;
begin
k^.message:='';
end;

procedure send_message(Message:string);
begin
k^.message:=message;
end;
function read_message:string;
begin
read_message:=k^.message;
end;


procedure task_priority(pid,waits:word);
var i:word;
begin
asm cli; end;
for i:=0 to k^.maxtask do
  begin
asm cli; end; { store all other process priorities in a buffer }
  k^.waitbuffer[i]:=k^.task[i].waitcount;
  if i<>pid then k^.task[i].waitcount:=waits;
              { set all other process priorities to waits }
  end;
asm sti; end;
end;

procedure end_priority(pid:word);
var i:word;
begin
for i:=0 to k^.maxtask do
  begin  { restore all priorities from the buffer }
    k^.task[i].waitcount:=k^.waitbuffer[i];
  end;
end;


function create_process(addr:pointer;stacksize,wait:word;Taskid:string):integer;
var taskcount:word;
    stackseg,stackofs:word;
begin
{ check if kernel correct, destroyed, etc }
if (k^.id<>27315) or (kernel_version<>unit_version) then kernelerror;
asm cli;end;
if maxavail<stacksize then create_process:=-2 else { Memory error }
if k^.maxtask>50 then  create_process:=-3 else     { Too many tasks error }
if stacksize>=2048 then                            { minimum stack size for transfer }
begin
{ check, if any killed task can be disposed }
for taskcount:=0 to k^.maxtask do if (k^.task[taskcount].flag and 2=0) and ((k^.task[taskcount].mpd=mpid) or
  (k^.stackpointers[taskcount]=NIL)) or (k^.task[taskcount].flag and 1=0) then
  begin
  if k^.stackpointers[taskcount]<>NIL then
  begin
    task_priority(get_current_pid,3);
      freemem(k^.stackpointers[taskcount],k^.stackptrsize[taskcount]);
      { FREEMEM = NON REENTRANT PASCAL PROCEDURE! }
    end_priority(get_current_pid);
    k^.stackptrsize[taskcount]:=0;
    k^.task[taskcount].flag:=0;   { exit false, killed true}
  end;
  end;

for taskcount:=k^.maxtask downto 0 do if k^.task[taskcount].flag and 1=1 then
  begin k^.maxtask:=taskcount+1;taskcount:=0;end;

if k^.maxtask>0 then if (k^.task[k^.maxtask].flag and 2=0) and ((k^.task[k^.maxtask].mpd=mpid) or
  (k^.stackpointers[k^.maxtask]=NIL)) or (k^.task[k^.maxtask].flag and 1=0) then
  begin
  if k^.stackpointers[k^.maxtask]<>NIL then
  begin
    task_priority(get_current_pid,3);
      freemem(k^.stackpointers[k^.maxtask],k^.stackptrsize[k^.maxtask]);
      { FREEMEM = NON REENTRANT PASCAL PROCEDURE! }
    k^.stackptrsize[k^.maxtask]:=0;
    k^.task[k^.maxtask].flag:=0; { task now doosn't exist any more ! }
    dec(k^.maxtask);
    end_priority(get_current_pid);
  end;
  end;

{ repeat until any non exiting process is found }
taskcount:=0;
while k^.task[taskcount].flag and 1=1 do
  begin
    inc(taskcount);
  end;
if taskcount>k^.maxtask then inc(k^.maxtask);
{ OK, task found }
  k^.stackptrsize[taskcount]:=stacksize;
task_priority(get_current_pid,3);
  getmem(k^.stackpointers[taskcount],k^.stackptrsize[taskcount]) ; { Get Stack }
end_priority(get_current_pid);

stackseg:=seg(k^.stackpointers[taskcount]^);
stackofs:=ofs(k^.stackpointers[taskcount]^);
with k^.task[taskcount] do
begin
  { set process properties }
   calls:=0;
   tbp:=stackofs+stacksize-12;      { Stacktop - 12 as Basepointer }
   tsp:=tbp-$20;
   tss:=stackseg;
   dos:=false;
   t1d:=taskid[1];
   t2d:=taskid[2];
   mpd:=Mpid;
   word(ptr(tss,tbp-2)^):=0; { Register values }
   word(ptr(tss,tbp-4)^):=0;
   word(ptr(tss,tbp-6)^):=0;
   word(ptr(tss,tbp-8)^):=0;
   word(ptr(tss,tbp-$A)^):=0;
   word(ptr(tss,tbp-$C)^):=0;
   word(ptr(tss,tbp-$E)^):=DSEG;
   word(ptr(tss,tbp-$10)^):=DSEG;
   word(ptr(tss,tbp-$12)^):=0;
   word(ptr(tss,tbp-$14)^):=tbp;
   word(ptr(tss,tbp-$16)^):=tsp;
   word(ptr(tss,tbp+$2)^):=ofs(addr^);
   word(ptr(tss,tbp+$4)^):=seg(addr^);
   word(ptr(tss,tbp+$6)^):=0;
   word(ptr(tss,tbp+$8)^):=ofs(end_Task); { address to jump at after finishing the task }
   word(ptr(tss,tbp+$0A)^):=seg(end_Task);
   word(ptr(tss,tbp)^):=0;
   flag:=7; { task now exists, is not killed, not stopped }
   waitcount:=wait;waitinit:=wait; { initialize priorities }
(* asm
    mov ax,stackseg
    mov es,ax
    FSAVE es:[8]                        { TO ENABLE FPU SUPPORT  }
  end;  *)
end;
create_process:=taskcount;
end
else
create_process:=-1; { Stacksize Too small }
asm sti;end;
end;

procedure  task_list;
var i:Byte;
   s:string[8];
   ss:string[66];
begin
    ss:='==============================================================';
    writeln(ss);
    writeln('TASK LIST                                                     ');
    writeLn('PID MPID STATUS     WAITSTATE STACKSIZE STACKUSE CALLS DOS ID ');
    writeln(ss);
    for i:=0 to k^.maxtask do
    begin
    asm cli; end;
      begin
        write(i:3,' ');
        write(k^.task[i].mpd:3,'  ');
        if k^.task[i].flag and 2=0 then write('KILLED   ')
        else
        if k^.task[i].flag and 8=8 then write('RUN      ')
        else
        if k^.task[i].flag and 4=0 then write('STOPPED  ')
        else
        write('WAIT     ');
        write(k^.task[i].waitcount:4,':',k^.task[i].waitinit:4,'   ');
        if k^.stackptrsize[i]<>0 then write(k^.stackptrsize[i]:5,'   ')
           else  if k^.task[i].flag and 2=2 then  write(' MAIN   ')
                                          else  write(' ----   ');
        s:=twodecs(stackload(i));
        write('   ',copy(s+'    ',1,6),'%');
        write(k^.task[i].calls:5,'   ');
        if k^.task[i].dos then write('X  ') else write('.  ');
        if (k^.stackptrsize[i]<>0) or (k^.task[i].flag and 2=0) then
           write(k^.task[i].t1d+k^.task[i].t2d,'    ') else
           write('MP    ');
        writeln;
    end;
    end;
        writeln(ss);
    asm sti; end;
end;

function stackload(pid:word):real; { This function shows the stack use
                                     of a process while execution in percent }
var s1,s2:real;
begin
s1:=(k^.stackptrsize[pid]-k^.task[pid].tsp);      { Real size - used size }
if k^.stackptrsize[pid]=0 then
stackload:=s1/mainstack
else
stackload:=s1/(k^.stackptrsize[pid])*100;
end;


procedure newexit;
var i:Byte;
begin
asm cli;end;
exitproc:=k^.exitsave;
asm
      mov dx,43h
      mov al,00110110b
      out dx,al
      mov al,0ffh
      mov dx,40h
      out dx,al
      mov al,0ffh
      out dx,al  { restore PIC }
end;
word(ptr(0,8*4)^):=ofs(k^.old8^); { setintvec without DOS call }
word(ptr(0,8*4+2)^):=seg(k^.old8^); { restore int8  }
writeln('finished multitasking.');
word(ptr(0,$7e*4)^):=0;
word(ptr(0,$7e*4+2)^):=0;
write('Exit [',k^.taskcount:2,'] Process ');
if exitcode=224 then erroraddr:=@kill_task;
if exitcode<>0 then
  begin
    write('Errorcode: ',Exitcode);writeln(' ErrorAddr: '+hexs(seg(ErrorAddr^))+':'+hexs(ofs(erroraddr^)));
    task_list;
  end;
writeLn;
halt(0);
end;


procedure Init_Multitasking;
{ Initialize the new int8 handler }
var indosseg,indosofs:word;
begin
port[$20]:=$20;
port[$A0]:=$20;
asm cli;end;
if (k^.id<>27315) or (kernel_version<>unit_version) then
  begin
   kernelerror;
  end;
if not run_multitasking then
  begin
  exitproc:=@Newexit;
  asm mov ah,$34
      int 21h
      mov indosseg,es
      mov indosofs,bx
  end;
  { set up the indos flag }
  k^.indos:=ptr(indosseg,indosofs);
  { set up the exit procedure }
  @k^.mainexit:=@Newexit;
  { set up the number of tasks }
  k^.taskcount:=k^.maxtask;
  if k^.task[k^.taskcount].flag and 1=1 then
  begin inc(k^.taskcount);inc(k^.maxtask);end;
  k^.task[k^.taskcount].flag:=14; { running, not stopped, not killed, existing }
  initmt:=true; { This unit has initialized multitasking! }
  asm cli;end;
  word(ptr(0,8*4)^):=ofs(transfer); { setintvec without DOS call }
  word(ptr(0,8*4+2)^):=seg(transfer); { set proc transfer as new int 8 handler }
  end;
asm sti;end;
end;

procedure Done_Multitasking;
var i:byte;
begin
asm cli;end;
{ check, if this unit has the rights to stop the multitasking process }
if initmt and run_multitasking then
begin
  word(ptr(0,8*4)^):=ofs(old8^); { setintvec without DOS call }
  word(ptr(0,8*4+2)^):=seg(old8^); { restore int8  }
  k^.indos:=NIL;
  asm
      mov dx,43h
      mov al,00110110b
      out dx,al
      mov al,0ffh
      mov dx,40h
      out dx,al
      mov al,0ffh
      out dx,al  { restore PIC }
  end;
end;
asm sti;end;
exitproc:=exitsave;
end;

procedure clear_tasks;
var i:word;
begin
for i:=k^.maxtask downto 0 do
  { check, which tasks can be disposed by this unit }
 if (k^.task[i].mpd=mpid) then
    begin
  if (k^.stackpointers[i]<>NIL) then  freemem(k^.stackpointers[i],k^.stackptrsize[i]);
        k^.task[i].flag:=0;
        k^.task[i].mpd:=0;
        k^.task[i].waitinit:=0;
        k^.task[i].waitcount:=0;
        k^.task[i].sgn:=0;
        k^.stackpointers[i]:=NIL;
    end;
  { correct the maxtask variable }
while (k^.task[k^.maxtask].mpd=mpid) do dec (k^.maxtask);
  { check, if this unit is run by the mother process of all other processes }
if mpid=1 then
  begin
    { OK, This unit is the origin of the multitasking kernel ... }
    k^.id:=0; { destroy kernel }
    asm
      mov dx,43h
      mov al,00110110b
      out dx,al
      mov al,0ffh
      mov dx,40h
      out dx,al
      mov al,0ffh
      out dx,al  { for safety: restore PIC }
    end;
  end;

end;


function run_multitasking:Boolean;
var p:pointer;
    check:boolean;
begin
check:=true;
p:=ptr(word(ptr(0,8*4+2)^),word(ptr(0,8*4)^)); { Getintvec without DOS call }
{ check some process unit IDs... }
if word(ptr(seg(p^),ofs(p^)+4)^)<>$1cEC then check:=false;
if word(ptr(seg(p^),ofs(p^)+6)^)<>$89fa then check:=false;
if word(ptr(seg(p^),ofs(p^)+11)^)<>$fc5e then check:=false;
run_multitasking:=check;
end;

procedure Init_tasks;
var i:word;
begin
with k^ do
begin
{ This function can only be executed by the mother process and the 'mother' unit }
maxtask:=0;
taskcount:=0;
message:='';
id:=27315;
driver:=NIL;
for i:=0 to 50 do
  begin
    stackpointers[i]:=NIL;
    stackptrsize[i]:=0;
    task[i].t1d:='X';
    task[i].t2d:='X';
    task[i].flag:=0;  { start in continue modus not killed}
    task[i].waitinit:=0;
    task[i].waitcount:=0;
    task[i].calls:=0;
    task[i].mpd:=0;
    task[i].sgn:=0;
    task[i].dos:=false;
    waitbuffer[i]:=0;
    end;
    immediate:=false;
    @taskpriority:=@task_priority;
    @endpriority:=@end_priority;
    kernelversion:=unit_version;
    indos:=NIL;
  end;
end;

procedure wait_dos;
begin
asm cli end;
if k^.indos<>NIL THEN if  k^.indos^ then
  begin k^.task[k^.taskcount].dos:=true;asm sti end;
        delay_task(0);asm cli end;
 end;
k^.immediate:=true;
asm sti end;
end;

procedure ok_dos;
begin
k^.immediate:=false;
end;

function unit_version:word;
begin
unit_version:=3+0;           { same kernel as in V3.0 }
end;

function kernel_version:word;
begin
kernel_version:=k^.kernelversion; { same kernel as in V3.0 }
end;

procedure set_thread_time(typ:word);
var f:word;
begin
  { typ = 0,1    :   thread time = 55   ms }
  { typ = 2      :   thread time = 27.5 ms }
  { typ = 3      :   thread time = 18.3 ms }
  { typ = 4      :   thread time = 13.8 ms }
  { typ = 5      :   thread time = 11   ms }
  { typ = 6      :   thread time = 9.2  ms }
  { typ = 7      :   thread time = 8    ms }
  { typ = 8      :   thread time = 6.8  ms }
  { typ = 9      :   thread time = 6.1  ms }
  { typ = 10     :   thread time = 5.5  ms }
  { typ = 11     :   thread time = 5    ms }
  { typ = 14     :   thread time = 3.9  ms }
  { typ = 18     :   thread time = 3.0  ms }
  { typ = 27     :   thread time = 2.0  ms }
  { typ = 55     :   thread time = 1.0  ms }
  { typ = 110    :   thread time = 0.5  ms }
  { typ = 550    :   thread time = 0.1  ms }
  if typ=0 then typ:=1;
  f:=65535 div typ;
  switchtimer:=typ;
  switchcount:=0;
asm
  cli
  mov cx,word ptr f
  mov dx,43h
  mov al,00110110b
  out dx,al
  mov al,cl                    { lobyte  }
  mov dx,40h
  out dx,al
  mov al,ch                    { Hibyte  }
  out dx,al
  sti
end;
end;



{ MAIN }

var p:pointer;
    i,m:byte;
begin
exitsave:=exitproc;
old8:=ptr(word(ptr(0,8*4+2)^),word(ptr(0,8*4)^)); { Getintvec without DOS call =   getintvec($8,p); }

if not run_multitasking then
  begin
    { OK, no other process has initiated multitasking => }
    { there is only one process running, this process will be the mother }
    { process... }
  p:=ptr(word(ptr(0,$7E*4+2)^),word(ptr(0,$7E*4)^)); { Getintvec without DOS call =  getintvec($7e,p); }
  k:=p;
  if k^.id<>27315 then
    begin
       { OK, no other program executed in single tasking has installed a }
       { multitasking kernel => This unit is the 'mother' unit }
        new(k);mpid:=1; { allocated kernel, this unit is run by the mother process mpid=1  }
        k^.old8:=old8;  { store old int8 handler }
        k^.exitsave:=exitsave; { store old exit procedure vector }
        Init_tasks;     { initialize tasks }
        word(ptr(0,$7e*4)^):=ofs(k^); { setintvec without DOS call }
        word(ptr(0,$7e*4+2)^):=seg(k^);{ initialize kernel - accessible via int $7E }
        end;
    end
  else
  begin
  { OK, multitasking already running... }
  { get kernel via int $7E }
  p:=ptr(word(ptr(0,$7E*4+2)^),word(ptr(0,$7E*4)^)); { Getintvec without DOS call =   getintvec($7E,p); }
  k:=p;  { install kernel }
  m:=0;
  { calculate the highest mother process id }
  for i:=0 to K^.maxtask do if m<K^.task[i].mpd then m:=K^.task[i].mpd;
  inc(m);
  { get the address of the old int8 handler }
  old8:=k^.old8;
  { get the address for the exit procedure }
  exitproc:=@k^.mainexit;
  mpid:=m;
  end;
old1b:=ptr(word(ptr(0,$1b*4+2)^),word(ptr(0,$1b*4)^)); { Getintvec without DOS call = getintvec($1b,old1b);   }
word(ptr(0,$1b*4)^):=ofs(new1b);  { setintvec without DOS call }
word(ptr(0,$1b*4+2)^):=seg(new1b);{ setinvec($1b,@new1b) }
{ INITIALIZE DSEG in the task switch functions }
word(ptr(seg(transfer),ofs(transfer)+52)^):=DSEG;
initmt:=false;
mainstack:=16384;
breakflag:=true;
end.

Process Version 3.0
November 1996

=============================================================================
Process Version 3.1
Januar 1998

=============================================================================
