{ **************************************************************** }
{ * Program: pcopy    - example how to copy more than one file   * }
{ *                     parallel to disk.                        * }
{ *                                                              * }
{ * Process (c) 1996 by Dieter Pawelczak                         * }
{ *                                                              * }
{ **************************************************************** }

{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,100000}

uses process,dutils,crt,dos;

var filecount,execcount:integer; { counter control the number of open files, and executed program interrpreters }
    mainend:boolean;             { main exit variable }

procedure copyfile(Source,Dest:String); { procedure copys file SOURCE to DEST }
var FROMF, TOF:FILE;
    Numread,Numwrite:WORD;
    BUF:array[0..8191] of CHAR;
begin
   if (dest='')  then dest:=copy(source,1,pos('.',source))+'bak';
   wait_dos;
   if filecount>5 then { check number of open files }
      begin
      while filecount>5 do
        begin  wait_dos; ok_dos; delay_task(0); end;
      end;
   inc(filecount);
   wait_dos;
      assign(FRomF,Source); { open source }
      Reset(FROMF,1);
   ok_dos;
   if (ioresult<>0) then    { check result }
      begin
         writeln('Error opening file: ',Source);
         dec(filecount);
         exit;
      end;
   wait_dos;
      if filecount>5 then   { maybe number of openfiles increased by now ? }
          begin
            while filecount>5 do begin wait_dos;ok_dos; delay_task(0);end;
          end;
   wait_dos;                { open destination file }
      assign(TOF,Dest);
      Rewrite(ToF,1);
   ok_dos;
   if (ioresult<>0) then    { check result }
      begin
         dec(filecount);
         writeln('Error creating file: ',dest);
         exit;
      end;
   { Ok, start copy process }
   writeln('Copy file:'+source+' to '+dest);
   repeat
      wait_dos;
          Blockread(FromF,Buf,SizeOf(Buf),Numread);
      ok_dos;
      delay_task(0); { Here to allow multiple copy }
      wait_dos;
        Blockwrite(TOF,Buf,Numread);
      ok_dos;
      if (ioresult<>0) then
          begin
            dec(filecount);
            writeln('Error writing file: ',Dest);
            exit;
          end;
   until (Numread=0) or (Numread<>SizeOF(BUF));
   wait_dos;
     Close(Tof);
   ok_dos;
   writeLn('Transfer to '+DEST+' complete.');
   wait_dos;
     Close(Fromf);
   ok_dos;
   dec(filecount);
end;


procedure copytask; { This task invokes copyfile with the parameters }
var s1:string;
begin
   s1:=read_message;
   clear_message;
   copyfile(s1,'A:'+s1);  { Always copy to A: }
   kill_task(get_current_pid);
end;

procedure dirtask; { This task executes command.com to display the directory }
var s1:string;
begin
   s1:=read_message;
   clear_message;
   while execcount<>0 do delay_task(0); { only one commend.com can be executed... }
   inc(execcount);
   Wait_dos;
      Exec(GetEnv('COMSPEC'), '/C '+s1+' /W');
   ok_dos;
   dec(execcount);
   kill_task(get_current_pid);
end;

procedure task1;
var s:string;
    ch:char;
    pid:word;
begin
   s:='';
   repeat
   print(3,25,'                                                                 ');
   print(1,25,'->'+s);
   if not keypressed then delay_task(0) else
     begin
       ch:=readkey;
       if ch<>#0 then
         begin
           if ch=#27 then mainend:=true;
           if ch>#31 then s:=s+ch;
           if ch=#8 then s:=copy(s,1,length(s)-1);
           if ch=#13 then
             begin
               print(3,25,'                                                                 ');
               s:=bigletters(s);
               if (copy(s,1,4)='DIR ') or (s='DIR') then
                 begin
                   writeln(s);
                   pid:=create_process(@dirtask,16384,1,'DI');
                   while read_message<>'' do delay_task(0);
                   send_message(s);
                   delay_task(0);
                 end else
               if copy(s,1,5)='COPY ' then
                 begin
                   writeln(s);
                   s:=copy(s,6,255);
                   pid:=create_process(@copytask,16384,1,'CP');
                   while read_message<>'' do delay_task(0);
                   send_message(s);
                   delay_task(0);
                 end else
               if s='CLS' then
                 begin
                   clrscr;
                 end else print(1,25,'COMMAND NOT SUPPORTED!                                    ');
                 s:='';
                 while not keypressed do delay_task(0);
             end;
         end else ch:=readkey;
     end;
    delay_task(0);
    until 1=0;
    end;

begin
   create_process(@task1,16384,2,'KB');
   clrscr;
   writeln('PCOPY - Parallel Copy');
   writeln;
   writeln('Commands:  DIR              to display directory contents');
   writeln('           COPY filename    to copy filename to A:');
   writeln('           CLS              to clear screen');
   init_multitasking;
   repeat
   delay_task(20);
   until mainend and (execcount=0) and (filecount=0);
    { don't exit during the execution of command.com or during the copy of a file }
   done_multitasking;
   clear_tasks;


end.
