unit UnitC;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ComCtrls, Spin, ExtCtrls, SMSComp, SMSCalendar, Buttons;

type
  TForm1 = class(TForm)
    GBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    btn_Conn: TButton;
    btn_DisConn: TButton;
    ModelCB: TComboBox;
    PortCB: TComboBox;
    ConnModeCB: TComboBox;
    GB2: TGroupBox;
    GB3: TGroupBox;
    EventsLV: TListView;
    btn_Reload: TButton;
    EvSubjE: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    AlarmChBox: TCheckBox;
    Label7: TLabel;
    RecurChBox: TCheckBox;
    Label8: TLabel;
    PhoneNE: TEdit;
    RecurDaysE: TSpinEdit;
    RecurHoursCBox: TComboBox;
    Bevel1: TBevel;
    btn_add: TButton;
    btn_Change: TButton;
    btn_Del: TButton;
    Label9: TLabel;
    EvTypeCBox: TComboBox;
    LocationL: TLabel;
    Btn_OK: TBitBtn;
    Btn_No: TBitBtn;
    DateE: TDateTimePicker;
    TimeE: TDateTimePicker;
    Label10: TLabel;
    Label11: TLabel;
    LocCBox: TComboBox;
    AlarmDaysE: TSpinEdit;
    AlarmHoursE: TSpinEdit;
    AlarmMinsE: TSpinEdit;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btn_ConnClick(Sender: TObject);
    procedure GetEvent(Location: integer);
    function  FillEvent(var event: TCalendarEntry): boolean;
    procedure LoadEntries;
    procedure EventFields;
    procedure btn_DisConnClick(Sender: TObject);
    procedure ConnState(b: boolean);
    procedure EditingState(b: boolean);
    procedure btn_ReloadClick(Sender: TObject);
    procedure btn_addClick(Sender: TObject);
    procedure btn_ChangeClick(Sender: TObject);
    procedure Btn_OKClick(Sender: TObject);
    procedure Btn_NoClick(Sender: TObject);
    procedure EvTypeCBoxChange(Sender: TObject);
    procedure LocCBoxChange(Sender: TObject);
    procedure btn_DelClick(Sender: TObject);
    procedure AlarmChBoxClick(Sender: TObject);
    procedure RecurChBoxClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  SMS: TOxygenSMS;
  NewEvent : boolean;
implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin

  SMS := TOxygenSMS.Create(self);
  with SMS do
  begin
    ComNumber := 1;
    Model := 0;
    ConnectionMode := 0;
  end;
  ModelCB.ItemIndex := 0;
  PortCB.ItemIndex := 0;
  ConnModeCB.ItemIndex := 0;
  EditingState(false);
  DateE.Date := Now;
  TimeE.Time := Now;
end;

procedure TForm1.ConnState(b: boolean);
begin
  ModelCB.Enabled := not b;
  PortCB.Enabled := not b;
  ConnModeCB.Enabled := not b;
  btn_Conn.Enabled := not b;
end;

procedure TForm1.EditingState(b: boolean);
begin
  btn_Add.Enabled := not b;
  btn_Change.Enabled := not b;
  btn_del.Enabled := not b;
  btn_OK.enabled := b;
  btn_NO.enabled := b;

  LocCBox.Enabled := not b;
  evTypeCBox.Enabled := b;
  evSubjE.ReadOnly := not b;
  DateE.enabled := b;
  TimeE.enabled := b;
  AlarmDaysE.enabled := b;
  AlarmHoursE.enabled := b;
  AlarmMinsE.enabled := b;
  AlarmChBox.Enabled := b;
  RecurDaysE.ReadOnly := not b;
  RecurHoursCBox.Enabled := b;
  RecurChBox.Enabled := b;
  PhoneNE.ReadOnly := not b;
end;

procedure TForm1.GetEvent(Location: integer);
var Event: TCalendarEntry;
    D,H,M,S: integer;
begin
   D := 0; h := 0; M := 0; S := 0;
   Event := SMS.ReadEvent(Location);
   evTypeCBox.itemindex := Ord(Event.EventType);
   evSubjE.Text := Event.Subject;
   DateE.Date := Trunc(Event.NoteTime);
   TimeE.Time := Frac(Event.NoteTime);
   AlarmChBox.Checked := Event.AlarmActive;
   If Event.AlarmActive then
     SMS.AlarmToDHMS(Event.EventType, Event.AlarmBefore, D, H, M, S);
   AlarmDaysE.Value := D;
   AlarmHoursE.Value := H;
   AlarmMinsE.Value := M;
   SMS.RecurrenceToDH(Event.Recurrence,D,H);
   RecurDaysE.Value := D;
   RecurHoursCBox.ItemIndex := H;
   RecurChBox.Checked := Event.RecActive;
   PhoneNE.text := Event.PhoneNumber;

   Event.Free;
end;

function TForm1.FillEvent(var event: TCalendarEntry): boolean;
var D,H,M,S: integer;
begin
  Result := true;
  try
   Event := TCalendarEntry.Create;
   Event.EventType := T7110CalendarEventType(evTypeCBox.itemindex);
   Event.Subject := evSubjE.Text;
   Event.NoteTime := Trunc(DateE.Date) + Frac(TimeE.Time);
   D := AlarmDaysE.Value;
   H := AlarmHoursE.Value;
   M := AlarmMinsE.Value;
   S := 0;
   Event.AlarmBefore := SMS.DHMSToAlarm(Event.EventType, D, H, M, S);
   Event.AlarmActive := AlarmChBox.Checked;
   D := RecurDaysE.Value;
   H := RecurHoursCBox.ItemIndex;
   Event.Recurrence := SMS.DHToRecurrence(D,H);
   Event.RecActive := RecurChBox.Checked;
   Event.PhoneNumber := PhoneNE.text;
  Except Result := false end;
end;

procedure TForm1.EventFields;
begin;
   case EvTypeCBox.ItemIndex of
   0: begin
        EditingState(true);
        PhoneNE.ReadOnly := true;
      end;
   1: begin
        EditingState(true);
        PhoneNE.ReadOnly := false;
      end;
   2: begin
        EditingState(true);
        TimeE.Enabled := false;
        RecurDaysE.Readonly := true;
        RecurHoursCBox.Enabled := false;
        RecurChBox.Enabled := false;
        PhoneNE.ReadOnly := true;
      end;
   3: begin
        EditingState(true);
        TimeE.Enabled := false;
        AlarmDaysE.Enabled := false;
        AlarmHoursE.Enabled := false;
        AlarmMinsE.Enabled := false;
        AlarmChBox.Enabled := false;
        PhoneNE.ReadOnly := true;
      end;
   end;
end;

procedure TForm1.LoadEntries;
var
  i, t, D,H,M,S : integer;
  Event : TCalendarEntry;
  EventList : TList;
  st : string;
begin
  if SMS.TotalEvents < 1 then Exit;
  EventList := SMS.EventLocations;
  If EventList = nil then Exit;
  LocCBox.Items.Clear;
  for i := 0 to EventList.Count - 1 do
  begin
    Event:=SMS.ReadEvent(Integer(EventList[i]));
    if Event <> nil then
    begin
      with EventsLV.Items do
      begin
        Add;
        Item[i].Caption := IntToStr(Integer(EventList[i]));
        LocCBox.Items.Add(IntToStr(Integer(EventList[i])));
        t := ord(Event.EventType);
        case t of
        0: begin
             Item[i].SubItems.Add('Meeting');
             Item[i].SubItems.Add(Event.Subject);
             Item[i].SubItems.Add(DateTimeToStr(Event.NoteTime));

             if Event.AlarmActive then
             begin
               SMS.AlarmToDHMS(Event.EventType, Event.AlarmBefore, D, H, M, S);
               if (D=0) and (H=0) and (M=0) then st := 'On time' else st := Format('%d days %d hours %d minutes before', [D,H,M]);
               Item[i].SubItems.Add(st);
               Item[i].SubItems.Add('ON');
             end
             else
             begin
               Item[i].SubItems.Add('');
               Item[i].SubItems.Add('OFF');
             end;

             SMS.RecurrenceToDH(Event.Recurrence, D, H);
             Item[i].SubItems.Add(Format('every %d days %d hours', [D,H]));
             if Event.RecActive then st := 'ON' else st := 'OFF';
             Item[i].SubItems.Add(st);

             Item[i].SubItems.Add('');
           end;
        1: begin
             Item[i].SubItems.Add('Call');
             Item[i].SubItems.Add(Event.Subject);
             Item[i].SubItems.Add(DateTimeToStr(Event.NoteTime));

             if Event.AlarmActive then
             begin
               SMS.AlarmToDHMS(Event.EventType, Event.AlarmBefore, D, H, M, S);
               if (D=0) and (H=0) and (M=0) then st := 'On time' else st := Format('%d days %d hours %d minutes before', [D,H,M]);
               Item[i].SubItems.Add(st);
               Item[i].SubItems.Add('ON');
             end
             else
             begin
               Item[i].SubItems.Add('');
               Item[i].SubItems.Add('OFF');
             end;

             SMS.RecurrenceToDH(Event.Recurrence, D, H);
             Item[i].SubItems.Add(Format('every %d days %d hours', [D,H]));
             if Event.RecActive then st := 'ON' else st := 'OFF';
             Item[i].SubItems.Add(st);

             Item[i].SubItems.Add(Event.Phonenumber);
           end;
        2: begin
             Item[i].SubItems.Add('Birthday');
             Item[i].SubItems.Add(Event.Subject);
             Item[i].SubItems.Add(DateTimeToStr(Event.NoteTime));

             SMS.AlarmToDHMS(Event.EventType, Event.AlarmBefore, D, H, M, S);
             st := Format('%d days before at %d : %d', [D,H,M]);
             Item[i].SubItems.Add(st);
             if Event.AlarmActive then st := 'ON' else st := 'OFF';
             Item[i].SubItems.Add(st);

             Item[i].SubItems.Add('');
             Item[i].SubItems.Add('');
             Item[i].SubItems.Add('');
           end;
        3: begin
             Item[i].SubItems.Add('Reminder');
             Item[i].SubItems.Add(Event.Subject);
             Item[i].SubItems.Add(DateToStr(Event.NoteTime));

             Item[i].SubItems.Add('');
             Item[i].SubItems.Add('');

             SMS.RecurrenceToDH(Event.Recurrence, D, H);
             Item[i].SubItems.Add(Format('every %d days %d hours', [D,H]));
             if Event.RecActive then st := 'ON' else st := 'OFF';
             Item[i].SubItems.Add(st);

             Item[i].SubItems.Add('');
           end;
        else Item[i].SubItems.Add('Unknown');

        end;
      end;
      Event.Free;
    end;
  end;
  LocCBox.ItemIndex := 0;
  GetEvent(StrToInt(LocCBox.Items[LocCBox.ItemIndex]));
  EventList.Free;
end;

procedure TForm1.btn_ConnClick(Sender: TObject);
begin
  SMS.close;
  SMS.Model := ModelCB.ItemIndex + 3;
  SMS.ComNumber := PortCB.ItemIndex + 1;
  SMS.ConnectionMode := ConnModeCB.ItemIndex;
  ConnState(true);
  If SMS.Open then
  begin
    ShowMessage('Connected successfully');
    EventsLV.Items.Clear;    
    LoadEntries;
  end
  else begin
    SMS.Close;
    ConnState(false);
    ShowMessage('Connection failed')
  end;
end;

procedure TForm1.btn_DisConnClick(Sender: TObject);
begin
   SMS.Close;
   ConnState(false);
end;

procedure TForm1.btn_ReloadClick(Sender: TObject);
begin
   btn_Reload.Enabled := false;
   EventsLV.Items.Clear;
   LoadEntries;
   btn_Reload.Enabled := true;   
end;

procedure TForm1.btn_addClick(Sender: TObject);
begin
  EditingState(true);
  EventFields;
  NewEvent := true;
  evTypeCBox.itemindex := -1;
  evSubjE.Text := 'TOxygenSMS - Calendar Demo';
  DateE.Date := Now;
  TimeE.Time := Now;
  AlarmDaysE.Value := 0;
  AlarmHoursE.Value := 0;
  AlarmMinsE.Value := 0;
  AlarmChBox.Checked := false;
  RecurDaysE.Value := 0;
  RecurHoursCBox.ItemIndex := 0;
  RecurChBox.Checked := false;
  PhoneNE.text := '+7(095)713-9572';
end;

procedure TForm1.btn_ChangeClick(Sender: TObject);
begin
  EditingState(true);
  EventFields;
end;

procedure TForm1.Btn_OKClick(Sender: TObject);
var loc : integer;
    Event : TCalendarEntry;
begin
  Event := TCalendarEntry.Create;
  if not FillEvent(Event) then ShowMessage('Failed to fill event!')
  else begin
    if NewEvent then
    begin
      loc := SMS.GetFreeLocation;
      if loc <> -1 then
      begin
        if not SMS.AddEvent(loc, Event) then  ShowMessage('Error writing event!')
        else ShowMessage('Event added to location #' + IntToStr(loc));
      end
      else ShowMessage('Can''t get free location. Phone memory is full!');
    end
    else
    begin
      loc := StrToInt(LocCBox.Items[LocCBox.ItemIndex]);
      loc := SMS.UpdateEvent(loc, Event);
      case loc of
      -1: ShowMessage('Failed to delete original event!');
      -2: ShowMessage('Failed to get free location!');
      -3: ShowMessage('Error writing event!');
      else ShowMessage('Updated event is put to location #' + IntToStr(loc));
      end;
    end;
  end;
  event.Free;
  btn_ReLoad.Click;
  NewEvent := false;
  EditingState(false);

end;

procedure TForm1.Btn_NoClick(Sender: TObject);
begin
  NewEvent := false;
  EditingState(false);
end;

procedure TForm1.EvTypeCBoxChange(Sender: TObject);
begin
   EventFields;
end;

procedure TForm1.LocCBoxChange(Sender: TObject);
begin
  if LocCBox.Items.Count<>0 then
  begin
    GetEvent(StrToInt(LocCBox.Items[LocCBox.ItemIndex]));
  end;
end;

procedure TForm1.btn_DelClick(Sender: TObject);
begin
  if SMS.DeleteEvent(StrToInt(LocCBox.Items[LocCBox.ItemIndex])) then
    ShowMessage('Deleted successfully.')
  else ShowMessage('Failed to delete event!');
  btn_ReLoad.Click;
end;

procedure TForm1.AlarmChBoxClick(Sender: TObject);
var b : boolean;
begin
  b := AlarmChBox.Checked;
  AlarmDaysE.Enabled := b;
  AlarmHoursE.Enabled := b;
  AlarmMinsE.Enabled := b;
end;

procedure TForm1.RecurChBoxClick(Sender: TObject);
var b: boolean;
begin
  b := RecurChBox.Checked;
  RecurDaysE.Enabled := b;
  RecurHoursCBox.Enabled := b;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SMS.Close;
  SMS.Free;
end;

end.
