unit UnitD;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Jpeg, RXGif,
  ExtDlgs, Buttons, Spin, ComCtrls, ExtCtrls, Grids,
  SMSComp, StdCtrls, Menus, FileCtrl;

type
  TForm1 = class(TForm)
    StBar: TStatusBar;
    GBox1: TGroupBox;
    PhoneML: TLabel;
    PhoneMCB: TComboBox;
    PortL: TLabel;
    PortE: TSpinEdit;
    ConnTypeL: TLabel;
    ConnTCB: TComboBox;
    ConnBtn: TButton;
    DisConnBtn: TButton;
    GBox2: TGroupBox;
    GetInbox_Btn: TButton;
    MsgNumCB: TComboBox;
    TotalL: TLabel;
    TotalMsgL: TLabel;
    BusyL: TLabel;
    BusyMsgL: TLabel;
    CurMsgL: TLabel;
    TextL: TLabel;
    MsgTextL: TLabel;
    TimeL: TLabel;
    MsgTimeL: TLabel;
    FromL: TLabel;
    MsgFromL: TLabel;
    PictureL: TLabel;
    Image1: TImage;
    NoPictureL: TLabel;
    Bevel1: TBevel;
    DelMsg_Btn: TButton;
    ReadMsg_Btn: TButton;
    GBox3: TGroupBox;
    SendToL: TLabel;
    SendTextL: TLabel;
    SendValidL: TLabel;
    NRepChB: TCheckBox;
    UnicodeChB: TCheckBox;
    SendMsgBtn: TButton;
    SendToE: TEdit;
    SendTextE: TEdit;
    SendValidE: TSpinEdit;
    GBox4: TGroupBox;
    MsgGrid: TStringGrid;
    OPD1: TOpenPictureDialog;
    Picture_Btn: TSpeedButton;
    Bevel2: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    Button7: TButton;
    Label8: TLabel;
    SPD: TSavePictureDialog;
    SpeedButton1: TSpeedButton;
    SendSendL: TLabel;
    MSGTypeCB: TComboBox;
    SendSMSCL: TLabel;
    SendSMSCE: TEdit;
    SendMCCL: TLabel;
    SendMNCL: TLabel;
    MCCE: TSpinEdit;
    MNCE: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure ConnBtnClick(Sender: TObject);
    procedure DisConnBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SMSRepReceived(Index: Integer; Time: TDateTime; Send: String; Delivery:integer);
    procedure SMSMSGReceived(Index: Integer; Time: TDateTime;Text, Send: String; Pict: TBitmap);
    procedure ReadMsg_BtnClick(Sender: TObject);
    procedure DelMsg_BtnClick(Sender: TObject);
    procedure GetInbox_BtnClick(Sender: TObject);
    procedure SendMsgBtnClick(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure ConnTCBChange(Sender: TObject);
    procedure PortEChange(Sender: TObject);
    procedure MsgNumCBChange(Sender: TObject);
    procedure PhoneMCBChange(Sender: TObject);
    procedure ConnState(st: boolean);
    procedure Clear1Click(Sender: TObject);
    procedure MsgGridClick(Sender: TObject);
    procedure LoadMessage(location : integer);
    procedure Image1DblClick(Sender: TObject);
    procedure Picture_BtnClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure MSGTypeCBChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  SMS1: TOxygenSMS;
  FldNum: integer;
  Numbers: TStringList;
  SendPic : TBitmap;
  BMPPath : string;
implementation

{$R *.DFM}

procedure TForm1.LoadMessage(location : integer);
var IsMsg: WordBool;
    Time: TDateTime;
    Text, Send : string;
    Deliv: integer;
    Pict : TBitmap;
begin
  if SMS1.ReadSMSMessage(Location, isMsg, Time, Text, Send, Deliv, Pict) then
  begin
    MsgTimeL.caption := DateTimeToStr(Time);
    if isMsg then MsgTextL.caption := Text else MsgTextL.caption := IntTostr(Deliv);
    MsgFromL.caption := send;
    if Pict <> nil then Image1.Picture.Assign(Pict) else Image1.visible := false;
  end
  else
  begin
    MsgTimeL.caption := '';
    MsgTextL.caption := '';
    MsgFromL.caption := '';
    Image1.visible := false;
    ShowMessage('Slot is empty');
  end;

end;

procedure TForm1.ConnState(st: boolean);
begin
  PhoneMCB.Enabled := not st;
  PortE.enabled := not st;
  ConnTCB.Enabled := not st;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin

  SMS1 := TOxygenSMS.create(self);
  with SMS1 do
  begin
    top := 10;
    left := 10;
    ComNumber := 2;
    Model := 0;
    ConnectionMode := 0;
    OnSMSReportReceived := SMSRepReceived;
    OnSMSMessageReceived := SMSMsgReceived;
    AutoDeleteMessages := true;
    AutoDeleteReports := true;
  end;
  Numbers := TStringList.Create;
  PhoneMCB.ItemIndex := 0;
  ConnTCB.ItemIndex := 0;
  with MsgGrid do
  begin
    Cells[0,0] := 'Type';
    Cells[1,0] := 'Location';
    Cells[2,0] := 'From';
    Cells[3,0] := 'Time';
    Cells[4,0] := 'Text';
    Cells[5,0] := 'Picture';
  end;
  ConnState(false);
  SendPic := nil;
  BMPPath := ExtractFileDir(Application.ExeName)+ '\bmp\';
  if not DirectoryExists(BMPPath) then CreateDir(BMPPath);
end;

procedure TForm1.ConnBtnClick(Sender: TObject);
begin
  SMS1.Close;
  if SMS1.Open = true then
  begin
    StBar.Panels[0].text := 'Connected';
    StBar.Panels[1].text := 'Phone type: ' + sms1.PhoneType;
    StBar.Panels[2].text := 'IMEI: ' + SMS1.Imei;
    ConnState(true);
  end
  else ShowMessage('FAILED');

end;

procedure TForm1.DisConnBtnClick(Sender: TObject);
begin
  SMS1.Close;
  StBar.Panels[0].text := 'Not Connected';
  StBar.Panels[1].text := 'Phone type: none';
  StBar.Panels[2].text := 'IMEI:';
  ConnState(false);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SMS1.Close;
  SMS1.Free;
  Numbers.Free;
  RemoveDir(BMPPath);
end;

procedure TForm1.SMSRepReceived(Index: Integer; Time: TDateTime; Send: String; Delivery: integer);
begin
  with MsgGrid do
  begin
    Cells[0,RowCount-1] := 'REP';
    Cells[1,RowCount-1] := IntToStr(Index);
    Cells[2,RowCount-1] := Send;
    Cells[3,RowCount-1] := DateTimeToStr(Time);
    Cells[4,RowCount-1] := IntToStr(Delivery);
    RowCount := RowCount + 1;
    MsgNumCB.Items.Add(IntTostr(Index));
    BusyMsgL.Caption := IntToStr(MsgNumCB.Items.count);
  end;
  StBar.Panels[3].text := 'Report arrived';
end;

procedure TForm1.SMSMSGReceived(Index: Integer; Time: TDateTime; Text, Send: String; Pict: TBitMap);
begin
  with MsgGrid do
  begin
    Cells[0,RowCount-1] := 'MSG';
    Cells[1,RowCount-1] := IntToStr(Index);
    Cells[2,RowCount-1] := Send;
    Cells[3,RowCount-1] := DateTimeToStr(Time);
    Cells[4,RowCount-1] := Text;
    if Pict <> nil then
    begin
      Cells[5,RowCount-1] := 'Picture';
      Pict.SaveToFile(BMPPath + IntToStr(RowCount-1)+ '.bmp');
    end;
    RowCount := RowCount + 1;
    if Index <> 0 then
    begin
      MsgNumCB.Items.Add(IntTostr(Index));
      BusyMsgL.Caption := IntToStr(MsgNumCB.Items.count);
    end
  end;
  StBar.Panels[3].text := 'Message arrived';
end;

procedure TForm1.ReadMsg_BtnClick(Sender: TObject);
begin

 LoadMessage(StrToInt(MsgNumCB.text));

end;

procedure TForm1.DelMsg_BtnClick(Sender: TObject);
var s : string;
    i : integer;
begin
try
  if SMS1.DeleteSMSMessage(StrToInt(MsgNumCB.text)) then
  begin
    MsgNumCB.Items.Delete(MsgNumCB.ItemIndex);
    StBar.Panels[3].text := 'Message deleted';
    s := BusyMsgL.Caption;
    i := StrToInt(s);
    if i > 0 then
    begin
      Dec(i);
      s := IntToStr(i);
      BusyMsgL.Caption := s;
    end;
    MsgNumCB.text := '';
  end
  else StBar.Panels[3].text := 'Message NOT deleted';
except end;
end;

procedure TForm1.GetInbox_BtnClick(Sender: TObject);
var count, busy : integer;
    Locations : string;
begin
  GetInbox_Btn.Enabled := false;
  SMS1.GetInboxInfo(Count, Busy, Locations);
  TotalMsgL.Caption := IntToStr(Count);
  BusyMsgL.Caption := IntToStr(Busy);
  MsgNumCB.Clear;
  MsgNumCB.Items.CommaText := Locations;
  if MsgNumCB.Items.Count > 0 then
  begin
    MsgNumCB.ItemIndex := 0;
    MsgNumCBChange(Self);
  end;
  GetInbox_Btn.Enabled := true;
end;

procedure TForm1.SendMsgBtnClick(Sender: TObject);
var Res : boolean;
begin
  if SendSMSCE.text <> '' then SMS1.SetSMSCNumber(SendSMSCE.text);
  StBar.Panels[3].text := 'Sending message...';
  Case MsgTypeCB.ItemIndex of
    0: Res := sms1.SendSMSMessage(SendToE.text, SendtextE.text, StrToInt(SendValidE.text), NRepChB.Checked, UnicodeChB.Checked, nil);
    1: Res := sms1.SendUnicodeSMSMessage(SendToE.text, SendtextE.text, StrToInt(SendValidE.text), NRepChB.Checked, nil);
    2: Res := sms1.SendSMSMessage(SendToE.text, SendtextE.text, StrToInt(SendValidE.text), NRepChB.Checked, UnicodeChB.Checked, SendPic);
    3: if sms1.CheckRTTTL(SendtextE.text) = 0 then Res := sms1.SendRingtone(SendToE.text, SendtextE.text, StrToInt(SendValidE.text), NRepChB.Checked) else Res := false;
    4: Res := sms1.SendOperatorLogo(SendToE.text, MCCE.Value, MNCE.Value, StrToInt(SendValidE.text), NRepChB.Checked, SendPic);
    5: Res := sms1.SendCLILogo(SendToE.text, StrToInt(SendValidE.text), NRepChB.Checked, SendPic);
    Else Res := false;
  end;
    if Res then StBar.Panels[3].text := 'Message sent' else StBar.Panels[3].text := 'Message NOT sent';

end;

procedure TForm1.Button7Click(Sender: TObject);
begin

  if SMS1.CheckConnection then
  begin
    Label1.Caption := 'State: ' + IntToStr(SMS1.State);
    Label2.Caption := 'SMSC: ' + SMS1.getsmscnumber;
    Label3.Caption := 'Signal: ' + IntToStr(SMS1.SignalLevel);
    Label4.Caption := 'Battery: ' + IntToStr(SMS1.BatteryLevel);
    Label5.Caption := 'HardWare: ' + SMS1.HW;
    Label6.Caption := 'Software: ' + SMS1.SW;
    Label7.Caption := 'SWDate: ' + SMS1.SWDate;
    StBar.Panels[0].text := 'Connected';
  end
  else  StBar.Panels[0].text := 'Not Connected';


end;

procedure TForm1.ConnTCBChange(Sender: TObject);
begin

  case ConnTCB.ItemIndex of
    0: SMS1.ConnectionMode := 0;
    1: SMS1.ConnectionMode := 1;
    2: SMS1.ConnectionMode := 2;
  end;

end;

procedure TForm1.PortEChange(Sender: TObject);
begin

 SMS1.ComNumber := StrToInt(PortE.text);

end;

procedure TForm1.MsgNumCBChange(Sender: TObject);
begin
  if MsgNumCB.text <> '' then LoadMessage(StrToInt(MsgNumCB.text));
end;

procedure TForm1.PhoneMCBChange(Sender: TObject);
begin
    SMS1.Model := PhoneMCB.ItemIndex;
end;


procedure TForm1.Clear1Click(Sender: TObject);
begin
  SendPic := nil;
  Picture_btn.Glyph.Assign(nil);
end;

procedure TForm1.MsgGridClick(Sender: TObject);
begin
  with MsgGrid do
  if Row <> RowCount-1 then
    case StrToInt(Cells[1, Row]) of
    0:
    begin
      MsgFromL.caption := Cells[2, Row];
      MsgTimeL.caption := Cells[3, Row];
      MsgTextL.caption := Cells[4, Row];
      try
        Image1.Picture.LoadFromFile(BMPPath + IntToStr(Row) + '.bmp');
        Image1.visible := true;
      except Image1.visible := false;
      end;
    end;
    else
    begin
      MsgNumCB.itemindex := MsgNumCB.Items.IndexOf(Cells[1, Row]);
      LoadMessage(StrToInt(Cells[1, Row]));
      Image1.visible := false;
    end;
    end;
end;

procedure TForm1.Image1DblClick(Sender: TObject);
begin
  if SPD.Execute then Image1.Picture.SaveToFile(SPD.filename);
end;

procedure TForm1.Picture_BtnClick(Sender: TObject);
begin
  if OPD1.Execute then
  begin
    Picture_btn.Caption := '';
    Picture_btn.Glyph.LoadFromFile(OPD1.FileName);
    SendPic := Picture_btn.Glyph;
//    SendPic.width := 72;
//    SendPic.height := 28;
//    SendPic.height := 14;
  end;

end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  SendPic := nil;
  Picture_btn.Glyph.Assign(nil);
  Picture_btn.Caption := 'No picture'
end;

procedure TForm1.MSGTypeCBChange(Sender: TObject);
begin

   if MSGTypeCB.ItemIndex = 4 then begin
     MCCE.Enabled := true;
     MNCE.Enabled := true;
   end else begin
     MCCE.Enabled := false;
     MNCE.Enabled := false;
   end;

end;

end.

