// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'NokiaSMS.pas' rev: 5.00

#ifndef NokiaSMSHPP
#define NokiaSMSHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <NokiaSmartSMS.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <NokiaUtils.hpp>	// Pascal unit
#include <NokiaConn.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Nokiasms
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TMsgKind { mkMT, mkDR, mkMO, mkPIC, mkUN };
#pragma option pop

#pragma option push -b-
enum TSMSCFormat { sfText, sfPaging, sfFax, sfEmail, sfUnknown };
#pragma option pop

#pragma option push -b-
enum TSMSValidity { sv1Hour, sv6Hours, sv1Day, sv3Days, sv1Week, svMaxTime, svUnknown };
#pragma option pop

#pragma option push -b-
enum TDeliveryProcess { dpDelivered, dpNotDelivered, dpPermanentError, dpInProcess };
#pragma option pop

#pragma option push -b-
enum TDeliveryReport { drOK, drForwarded, drReplaced, drRPError, drDestination, drMERejected, drNotObtainable, 
	drBadQuality, drNoInet, drValidity, drMODeleted, drSMSCDeleted, drSMNotExist, drCongestion, drBusy, 
	drNoResponse, drRejected, drMEError, drUnknown };
#pragma option pop

#pragma option push -b-
enum TMessageContent { mcText, mcRingtone, mcOpLogo, mcGrLogo, mcPicture, mcProfile, mcUnknown };
#pragma option pop

struct TPhoneNumber
{
	AnsiString Number;
	bool Domestic;
} ;

struct TSMSMessageInfo
{
	int FolderCode;
	int Location;
	TMsgKind Kind;
	bool Received;
	bool Status;
	AnsiString SMSCenter;
	AnsiString PhoneNumber;
	System::TDateTime Time;
	Byte Validity;
	Byte Delivery;
	bool Receipt;
	Byte TextType;
	AnsiString Text;
	bool UDH;
	Byte UDHCount;
	Byte UDHIndex;
	TMessageContent UDHContent;
	Byte UDHTextType;
	AnsiString UDHText;
	Graphics::TBitmap* UDHPicture;
	AnsiString RawData;
} ;

struct TSMSCenterProfile
{
	int No;
	TSMSCFormat Format;
	Byte Validity;
	AnsiString Name;
	AnsiString Number;
} ;

typedef void __fastcall (__closure *TSMSNotifyEvent)(const TSMSMessageInfo &Msg);

typedef TSMSCenterProfile NokiaSMS__2[3];

class DELPHICLASS TNokiaSMS;
class PASCALIMPLEMENTATION TNokiaSMS : public Nokiaconn::TNokiaAddon 
{
	typedef Nokiaconn::TNokiaAddon inherited;
	
private:
	bool fFamily;
	int fUnread;
	int fTotal;
	TSMSCenterProfile fSMSCenter[3];
	TSMSNotifyEvent fSMSMessageReceived;
	TSMSNotifyEvent fSMSReportReceived;
	Nokiasmartsms::TReceptionList* fRecList;
	
protected:
	int __fastcall GetUnreadMessages(void);
	int __fastcall GetTotalMessages(void);
	TSMSCenterProfile __fastcall GetSMSCenter(int Index);
	void __fastcall SetSMSCenter(int Index, const TSMSCenterProfile &Value);
	virtual void __fastcall DoEvents(Byte MsgType, AnsiString Msg, Classes::TStringList* Cmd, Classes::TStringList* 
		Reply);
	bool __fastcall ParseSMS(AnsiString Data, TSMSMessageInfo &Msg);
	
public:
	Byte IncMsg;
	__fastcall virtual TNokiaSMS(Classes::TComponent* AOwner);
	__fastcall virtual ~TNokiaSMS(void);
	bool __fastcall SendAnyMessage(const TSMSMessageInfo &Msg);
	__property TSMSCenterProfile SMSCenter[int Index] = {read=GetSMSCenter, write=SetSMSCenter};
	bool __fastcall GetFolderList(Classes::TStringList* Codes, Classes::TStringList* Names);
	bool __fastcall GetFolderNumbers(int FldNum, Classes::TStringList* Numbers);
	bool __fastcall DeleteFolder(int FldNum);
	bool __fastcall CreateFolder(int FldNum, AnsiString FldName);
	bool __fastcall RenameFolder(int FldNum, AnsiString FldName);
	int __fastcall GetFreeLocation(int FldNum);
	int __fastcall GetPlainFreeLocation(void);
	bool __fastcall RemoveFolder(int FldNum);
	bool __fastcall GetMessage(int FldNum, int MsgNum, TSMSMessageInfo &Msg);
	AnsiString __fastcall GetMessageText(int FldNum, int MsgNum);
	bool __fastcall SaveRawMessage(int FldNum, TSMSMessageInfo &Msg);
	bool __fastcall SaveMessage(int FldNum, TSMSMessageInfo &Msg);
	bool __fastcall DeleteMessage(int FldNum, int MsgNo);
	void __fastcall CheckNewMessages(void);
	bool __fastcall GetPlainMessage(int MsgNum, TSMSMessageInfo &Msg);
	bool __fastcall SavePlainRawMessage(TSMSMessageInfo &Msg);
	bool __fastcall SavePlainMessage(TSMSMessageInfo &Msg);
	bool __fastcall DeletePlainMessage(int MsgNum);
	bool __fastcall GetPictureMessage(int Index, Graphics::TBitmap* &Pic, AnsiString &Name, AnsiString 
		&Phone);
	bool __fastcall SetPictureMessage(int Index, Graphics::TBitmap* Pic, AnsiString Name, AnsiString Phone
		);
	__property int UnreadMessages = {read=GetUnreadMessages, nodefault};
	__property int TotalMessages = {read=GetTotalMessages, nodefault};
	bool __fastcall NewInit(void);
	AnsiString __fastcall NewIMEI();
	AnsiString __fastcall NewModel();
	bool __fastcall Init7110SMS(void);
	AnsiString __fastcall GetHW();
	int __fastcall GetSignalLevel(void);
	int __fastcall GetBatteryLevel(void);
	bool __fastcall SendRingtone(AnsiString PhoneNumber, AnsiString SMSC, AnsiString RTTTL, Byte Validity
		, bool NeedReport);
	bool __fastcall SendOperatorLogo(AnsiString PhoneNumber, AnsiString SMSC, int MCC, int MNC, Byte Validity
		, bool NeedReport, Graphics::TBitmap* Picture);
	bool __fastcall SendCLILogo(AnsiString PhoneNumber, AnsiString SMSC, Byte Validity, bool NeedReport
		, Graphics::TBitmap* Picture);
	bool __fastcall SendSmartSMS(const Nokiasmartsms::TSmartSMSData &Msg);
	
__published:
	__property bool PhoneFamily = {read=fFamily, write=fFamily, default=1};
	__property TSMSNotifyEvent OnSMSMessageReceived = {read=fSMSMessageReceived, write=fSMSMessageReceived
		};
	__property TSMSNotifyEvent OnSMSReportReceived = {read=fSMSReportReceived, write=fSMSReportReceived
		};
};


//-- var, const, procedure ---------------------------------------------------
static const int SMS_BASE_ERR = 0x10000;
static const int perSMSSendFail = 0x10001;
static const int perSMSEmptyLoc = 0x10002;
static const int perSMSInvalidLoc = 0x10003;
extern PACKAGE Byte PC437[256];
extern PACKAGE Byte ISO8859[256];
extern PACKAGE AnsiString LongSMS;
extern PACKAGE AnsiString StartMsg;
extern PACKAGE bool ReadingLong;
extern PACKAGE TSMSMessageInfo MsgRec;
extern PACKAGE bool IsLongData;
extern PACKAGE AnsiString LongData;
extern PACKAGE AnsiString LongParam;
extern PACKAGE int LongLen;
extern PACKAGE Classes::TStringList* NewMsg;
extern PACKAGE Classes::TStringList* FreeMsg;
extern PACKAGE int SmartNo;
extern PACKAGE int SendingTimeOut;
extern PACKAGE Byte CurSMSId;
extern PACKAGE int __fastcall GetPhoneModel(AnsiString ModelName);
extern PACKAGE int __fastcall GetPhoneInfo(Nokiaconn::TNokiaConnection* nc, TNokiaSMS* sms, int Mode
	, AnsiString &Model, AnsiString &IMEI);
extern PACKAGE Graphics::TBitmap* __fastcall String2Bitmap(AnsiString Data, int Width, int Height);
extern PACKAGE AnsiString __fastcall Bitmap2String(Graphics::TBitmap* Bmp);
extern PACKAGE void __fastcall Register(void);

}	/* namespace Nokiasms */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Nokiasms;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// NokiaSMS
