// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'NokiaConn.pas' rev: 5.00

#ifndef NokiaConnHPP
#define NokiaConnHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <ConnSender.hpp>	// Pascal unit
#include <NokiaUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Nokiaconn
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TState { stClosed, stOpen, stBusy };
#pragma option pop

#pragma option push -b-
enum TPhoneStatus { psNet, psCalling, psPIN, psOff, psUnknown };
#pragma option pop

#pragma option push -b-
enum TPowerSource { pwBattery, pwACDC, pwUnknown };
#pragma option pop

#pragma option push -b-
enum TPhoneEvent { peDialing, peDialFinished, peConnected, peRemoteHangup, peCalling, peCallAnswered, 
	peCallHangup, peUnknown };
#pragma option pop

typedef void __fastcall (__closure *TNotifyPhoneEvent)(TPhoneEvent Event, int Seq, AnsiString Number
	, AnsiString Name);

typedef void __fastcall (__closure *TSimpleNotifyEvent)(void);

#pragma option push -b-
enum TNetworkMode { nmHome, nmRoaming, nmRequesting, nmNotRegistered, nmUnknown };
#pragma option pop

#pragma option push -b-
enum TNetworkSelection { nsManual, nsAutomatic };
#pragma option pop

struct T7110Params
{
	AnsiString Firmware;
	AnsiString FirmDate;
	AnsiString Model;
} ;

struct TNetworkInfo
{
	AnsiString NetworkCode;
	AnsiString CellID;
	AnsiString LAC;
	TNetworkMode NetworkMode;
	TNetworkSelection NetworkSelection;
} ;

#pragma pack(push, 1)
struct TDisplayStatus
{
	bool CallInProgress;
	bool Unknown;
	bool UnreadSMS;
	bool VoiceCall;
	bool FaxCallActive;
	bool DataCallActive;
	bool KeyboardLock;
	bool SMSFull;
} ;
#pragma pack(pop)

#pragma option push -b-
enum TSecurityCode { scUnknown, scCode, scPIN, scPIN2, scPUK, scPUK2, scNone };
#pragma option pop

struct TProfileData
{
	int Number;
	AnsiString Name;
	Byte KeypadTone;
	Byte Lights;
	Byte CallAlert;
	Byte Ringtone;
	Byte Volume;
	Byte MessageTone;
	Byte Vibration;
	Byte WarningTone;
	Byte CallerGroups;
	Byte AutomaticAnswer;
} ;

struct TGroupData
{
	int Number;
	AnsiString Name;
	int Ringtone;
	bool IconOn;
	int Height;
	int Width;
	AnsiString Bitmap;
} ;

class DELPHICLASS TNokiaConnection;
class DELPHICLASS TNokiaAddon;
class PASCALIMPLEMENTATION TNokiaConnection : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Connsender::TConnectionSender* fWork;
	int fComNumber;
	Connsender::TConnectionMode fConnectionMode;
	Byte fPrefix;
	Byte fPostfix;
	Classes::TList* fAddons;
	Classes::TStringList* fCmds;
	Classes::TStringList* fReps;
	TPhoneStatus fPhoneStatus;
	TPowerSource fPowerSource;
	int fBatteryLevel;
	int fSignalLevel;
	bool fAlarmOn;
	TNotifyPhoneEvent fPhoneEvent;
	TSimpleNotifyEvent FBatteryChange;
	TSimpleNotifyEvent FSignalChange;
	AnsiString fInLogName;
	AnsiString fOutLogName;
	unsigned fInitLength;
	bool fJustStatus;
	int fSeries;
	bool fNeedConnect;
	bool fUse7110IrDa;
	void __fastcall SetComNumber(int Value);
	void __fastcall SetInteger(int Value);
	TPhoneStatus __fastcall GetPhoneStatus(void);
	int __fastcall GetBatteryLevel(void);
	TPowerSource __fastcall GetPowerSource(void);
	int __fastcall GetSignalLevel(void);
	void __fastcall SetPhoneStatus(TPhoneStatus Value);
	void __fastcall SetPowerSource(TPowerSource Value);
	System::TDateTime __fastcall GetDateTime(void);
	void __fastcall SetDateTime(System::TDateTime Value);
	System::TDateTime __fastcall GetAlarmDateTime(void);
	void __fastcall SetAlarmDateTime(System::TDateTime Value);
	int __fastcall GetSpeedDial(int Index);
	void __fastcall SetSpeedDial(int Index, int Value);
	AnsiString __fastcall GetIMEI();
	AnsiString __fastcall GetIMEI2();
	AnsiString __fastcall GetIMEI3();
	AnsiString __fastcall GetModel();
	AnsiString __fastcall GetHWRevision();
	AnsiString __fastcall GetSWRevision();
	AnsiString __fastcall DoMagic(AnsiString imei, AnsiString magic);
	void __fastcall SetInitLength(unsigned Value);
	
protected:
	void __fastcall ProcessPackets(Byte MsgType, AnsiString Msg);
	void __fastcall InsertAddon(TNokiaAddon* Addon);
	
public:
	__fastcall virtual TNokiaConnection(Classes::TComponent* AOwner);
	__fastcall virtual ~TNokiaConnection(void);
	bool __fastcall Open(void);
	void __fastcall Close(void);
	bool __fastcall Connect(void);
	bool __fastcall SendMessage(Byte MsgType, AnsiString Msg, AnsiString MsgId, int TimeOut, AnsiString 
		&Reply);
	TState __fastcall State(void);
	void __fastcall UpdateInfo(void);
	TNetworkInfo __fastcall GetNetworkInfo();
	TDisplayStatus __fastcall GetDisplayStatus();
	TSecurityCode __fastcall GetSecurityStatus(void);
	void __fastcall SetSecurityCode(TSecurityCode Kind, AnsiString Code);
	void __fastcall DialVoice(AnsiString Number);
	void __fastcall DialData(AnsiString Number, bool DigitalMode);
	void __fastcall Hangup(void);
	TProfileData __fastcall GetProfile(int Index);
	void __fastcall SetProfile(int Index, const TProfileData &Profile);
	__property AnsiString IMEI = {read=GetIMEI};
	__property AnsiString IMEI2 = {read=GetIMEI2};
	__property AnsiString IMEI3 = {read=GetIMEI3};
	__property AnsiString Model = {read=GetModel};
	__property int Series = {read=fSeries, nodefault};
	__property AnsiString HWRevision = {read=GetHWRevision};
	__property AnsiString SWRevision = {read=GetSWRevision};
	__property int SpeedDial[int Index] = {read=GetSpeedDial, write=SetSpeedDial};
	
__published:
	__property int ComNumber = {read=fComNumber, write=SetComNumber, nodefault};
	__property AnsiString InLogName = {read=fInLogName, write=fInLogName};
	__property AnsiString OutLogName = {read=fOutLogName, write=fOutLogName};
	__property unsigned InitLength = {read=fInitLength, write=SetInitLength, nodefault};
	__property bool NeedConnect = {read=fNeedConnect, write=fNeedConnect, nodefault};
	__property Connsender::TConnectionMode ConnectionMode = {read=fConnectionMode, write=fConnectionMode
		, nodefault};
	__property Byte HeaderPrefix = {read=fPrefix, write=fPrefix, nodefault};
	__property Byte HeaderPostfix = {read=fPostfix, write=fPostfix, nodefault};
	__property TPhoneStatus PhoneStatus = {read=GetPhoneStatus, write=SetPhoneStatus, nodefault};
	__property int BatteryLevel = {read=GetBatteryLevel, write=SetInteger, nodefault};
	__property TPowerSource PowerSource = {read=GetPowerSource, write=SetPowerSource, nodefault};
	__property int SignalLevel = {read=GetSignalLevel, write=SetInteger, nodefault};
	__property System::TDateTime PhoneTime = {read=GetDateTime, write=SetDateTime};
	__property System::TDateTime AlarmTime = {read=GetAlarmDateTime, write=SetAlarmDateTime};
	__property bool AlarmOn = {read=fAlarmOn, write=fAlarmOn, nodefault};
	__property bool Use7110IrDa = {read=fUse7110IrDa, write=fUse7110IrDa, nodefault};
	__property TNotifyPhoneEvent OnPhoneEvent = {read=fPhoneEvent, write=fPhoneEvent};
	__property TSimpleNotifyEvent OnBatteryLevelChange = {read=FBatteryChange, write=FBatteryChange};
	__property TSimpleNotifyEvent OnSignalLevelChange = {read=FSignalChange, write=FSignalChange};
	T7110Params __fastcall GetParams();
	bool __fastcall Init7110(void);
	bool __fastcall Init7110SMS(void);
};


class PASCALIMPLEMENTATION TNokiaAddon : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
protected:
	AnsiString fEventTypes;
	TNokiaConnection* fConnection;
	void __fastcall SetConnection(TNokiaConnection* Value);
	virtual void __fastcall DoEvents(Byte MsgType, AnsiString Msg, Classes::TStringList* Cmd, Classes::TStringList* 
		Reply) = 0 ;
	
__published:
	__property TNokiaConnection* Connection = {read=fConnection, write=SetConnection};
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TNokiaAddon(Classes::TComponent* AOwner) : Classes::TComponent(
		AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TNokiaAddon(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const int CON_BASE_ERR = 0x10000;
static const int perConWrongCode = 0x10001;
extern PACKAGE wchar_t ssss[101];
extern PACKAGE AnsiString LongData;
extern PACKAGE AnsiString LongParam;
extern PACKAGE bool IsLongData;
extern PACKAGE AnsiString __fastcall UnicodeToText(AnsiString st);
extern PACKAGE void __fastcall Register(void);

}	/* namespace Nokiaconn */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Nokiaconn;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// NokiaConn
