//----------------------------------------------------------------------------
// Copyright (c) 1995, by Karl Tiller
//----------------------------------------------------------------------------

#if !defined (__WINDOW_H)
#define __WINDOW_H

#if !defined (__BOOLEAN_H)
	#include "boolean.h"
#endif

#if !defined (__FRAME_H)
	#include "frame.h"
#endif

class TWindow
{
	public:
		TWindow (TRectangle _Rectangle, int _Frame = DoubleFrame,
			TColor _BackgrColor = Blue, TColor _ForegrColor =
			Yellow, const char *_Title = "No Title");
		~TWindow ();

		void Show ();
		void Hide ();

		void SetLocation (TLocation Location);
		TLocation GetLocation ();

		void SetSize (TLocation Size);
		TLocation GetSize ();

		void SetFrame (int _Frame);
		int GetFrame ();

		void SetBackgrColor (TColor _BackgrColor);
		TColor GetBackgrColor ();

		void SetForegrColor (TColor _ForegrColor);
		TColor GetForegrColor ();

		void SetTitle (const char *_Title);
		const char *GetTitle ();

		void DrawString (TLocation Location, const char *String,
			TColor BackgrColor, TColor ForegrColor);

	private:
		TRectangle Rectangle;

		int Frame;

		TColor BackgrColor;
		TColor ForegrColor;

		const char *Title;

		TBoolean Visible;

		unsigned *OldImage;
};

#endif
