{***********************************************************}
{                                                           }
{        Tip Of The Day Delphi Component                    }
{                                                           }
{        Standard Tip Of The Day Dialog Box                 }
{                                                           }
{        Copyright (C) 1996, by Jan Goyvaerts               }
{        All rights reserved                                }
{                                                           }
{***********************************************************}

{***********************************************************}
{                                                           }
{        Delphi component unit                              }
{           - TTipOfTheDay                                  }
{        -> JG page                                         }
{                                                           }
{        Delphi form unit: TTipOfTheDayForm                 }
{        -> encapsulated by TTipOfTheDay                    }
{                                                           }
{***********************************************************}

unit TipDay;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls, Buttons,
  Tips;

type
  TTipOfTheDayForm = class(TForm)
    ShowTipsCheck: TCheckBox;
    Panel1: TPanel;
    Panel2: TPanel;
    HeaderLabel: TLabel;
    TipLabel: TLabel;
    OkBtn: TBitBtn;
    NextBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Image1: TImage;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TTipOfTheDay = class(TCustomTipOfTheDay)
  private
    FShowHelpButton: Boolean;
  protected
    procedure NextBtnClick(Sender: TObject);               { Event handlers for our tip of the day form }
    procedure EventShowForm; override;                     { Called when our tip of the day form displays }
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Must help button be shown on tip of the day form? }
    property ShowHelpButton: Boolean read FShowHelpButton write FShowHelpButton default True;
  published { inherited properties }
    { List of tips. Use the Object Inspector to edit. Has LoadFromFile and SaveToFile methods }
    property Tips;
    { Set this to False in your main form's OnCreate event handler if the user doesn't want tips at startup }
    property ShowTipsAtStartup;
(*  Un-comment these if you need them
    { Caption of tip of the day form in case of an error }
    property ErrorCaption: string;
    { Tip header in case of an error (instead of "Did you know...") }
    property ErrorHeader: string;*)
    { Event handler called just before the tip of the day form displays }
    property OnShowForm;
    { Event handler called when the user has tip of the day is displayed }
    property OnNextTip;
  end;


implementation

{$R *.DFM}


         { ********* TTipOfTheDay component ********* }

      { ******* TTipOfTheDay private methods ****** }


      { ******* TTipOfTheDay protected methods ****** }

procedure TTipOfTheDay.NextBtnClick(Sender: TObject);
begin
  ShowNextTip
end;

procedure TTipOfTheDay.EventShowForm;
begin
  inherited EventShowForm;
  with TipForm as TTipOfTheDayForm do                      { Show or hide help button as needed }
    HelpBtn.Visible := ShowHelpButton;
end;


      { ******* TTipOfTheDay public methods ****** }

constructor TTipOfTheDay.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);                                { Create ourself }
  FShowHelpButton := True;                                 { Set default property values }
  TipForm := TTipOfTheDayForm.Create(nil);                 { Create our tip of the day form }
  with TipForm as TTipOfTheDayForm do begin
    NextBtn.OnClick := NextBtnClick;                       { Hook our event handlers }
    HeaderComponent := HeaderLabel;                        { Let our ancestor know what we have }
    TipComponent := TipLabel;
    ShowTipsComponent := ShowTipsCheck
  end
end;

destructor TTipOfTheDay.Destroy;
begin
  TipForm.Free;
  inherited Destroy
end;


         { ********* TTipOfTheDayForm methods ********* }


initialization
  Randomize;       { Don't show the same tip each time }
end.
