/*
	Graphics library for C  (V3)

	(C)1992-1996 Copyright Servile Software
*/


extern unsigned char _attribute;

extern int _dmode;

extern int _lastx;
extern int _lasty;

/* Maximum coordinates for graphics screen */
extern int _maxx;
extern int _maxy;

/* Sprite structure */
struct SP
{
	int x;
	int y;
	unsigned char data[256];
	unsigned char save[256];
};
typedef struct SP SPRITE;

/* Window structure */
struct WI
{
	unsigned char left;
	unsigned char top;
	unsigned char right;
	unsigned char bottom;
	unsigned char row;
	unsigned char col;
	unsigned char attribute;
};
typedef struct WI SWINDOW;


typedef struct velb far * VP;       /* VP = FAR pointer to video RAM */

struct velb
{
			 unsigned char ASCCode;                /* ASCII code */
			 unsigned char charattr;               /* Corresponding attribute */
};

#define CRT_START ((unsigned far *) MK_FP(0x40, 0x4E))
#define ADDR_6845 ((unsigned far *) MK_FP(0x40, 0x63))
#define EGA_MONO   1             /* EGA and MDA monitor */
#define EGA_COLOUR 2             /* EGA and EGA monitor */
#define VGA_MONO   3             /* VGA and analog monochrome monitor */
#define VGA_COLOUR 4             /* VGA and VGA monitor */
#define NEITHERNOR 0             /* No VGA, no EGA */


/* Function Prototypes */

int dtoi(double x);
void grdump(void);
int getmode(int *ncols);
void setvideo(int);
void getcursor(int *row, int *col);
void setcursor(char status);
void at(int row, int col);
void clsc(unsigned char attrib);
void clrwindow(int x1, int y1,int x2, int y2, unsigned char attrib);
void scrollsc(void);
void winscr(unsigned char left,unsigned char top, unsigned char right, unsigned char bottom, unsigned char direction,unsigned char numlines);
unsigned char attr(int foregrnd, int backgrnd);
void dplot4(int x, int y, unsigned char);
void dplot13(int x, int y, unsigned char);
void dplot16(int x, int y, unsigned char);
void dplot19(int x, int y, unsigned char);
void egadefchar(unsigned, void far *);
void vgadefchar(unsigned, void far *);
void charwidth(unsigned);
void shadewin(unsigned char left, unsigned char top, unsigned char right, unsigned char bottom);
void bprintf(char *format, ...);
void dprint(unsigned char, unsigned char, unsigned char, char *);
void wrtstr(char *output);
void getwin(int left, int top, int right, int bottom,char *buffer);
void putwin(int left, int top, int right, int bottom,char *buffer);
void setpalette(unsigned char palno);
void setborder(unsigned char x);
void setlines(unsigned char x);
void setht(unsigned char x);
void graphbackground(unsigned char colour);
void plot(int x, int y, unsigned char colour);
int pixset(int x, int y);
void move(int x, int y);
void line(int a, int b, int c, int d, int col);
void ellipse(int x, int y, int xrad, int yrad,double incline,int col);
void polygon(int x, int y, int rad, int col, int sides, int start);
void arc(int x, int y, int rad, int start, int end,int col);
void segm(int x, int y, int rad, int start, int end,int col);
void box(int xa,int ya, int xb, int yb, int col);
void tri(int xa,int ya, int xb, int yb, int xc, int yc,int col);
void fill(int x, int y, int col,int pattern);
void invert(int xa,int ya, int xb, int yb, int col);
void circle(int x_centre , int y_centre, int radius, int colour);
void draw(int x, int y, int colour);
int menu(int left,int top,int right,int bottom,int number,char **list);
int input(char *text,unsigned length);
void psprite(SPRITE *sprite,int x,int y);
void writes(char *, unsigned char);
unsigned char isegavga(void);
void acharset(unsigned char);
void lcharset(unsigned char, unsigned char);
void luchar(unsigned char far *, int , unsigned char , unsigned char , unsigned char);
void cgapal(int);
void egapal(int, int);
void tprint(char *,int,int,unsigned char);
void vgapal(int, int, int, int);
void wincls(SWINDOW *winstruc);
void wprintf(SWINDOW *winstruc,char *format, ...);
