//----------------------------------------------------------------------------
// Written by Karl Tiller.
//----------------------------------------------------------------------------

#include <IOStream.H>

#define _Use_CRC
#define _Use_DataSum

#include "Sums.H"

void main ()
{
   cout << "Note:\n"
      << SumsInfo . Note << endl << endl;

   cout << "Version:\n"
      << SumsInfo . VerMajor << '.' << SumsInfo . VerMinor << endl
      << endl;

   CRC* CR = new CRC;

   if ( !CR) {
      cerr << "Error:\n"
         << "Not enough memory.\n";

      return;
   }

   int Val = CR -> Read ();

   if (Val != Success) {
      delete CR;

      switch (Val) {
         case FileMissing:
         {
            cerr << "Error:\n"
               << "File with CRC data is missing.\n";

            break;
         }

         case InvalidData:
         {
            cerr << "Error:\n"
               << "Invalid file with CRC data.\n";

           break;
         }
      }

      return;
   }

   char* Str;

   cout << "Enter a text string: ";
   cin >> Str;

   cout << "\nData sum is " << GetDataSum (Str) << endl << endl;

   cout << "Using CCITT CRC type.\n"
      << "\nCRC of '" << Str << "' is " << CR -> Get (Str) << endl << endl;

   cin >> "";

#undef _CRC_CCITT

   cout << "Using CRC 16 type.\n"
      << "\nCRC of '" << Str << "' is " << CR -> Get (Str) << endl;

   cin >> "";
}
