/*  Small compiler
 *
 *  Drafted after the Small-C compiler Version 2.01, originally created
 *  by Ron Cain, july 1980, and enhanced by James E. Hendrix. It is
 *  now adapted to a virtual machine.
 *
 *  This version comes close to a complete rewrite.
 *
 *  Copyright R. Cain, 1980
 *  Copyright J.E. Hendrix, 1982, 1983
 *  Copyright T. Riemersma, 1997, 1998
 */

#if defined(BIT16)
  typedef unsigned short int ucell;     /* only for type casting */
  typedef short int cell;
#else
  typedef unsigned long int ucell;
  typedef long int cell;
#endif

#define PUBLIC_CHAR '@'     /* character that defines a function "public" */
#define CTRL_CHAR   '^'     /* default control character */

#define _def_litmax  500    /* initial size of the literal pool, in "cells" */
#define _numlabels  1000    /* maximum number of internal labels */
#define _linemax 511    /* input line length (in characters) */
#define _namemax  19    /* significant length of symbol name */
#define _stkmax   50    /* stack for nested #includes and other uses */
#define _stgmax  800    /* output staging buffer (size in characters) */
typedef void *stkitem;  /* type of items stored on the stack */

typedef struct {        /* function argument info */
  char name[_namemax+1];
  char ident;           /* _variable, _reference, _refarray or _varargs */
  int tag;              /* argument tag id. */
  char hasdefault;      /* is there a default value? */
  union {
    cell val;
    cell *ptr;
  } defvalue;           /* default value, or pointer to default array */
  int defsize;          /* size of "default" array */
} arginfo;

/*  Symbol table format
 *
 *  The symbol name read from the input file is stored in "name", the
 *  value of "addr" is written to the output file. The address in "addr"
 *  depends on the class of the symbol:
 *      global          offset into the data segment
 *      local           offset relative to the stack frame
 *      label           generated hexadecimal number
 *      function        offset into code segment
 */
typedef struct __symbol {
  char name[_namemax+1];
  cell addr;            /* address or offset (or value for constant) */
  char vclass;          /* _local if "addr" refers to a local symbol */
  char ident;
  char usage;
  int compound;         /* compound level (braces nesting level) */
  int tag;              /* tagname id */
  union {
    int declared;       /* label: how many local variables are declared */
    int idxtag;         /* array: tag of array indices */
  } x;                  /* 'x' for 'extra' */
  union {
    arginfo *arglist;   /* types of all parameters for functions */
    cell array;         /* arrays: dimension */
  } dim;                /* for 'dimension', both functions and arrays */
  struct __symbol *next;
} symbol;


/*  Possible entries for "ident". These are used in the "symbol", "value"
 *  and arginfo structures. Not every constant is valid for every use.
 */
#define _label      0
#define _variable   1   /* cell that has an address and that can be fetched directly (lvalue) */
#define _reference  2   /* _variable, but must be dereferenced */
#define _array      3
#define _refarray   4   /* an array passed by reference (i.e. a pointer) */
#define _arraycell  5   /* array element, cell that must be fetched indirectly */
#define _arraychar  6   /* array element, character from cell from array */
#define _expression 7   /* expression result, has no address (rvalue) */
#define _constexpr  8   /* constant expression */
#define _functn     9
#define _reffunc    10  /* function passed as a parameter */
#define _varargs    11  /* function specified ... as argument(s) */

/*  Possible entries for "usage"
 *
 *  This byte is used as a serie of bits, the syntax is different for
 *  functions and other symbols:
 *
 *  VARIABLE
 *  bits: 0     set 1 if the variable is defined in the source file
 *        1     set 1 if the variable is read in the source file
 *        2     set 1 if the variable is altered (assigned a value)
 *
 *  FUNCTION
 *  bits: 0     set 1 if the function is defined in the source file
 *        1     set 1 if the function is referred to in the source file
 *        2     the function returns a value (or should return a value)
 *        3     function was prototyped
 *        4     function is public
 *        5     function is native
 */
#define _define   0x01
#define _read     0x02
#define _written  0x04
#define _refer    0x02  /* note: _refer == _read */
#define _retvalue 0x04  /* function returns (or should return) a value */
#define _prototyped 0x08
#define _public   0x10
#define _native   0x20
/* _retnone is not stored in the "usage" field of a symbol. It is
 * used during parsing a function, to detect a mix of "return;" and
 * "return value;" in a few special cases.
 */
#define _retnone  0x10

#define _global   0     /* global/local variable/constant class */
#define _local    1

typedef struct {
  symbol *sym;          /* symbol in symbol table, NULL for (constant) expression */
  char ident;           /* _constexpr, _variable, _array, _elemarray,
                         * _expression or _reference */
  cell constval;        /* value of the constant expression (if ident==_constexpr) */
  int tag;              /* tagname id (of the expression) */
} value;

/*  Equate table  */
typedef struct __s_constval {
  char name[_namemax+1];
  cell value;
  struct __s_constval *next;
} constval;

/*  "while" statement queue (also used for "for" and "do - while" loops) */
#define _wqsp    0      /* used to restore stack for "break" and "continue" */
#define _wqloop  1      /* loop start label number */
#define _wqexit  2      /* loop exit label number (jump if false) */
#define _wqsiz   3      /* "while queue" size */
#define _wqtabsz (10*_wqsiz)    /* 10 nested loops and switch statements */

/* macros for code generation */
#define opcodes(n)      ((n)*sizeof(cell))      /* opcode size */
#define opargs(n)       ((n)*sizeof(cell))      /* size of typical argument */

/*  Tokens recognized by lex()
 *
 *  Some of these constants are assigned as well to the variable "lastst"
 */
#define _firsttok 256   /* value of first multi-character operator */
#define _midtok  278    /* value of last multi-character operator */
#define _lasttok 309    /* value of last multi-character match-able token */
/* multi-character operators */
#define __amult  256    /* *= */
#define __adiv   257    /* /= */
#define __amod   258    /* %= */
#define __aadd   259    /* += */
#define __asub   260    /* -= */
#define __ashl   261    /* <<= */
#define __ashru  262    /* >>>= */
#define __ashr   263    /* >>= */
#define __aand   264    /* &= */
#define __axor   265    /* ^= */
#define __aor    266    /* |= */
#define __lor    267    /* || */
#define __land   268    /* && */
#define __leq    269    /* == */
#define __lne    270    /* != */
#define __lle    271    /* <= */
#define __lge    272    /* >= */
#define __shl    273    /* << */
#define __shru   274    /* >>> */
#define __shr    275    /* >> */
#define __inc    276    /* ++ */
#define __dec    277    /* -- */
#define __ellips 278    /* ... */
/* reserved words (statements) */
#define __assert  279
#define __break   280
#define __case    281
#define __char    282
#define __const   283
#define __continue 284
#define __default 285
#define __defined 286
#define __do      287
#define __else    288
#define __enum    289
#define __exit    290
#define __for     291
#define __goto    292
#define __if      293
#define __native  294
#define __new     295
#define __public  296
#define __return  297
#define __sizeof  298
#define __switch  299
#define __while   300
/* compiler directives */
#define __assert_p 301  /* #assert */
#define __define  302
#define __else_p  303   /* #else */
#define __emit_p  304
#define __endif   305
#define __endinput 306
#define __if_p    307   /* #if */
#define __include 308
#define __pragma  309
/* other recognized tokens */
#define __number 310
#define __symbol 311
#define __label  312
#define __string 313
#define __expr   314    /* for assigment to "lastst" only */

/* (reversed) evaluation of staging buffer */
#define _startreorder 1
#define _endreorder   2
#define _exprstart    0xc0      /* top 2 bits set, rest is free */
#define _maxargs      64        /* relates to the bit pattern of _exprstart */

/* codes for ffabort() */
#define _exit           1       /* exit code in PRI */
#define _assertion      2       /* user abort */
#define _stackerror     3       /* stack/heap overflow */
#define _boundserror    4       /* array index out of bounds */
#define _memaccess      5       /* data access error */
#define _invinstr       6       /* invalid instruction */
#define _stackunderflow 7       /* stack underflow */
#define _heapunderflow  8       /* heap underflow */
#define _callbackerr    9       /* no, or invalid, callback */

/* Miscellanious  */
#define _no             0
#define _yes            1
#define _incseg         1       /* if parsing CODE */
#define _indseg         2       /* if parsing DATA */
#define _chkbounds      1       /* bit position in "debug" variable: check bounds */
#define _symbolic       2       /* bit position in "debug" variable: symbolic info */

#if !defined _MAX_PATH
  #define _MAX_PATH     255
#endif

/* function prototypes in SC1.C */
void dumplits(void);
void dumpzero(int count);
int gettag(char *name);
int constexpr(cell *val,int *tag);
void add_constant(char *name,cell val,int vclass,int tag);

/* function prototypes in SC2.C */
void pushstk(stkitem val);
stkitem popstk(void);
void preprocess(void);
int lex(cell *lexvalue,char **lexsym);
void lexpush(void);
void lexclr(void);
int matchtoken(int token);
int tokeninfo(cell *val,char **str);
int needtoken(int token);
int match(char *st,int end);
void stowlit(cell value);
int alphanum(char c);
int ishex(char c);
void delete_symbols(symbol *root,int level,int del_labels);
symbol *findglb(char *name);
symbol *findloc(char *name);
symbol *findconst(char *name);
symbol *addsym(char *name,cell addr,int ident,int vclass,int tag,int usage);
int getlabel(void);
void addwhile(int *ptr);
void delwhile(void);
int *readwhile(int *ptr);
char *itoh(ucell val);

/* function prototypes in SC3.C */
int skim(int *opstr,void (*testfunc)(),int dropval,int endval,int (*hier)(),
         value *lval);
int plnge(int *opstr,int opoff,int (*hier)(value *lval),value *lval);
int plnge1(int (*hier)(value *lval),value *lval);
void plnge2(void (*oper1)(void),int (*hier)(value *lval),
            value *lval1,value *lval2);
int hier14(value *lval1);       /* the highest expression level */
cell calc(cell left,void (*oper)(),cell right);
void expression(int *constant,cell *val,int *tag);

/* function prototypes in SC4.C */
void writetrailer(void);
void addlib(void);
void begcseg(void);
void begdseg(void);
cell nameincells(char *name);
void setfile(char *name,int fileno);
void setline(int line,int fileno);
void setlabel(int index);
void endexpr(void);
void startfunc(void);
void endfunc(void);
void external(char *name,int id);
void defsymbol(char *name,int ident,int class,cell offset);
void rvalue(value *lval);
void address(symbol *ptr);
void store(value *lval);
void fillarray(symbol *sym,cell size,cell value);
void copyarray(symbol *sym,cell size);
void const1(cell val);
void const2(cell val);
void push1(void);
void pushval(cell val);
void pop2(void);
void cmpcase(cell val,int label);
void endcase(void);
void ffcall(symbol *sym,int numargs);
void ffret(void);
void ffabort(int reason);
void ffbounds(cell size);
void jump(char *label);
void jumplabel(int number);
void defstorage(void);
void point(void);
void modstk(int delta);
void setstk(cell value);
void modheap(int delta);
void setheap_pri(void);
void setheap(cell value);
void cell2addr(void);
void cell2addr_alt(void);
void addr2cell(void);
void char2addr(void);
void charalign(void);
void addconst(cell value);

/*  Code generation functions for arithmetic operators.
 *
 *  Syntax: o[u|s|b]_name
 *                  name of operator
 *                 underscore
 *              "u"nsigned operator, "s"igned operator or "b"oth
 *           "o"perator
 */
void os_mult(void); /* multiplication (signed) */
void os_div(void);  /* division (signed) */
void os_mod(void);  /* modulus (signed) */
void ou_mult(void); /* multiplication (unsigned) */
void ou_div(void);  /* division (unsigned) */
void ou_mod(void);  /* modulus (unsigned) */
void ob_add(void);  /* addition */
void ob_sub(void);  /* subtraction */
void ob_sal(void);  /* shift left (arithmetic) */
void os_sar(void);  /* shift right (arithmetic, signed) */
void ou_sar(void);  /* shift right (logical, unsigned) */
void ob_or(void);   /* bitwise or */
void ob_xor(void);  /* bitwise xor */
void ob_and(void);  /* bitwise and */
void os_le(void);   /* less or equal (signed) */
void os_ge(void);   /* greater or equal (signed) */
void os_lt(void);   /* less (signed) */
void os_gt(void);   /* greater (signed) */
void ou_le(void);   /* less or equal (unsigned) */
void ou_ge(void);   /* greater or equal (unsigned) */
void ou_lt(void);   /* less (unsigned) */
void ou_gt(void);   /* greater (unsigned) */
void ob_eq(void);   /* equality */
void ob_ne(void);   /* inequality */

void lneg(void);
void neg(void);
void invert(void);
void inc(value *lval);
void dec(value *lval);
void jmp_ne0(int number);
void jmp_eq0(int number);
void outval(cell val, int newline);

/* function prototypes in SC5.C */
void error(int number,...);

/* function prototypes in SC6.C */
void assemble(FILE *fout,FILE *fin);

/* function prototypes in SC7.C */
void stgmark(char mark);
void stgwrite(char *st);
void stgout(int index);
void stgstring(char *start,char *end);
void stgdel(int index,cell code_index);
int stgget(int *index,cell *code_index);
void stgset(int onoff);
void stgopt(char *start,char *end);
void symline(char *start);
void writef(char *st);

/* external variables (defined in sc.c) */
extern symbol loctab;       /* local symbol table */
extern symbol glbtab;       /* global symbol table */
extern cell *litq;          /* the literal queue */
extern char pline[];        /* the line read from the input file */
extern char *lptr;          /* points to the current position in "pline" */
extern constval mod_tab;    /* module table */
extern constval tagname_tab;/* tagname table */
extern char *inpfname;      /* name of the file currently read from */
extern char outfname[];     /* output file name */
extern char binfname[];     /* binary file name */
extern char errfname[];     /* error file name */
extern char includepath[];  /* directory for system include files */

extern char ctrlchar;       /* the control character (or escape character) */
extern int wq[];            /* "while queue", internal stack for nested loops */
extern int *wqptr;          /* pointer to next entry */
extern int litidx;          /* index to literal table */
extern int litmax;          /* current size of the literal table */
extern int stgidx;          /* index to the staging buffer */
extern int labnum;          /* number of (internal) labels */
extern int staging;         /* true if staging output */
extern int rettype;         /* the type that a "return" expression should have */
extern symbol *curfunc;     /* pointer to current function */
extern cell declared;       /* number of local cells declared */
extern cell glb_declared;   /* number of global bytes declared */
extern cell code_idx;       /* number of bytes with generated code */
extern int ncmp;            /* number of active (open) compound statements */
extern int ntv_funcid;      /* incremental number of native function */
extern int errflag;         /* 1 after first error in statement, -1 if no
                             * error on current line, but errors were found */
extern int errnum;          /* number of errors */
extern int warnnum;         /* number of warnings */
extern int lastst;          /* last executed statement type */
extern int listing;         /* create .ASM file? */
extern int verbose;         /* display extra information while compiling? */
extern int debug;           /* by default: full debug info */
extern int charbits;        /* number of bits for a character */
extern int curseg;          /* 1 if currently parsing CODE, 2 if parsing DATA */
extern cell stksize;        /* stack size */
extern int freading;        /* is there an input file ready for reading? */
extern int fline;           /* the line number in the current file */
extern int fnumber;         /* the file number in the file table (debugging) */
extern int fcurrent;        /* current file being processed (debugging) */
extern int intest;          /* true if inside a test */
extern int sideeffect;      /* true if an expression causes a side-effect */
extern int stmtindent;      /* current indent of the statement */

extern FILE *inpf;          /* file read from */
extern FILE *outf;          /* file written to */

