/*  Command-line shell for the "Small" Abstract Machine.
 *
 *  Copyright (c) ITB CompuPhase, 1997, 1998
 *  This file may be freely used. No warranties of any kind.
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "amx.h"

#define CONSOLE
#define FIXEDPOINT

void core_Init(void);   /* two functions from AMX_CORE.C */
void core_Exit(void);

void *loadprogram(AMX *amx,char *filename)
{
  FILE *fp;
  AMX_HEADER hdr;
  void *program = NULL;

  if ((fp = fopen(filename,"rb")) != NULL) {
    fread(&hdr, sizeof hdr, 1, fp);
    if ((program = malloc((int)hdr.stp)) != NULL) {
      rewind(fp);
      fread(program, 1, (int)hdr.size, fp);
      fclose(fp);
      if (amx_Init(amx,program,NULL) == AMX_ERR_NONE)
        return program;
      free(program);
    } /* if */
  } /* if */
  return NULL;
}


int main(int argc,char *argv[])
{
extern AMX_NATIVE_INFO core_Natives[];
#if defined(CONSOLE)
  extern AMX_NATIVE_INFO console_Natives[];
#endif
#if defined(FIXEDPOINT)
  extern AMX_NATIVE_INFO fixed_Natives[];
#endif

  AMX amx;
  cell ret;
  int err;
  void *program;
  clock_t start,end;

  if (argc != 2 || (program = loadprogram(&amx,argv[1])) == NULL) {
    printf("Usage: SRUN <filename>\n\n"
           "The filename must include the extension\n");
    return 1;
  } /* if */

  err = amx_Register(&amx, core_Natives, -1);
  #if defined(CONSOLE)
    core_Init();
    err = amx_Register(&amx, console_Natives, -1);
  #endif
  #if defined(FIXEDPOINT)
    err = amx_Register(&amx, fixed_Natives, -1);
  #endif

  start=clock();
  if (err == AMX_ERR_NONE)
    err = amx_Exec(&amx, &ret, AMX_EXEC_MAIN, 0);
  end=clock();

  if (err != AMX_ERR_NONE)
    printf("Run time error %d on line %ld\n", err, amx.curline);
  else if (ret != 0)
    printf("%s returns %ld\n", argv[1], (long)ret);

  free(program);
  #if defined(CONSOLE)
    core_Exit();
  #endif

  printf("Run time: %.2f seconds",(double)(end-start)/CLK_TCK);
  return 0;
}

