/*- WAVDIR -- display header data of multiple .WAV files specified on the
 * command line.  Compile with Microsoft C/C++ and link with SETARGV.OBJ.
 * The WaveHeader structure was "stolen" from `vavedit' -- thanks, Aaron!
 * Copyright (c) 1996 Luchezar Georgiev.  This source is a public domain.
 */
#include <stdio.h>
#include <stdlib.h>

typedef unsigned long   u_long;
typedef unsigned short  u_short;

#define RIFF_ID         0x46464952
#define WAVE_ID         0x45564157
#define FMT             0x20746D66
#define DATA            0x61746164
#define PCM_CODE        1
#define WAVE_MONO       1
#define WAVE_STEREO     2

typedef struct _waveheader {
    u_long      main_chunk;     /* 'RIFF' */
    u_long      length;         /* filelen */
    u_long      chunk_type;     /* 'WAVE' */

    u_long      sub_chunk;      /* 'fmt ' */
    u_long      sc_len;         /* length of sub_chunk, =16 */
    u_short     format;         /* should be 1 for PCM-code */
    u_short     modus;          /* 1 Mono, 2 Stereo */
    u_long      sample_fq;      /* frequency of sample */
    u_long      byte_p_sec;
    u_short     byte_p_spl;     /* samplesize; 1 or 2 bytes */
    u_short     bit_p_spl;      /* 8, 12 or 16 bit */

    u_long      data_chunk;     /* 'data' */
    u_long      data_length;    /* data length */
} WaveHeader;

int main(int argc, char **argv)
{
    char drv[3], path[100], name[9], ext[5];
    int i;
    FILE *file;
    WaveHeader hdr;

    printf("Filename  Format   Modus  Frequency  Bits   Length  Samples   Time\n");
    printf("--------  ------  ------  ---------  ----  -------  -------  -----\n");
    for (i = 1; i < argc; i++) {
	if ((file = fopen(argv[i], "rb")) != NULL) {
            if ((fread(&hdr, sizeof(hdr), 1, file)) == 1) {
                _splitpath(argv[i], drv, path, name, ext);
                if (hdr.main_chunk == RIFF_ID  &&  hdr.chunk_type == WAVE_ID
                    &&  hdr.sub_chunk == FMT  &&  hdr.data_chunk == DATA) {
                    printf (
                        "%-8s   %3s    %6s  %5ld Hz    %2d  %6ld K  %7ld  %3d s\n",
                        name,
                        hdr.format == PCM_CODE ? "PCM" : "???",
                        hdr.modus == WAVE_MONO ? "Mono" : "Stereo",
                        hdr.sample_fq,
                        hdr.bit_p_spl,
                        hdr.length / 1024 + 1,
			hdr.data_length / hdr.modus / (hdr.bit_p_spl / 8),
                        (u_short)(hdr.data_length / hdr.sample_fq + 1)
                    );
                }
            }
            fclose(file);
        }
    }
    return argc - 1;
}
