/*
 *  At last!  A true random Murphy's Law generator C source!  :-)
 *  Copyright (c) MCMXCIV by L. Georgiev <lucho@midi.tu-varna.bg>
 *
 *  Murphy's Laws File Format:  plain text, using "tildes" (~) as
 *  a law separator.  Laws are printed AS THEY ARE, incl. newline
 *  characters.
 *
 *  Usage:  tell <file>
 */

#define MIN_LAWS 50	/* hope no one will be that dumb to use less */
#define MAX_LAWS 5000	/* and no one will be that crazy to use more */

#include <stdio.h>
#include <stdlib.h>
#ifdef MSDOS  /* Use at least 12 KB of stack. Don't try to make a .COM file */
    #include <sys/types.h>
    #include <io.h>
#else	      /* Linux assumed -- change for a different Unix accordingly */
    #include <unistd.h>
#endif
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>

int main(int argc, char **argv)
{
	int fd;
	unsigned long size;
	char *buf;
	unsigned n = 0, i, law[MAX_LAWS];
	struct stat stat_buf;

	argc = argc; /* <:-) */
	if ((fd = open( argv[1], O_RDONLY )) == -1) {
		fprintf(stderr, "Can't open \"%s\" for reading\n", argv[1]);
		exit(-1);
	}
	fstat(fd, &stat_buf);
	size = stat_buf.st_size;
	if ((buf = (char *)malloc((size_t)(size + 1))) == NULL) {
		fprintf(stderr, "Can't allocate %ld bytes of memory\n", size+1);
		exit(-2);
	}
	if (read(fd, buf, (int)size) == -1) {
		fprintf(stderr, "Can't read \"%s\"\n", argv[1]);
		exit(-3);
	}
	/* Remember all law positions */
	law[n++] = n = i = 0;
	while ((long)i < size) {
		if (buf[i++] == '~') {
			law[n++] = i;	/* point to next law */
			if (n == MAX_LAWS) {
				fprintf(stderr, "Too many laws in \"%s\"\n",
					argv[1]);
				exit(-4);
			}
		}
	}
	if (n < MIN_LAWS) {
		fprintf(stderr, "Too few laws in \"%s\"\n", argv[1]);
		exit(-5);
	}
	srand((unsigned)time(NULL));
	i = rand() % n;
	if (i == n - 1)
		buf[size] = '\0';
	else
		buf[law[i+1]-1] = '\0';	/* replace '~' */
	puts(buf + law[i]);
	free(buf);
	close(fd);
	return(0);
}
