/*
 * That should be a quite fast way to search strings in binaries <g>.
 * Written on 17-Nov-94 by Luchezar Georgiev <lucho@midi.tu-varna.bg>
 */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <io.h>

#define BUF_SIZE 0xC000  /* can't be much more for a .COM file */
#define MIN_LEN  4

void main (int argc, char **argv)
{
    char *buf, *end;
    register char *head, *tail;
    int fd;

    /* suppress that warining */
    argc = argc;
    if ((buf = (char *)malloc( (size_t)BUF_SIZE )) == NULL)
	fprintf (stderr, "Can't allocate %u bytes of memory\n", BUF_SIZE);
    else if ((fd = _open( argv[1], _O_RDONLY | _O_BINARY)) == -1)
	fprintf (stderr, "Can't open \"%s\"\n", argv[1]);
    else do
    {
	head = tail = buf;
	end = buf + _read( fd, (void *)buf, BUF_SIZE );

	/* caterpillar-walk till the end of buffer */
	while (tail < end) {
	    if (tail - head >= MIN_LEN) {
		*tail = '\0';
		puts(head);
	    }
	    for (head = tail; !isprint((int)*head); head++)
		;
	    for (tail = head; isprint((int)*tail); tail++)
		;
	}
	if (_eof(fd)) {
	    if (head < end) {
		tail = end;
		if (tail - head >= MIN_LEN) {
		    *tail = '\0';
		    puts(head);
		}
	    }
	    return;
	}
	else if (head < end)
	    _lseek( fd, head - end, SEEK_CUR ); /* re-read that */
    } while(!_eof(fd));
}
