/* LF.C removes Carriage Returns from a text file (CRLF --> LF)
 *
 * (COPY1.C used as a template)
 */

#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <fcntl.h>          /* O_ constant definitions */
#include <sys\types.h>
#include <sys\stat.h>       /* S_ constant definitions */
#include <malloc.h>
#include <errno.h>

int text2bin( char *source, char *destin );     /* Prototype */

void main( int argc, char *argv[] )
{
    if( argc == 3 ) {
	if( text2bin( argv[1], argv[2] ) )
	    printf("LF failed\n");
    }
    else    {
       printf("Usage: LF <source> <target>\n");
       printf("Replaces each CR-LF sequence (source) with single LF (target)");
    }
}

/* Copies text-mode opened file to binary-mode opened one (both specified by
 * path). Dynamically allocates memory for the file buffer. Prompts before
 * overwriting existing file. Returns 0 if successful, else an error number.
 */
int text2bin( char *source, char *target )
{
    char *buf;
    int hsource, htarget, ch;
    unsigned count = 0xff00;

    /* Open source file and create target, overwriting if necessary. */
    if( (hsource = open( source, O_TEXT | O_RDONLY )) == - 1 )
	return errno;
    htarget = open( target, O_BINARY | O_WRONLY | O_CREAT | O_EXCL,
			    S_IREAD | S_IWRITE );
    if( errno == EEXIST )
    {
	cputs( "Target exists. Overwrite? " );
	ch = getch();
	if( (ch == 'y') || (ch == 'Y') )
	    htarget = open( target, O_BINARY | O_WRONLY | O_CREAT | O_TRUNC,
				    S_IREAD | S_IWRITE );
	printf( "\n" );
    }
    if( htarget == -1 )
	return errno;

    if( filelength( hsource ) < (long)count )
	count = (int)filelength( hsource );

    /* Dynamically allocate a large file buffer. If there's not enough
     * memory for it, find the largest amount available on the near heap
     * and allocate that. This can't fail no matter what the memory model.
     */
    if( (buf = (char *)malloc( (size_t)count )) == NULL )
    {
	count = _memmax();
	if( (buf = (char *)malloc( (size_t)count )) == NULL )
	    return ENOMEM;
    }

    /* Read-write until there's nothing left. */
    while( !eof( hsource ) )
    {
	/* Read and write input. */
	if( (count = read( hsource, buf, count )) == -1 )
	    return errno;
	if( (count = write( htarget, buf, count )) == - 1 )
	    return errno;
    }

    /* Close files and release memory. */
    close( hsource );
    close( htarget );
    free( buf );
    return 0;
}
