#include <stdio.h>
#include <stdlib.h>
#include <bios.h>

int main (int argc, char **argv)
{
    long timeval, diff;
    char **endptr;

    if (argc != 2)  {
	printf("Usage: GMT [+]<hours>\n");
	printf("`hours\' is the difference between the local time and GMT\n");
	printf("Warning: To be executed only once (e.g. in AUTOEXEC.BAT)!\n");
	printf("Note: For use in the Eastern Hemisphere only.");
	return -1;
    }
    _bios_timeofday(_TIME_GETCLOCK, &timeval);
    if ((diff = strtol(argv[1], endptr, 10)) >= 12  ||	diff < 0)	  {
	printf("Illegal time difference: %s\n", argv[1]);
	return -2;
    }
    timeval += diff * 65543L;
    _bios_timeofday(_TIME_SETCLOCK, &timeval);
    return 0;
}
