/* This is a filter for dumb printers which can't handle BACKSPACE characters.
 * Everything found after BS (ASCII 8) is memorized.  When the line ends, a CR
 * (ASCII 13) is issued, and the memorized characters are printed.  Useful for
 * underlining and overstriking.  Examples of dumb printers are the DEC LA-170
 * and my M88 (can't understand any control characters but CR and LF... ;-G ).
 *
 * By Luchezar Georgiev, Bulgaria (still pending for a cheap e-mail account :)
 */

#include <stdio.h>

void main()
{
	char c, buf[300];
	int i, repeat;

	while(1) {
		i = repeat = 0;
		while ((c = getchar()) != '\n') {
			switch(c) {
				case 8:
					repeat = 1;
					buf[i] = getchar();
					break;
				case EOF:
					return;
				default:
					putchar(c);
					buf[++i] = ' ';
			}
		}
		buf[++i] = 0;
		if(repeat) {
			putchar(13);
			puts(buf+sizeof(char));
		} else {
			putchar(10);
		}
	}
}
