;       Scour.ASM version 1.4
comment 
by Roedy Green
This program is copyrighted but may be used freely
for any purpose except military.
Scour C:\MySub\MyFile.Blk

Used on Forth/Abundance source code files.
Scours any Nulls chr$(0) from the file as these
act like ;S but are invisible.  Any nulls found
are quietly converted to spaces.
The program now displays a . for each block containing nulls.
The file should be a multiple of 1024 bytes long.
*

Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.4 1998 November 8
- embed Barker address

Version 1.3 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.2 1993 June 7
- embed new address and phone number

Version 1.1 1990 Dec 5
- space display when nulls found
; 

; M A C R O S

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM

;======

SAY     MACRO   Msg
;       display message on screen
        LEA     DX,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
        MOV     AH,09h
        INT     21h
        ENDM

;======================================


CODE    SEGMENT PARA

        ASSUME  CS:CODE,DS:CODE
        ORG     100H

Scour    PROC    FAR

START:
;=============================
;   PARSE THE FILENAME          ; counted string at HEX 80
                                ; contains command line.
                                ; Name of file we want is
                                ; preceeded by unwanted spaces.
                                ; It is missing a trailing null.
        XOR     CH,CH
        MOV     CL,DS:80h
        MOV     BX,CX
        MOV     BYTE PTR [BX+81h],0     ; append the null
        MOV     AL,20h
        MOV     DI,81h
        REPE    SCASB           ; scan for first non blank
        DEC     DI              ; DI points one past it.
;=============================
;  OPEN THE FILE
        MOV     DX,DI           ; DS:DX point to file
        MOV     AX,03D02h       ; DOS open file
        INT     21h
        JC      BAD
        MOV     BX,AX           ; save handle

;=============================
;  MAKE SURE EVEN MULTIPLE OF 1024 BYTES
        XOR     CX,CX
        MOV     DX,CX
        MOV     AX,4202H        ; seek to end of file
        INT     21h
        AND     AX,1024d-1      ; DX:AX has file length
        JZ      IsEven
        SAY     NotForthMsg     ; Not multiple of 1024
        JMP     CLOSE
IsEven:
;       File is multiple of 1024 bytes long,  all is ok.
        XOR     CX,CX
        MOV     DX,CX
        MOV     AX,4200H        ; seek to start of file
        INT     21h
        JC      CLOSE
;=============================
MainLoop:
;=============================
;  READ ONE BLOCK
        MOV     CX,1024d        ; 1024 bytes to read
        MOV     DX,OFFSET BUFFER
        MOV     AH,3Fh          ; DOS read
        INT     21h
        JC      CLOSE
        CMP     AX,CX           ; bytes read = 1024?
        JNE     CLOSE
;=============================
        MOV     BYTE PTR ChFlag,0 ; flag, no replacements yet
        MOV     CX,1024d
        MOV     AX,2000h        ; replace null-0 with space-20
        MOV     DI,offset buffer
ScanLoop:
        JCXZ    ScanDone
        REPNE   SCASB           ; scan for first null
        JNE     ScanDone        ; DI points one past it.
        MOV     [DI-1],AH       ; replace with blank
        MOV     BYTE PTR ChFlag,-1 ; note that replacement done
        JMP     ScanLoop
ScanDone:
        TEST    BYTE PTR ChFlag,1
        JZ      NoChanges
        Say     FoundMsg        ; a block was changed, emit a dot
NoChanges:
;=============================
;  WRITE THE BLOCK BACK
        MOV     CX,-1d
        MOV     DX,-1024d
        MOV     AX,4201H        ; seek back 1024 bytes over top
                                ; what just read
        INT     21h
        JC      CLOSE

        MOV     CX,1024d        ; 1024 bytes to write
        MOV     DX,OFFSET BUFFER
        MOV     AH,40h          ; DOS write
        INT     21h
        JC      CLOSE
        JMP     MainLoop
;=============================
BAD:
;  COMPLAIN ABOUT THE FILE
        SAY     BadMsg          ; if died before file opened
        JMP     QUIT
;=============================
CLOSE:
;  CLOSE THE FILE
        MOV     AH,3EH          ; DOS close
        INT     21H
QUIT:
        MOV     AX,4C00H        ; EXIT
        INT     21H
;=============================

ChFlag  DB      0               ; true if there was a null changed to
                                ; space in this block


FoundMsg LABEL BYTE
        DB ".$"                 ; each . represents one block with nulls

BadMsg  LABEL BYTE
        DB 07h
        DB "Cannot find this file.  Perhaps it is read-only.$"

NotForthMsg     LABEL   BYTE
        DB 07h
        DB "Probably not a Forth/Abundance source file, improper length.$"

        EVEN
BUFFER  LABEL   WORD            ; will actually be 1024 bytes long

Scour   ENDP

CopyrightMsg    label byte      ; does not display
        CR
        DB      ' Scour 1.4 ۲'
        CR
        DB      'Freeware to convert nulls to spaces in Forth *.BLK files.'
        CR
        DB      'usage:  SCOUR  C:\Mysub\MyProg.Blk'
        CR
        DB      'Copyright (c) 1990-1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        EOS


CODE    ENDS

        END START
