unit scPlugin;
interface

const
{ PCOMMON: Plugin common constants }
  PCOMMON_MAXSTRLEN             =       251;
  PCOMMON_SEPARATOR             =       '|';  //  menu item delimiter

{ PERROR: Plugin error codes }
  PERROR_SUCCESS                = $00000000;  //  operation suceeded
  PERROR_CUSTOM                 = $00000001;  //  unknown error
  PERROR_READONLY               = $00000002;  //  object is readonly
  PERROR_NOTAPPLICAPABLE        = $00000003;  //  operation is not applicapable in current context
  PERROR_INVALIDFORMAT          = $00000004;  //  bad data format
  PERROR_OBJECT_NOTEXIST        = $00000005;  //  object does not exists in current context
  PERROR_PROPERTY_NOTEXIST      = $00000006;  //  property does not exist in current context
  PERROR_NORECORDS              = $00000007;  //  list is empty
  PERROR_UNSUFF_SPACE           = $00000008;  //  not enough space
  PERROR_KEYEXISTS              = $00000009;  // (working with AddInfo) specified key already exists
  PERROR_OBJECTNOTACCESSIBLE    = $0000000A;  //  object is not accessible now
  PERROR_NOCURRENTITEM          = $0000000B;  //  object doesn't contain any items

{ POBJECT: Plugin objects }
  POBJECT_NONE                  = $00000000;  //  object not specified
  POBJECT_APPLICATION           = $00000001;  //  application in common
  POBJECT_MAINWINDOW            = $00000002;  //  main application window
  POBJECT_PRODUCTLIST           = $00000003;  //  product list in main window
  POBJECT_USERLIST              = $00000004;  //  user list in main window
  POBJECT_TODOLIST              = $00000005;  //  todo list in main window
  POBJECT_SITELIST              = $00000006;  //  site list in main window
  POBJECT_PRODUCT               = $00000007;  //  product window
  POBJECT_USER                  = $00000008;  //  user window
  POBJECT_TODO                  = $00000009;  //  todo window
  POBJECT_SITE                  = $0000000A;  //  site window
  POBJECT_ABOUT                 = $0000000B;  //  about window
  POBJECT_PARAMWINDOW           = $0000000C;  //  parameters window
  
{ PMASK: Plugin property masks (modifiers) }
  PMASK_NOTMASKED               = $00000000;  //  identifies empty mask (no modifier)
  PMASK_MASK                    = $08000000;  //  identifier IS masked
  PMASK_OLDITEM                 = $08000000;  //  identifies existing item in the object
  PMASK_ITEMCOUNT               = $08000000;  //  listbox items count in parameter window
  PMASK_NEWITEM                 = $0C000000;  //  identifies new item in the object
  PMASK_ARCHIVE                 = $08000000;  //  shareware archive
  PMASK_REGISTRATOR             = $0C000000;  //  shareware registrator
  PMASK_VERSION                 = $0A000000;  //  product version

{ PPROPERTY: Plugin properties }
  PPROPERTY_NONE                = $00000000;  //  property not specified
  PPROPERTY_MENUITEM            = $00000001;  //  menu item
  PPROPERTY_WORKPLACEID         = $00000003;  //  object workplace ID
  PPROPERTY_ID                  = $00000004;  //  object ID
  PPROPERTY_TITLE               = $00000005;  //  object title
  PPROPERTY_LASTUPDATE          = $00000006;  //  last time object was updated
  PPROPERTY_COMMENT             = $00000007;  //  object comments
  PPROPERTY_ADDINFO             = $00000008;  //  plugin own data
  PPROPERTY_HASFOCUS            = $00000009;  //  object is currently focused
  PPROPERTY_COUNTRYID           = $0000000A;  //  country ID
  PPROPERTY_COUNTRYNAME         = $0000000B;  //  country name
  PPROPERTY_FIRSTNAME           = $0000000C;  //  user first name
  PPROPERTY_MIDDLENAME          = $0000000D;  //  user middle name
  PPROPERTY_LASTNAME            = $0000000E;  //  user last name
  PPROPERTY_COMPANY             = $0000000F;  //  company name
  PPROPERTY_POSITION            = $00000010;  //  user position
  PPROPERTY_STATENAME           = $00000011;  //  state/province name
  PPROPERTY_CITY                = $00000012;  //  city name
  PPROPERTY_ZIP                 = $00000013;  //  ZIP
  PPROPERTY_STREET              = $00000014;  //  street address
  PPROPERTY_POCTYPE1            = $00000015;  //  POC1 type
  PPROPERTY_POC1                = $00000016;  //  POC1 URL
  PPROPERTY_POCTYPE2            = $00000017;  //  POC2 type
  PPROPERTY_POC2                = $00000018;  //  POC2 URL
  PPROPERTY_PRODUCTTITLE        = $00000019;  //  product title
  PPROPERTY_TYPE                = $0000001A;  //  object type
  PPROPERTY_VERSIONWORKPLACEID  = $0000001B;  //  version workplace ID
  PPROPERTY_VERSIONID           = $0000001C;  //  version ID
  PPROPERTY_STATE               = $0000001D;  //  object state
  PPROPERTY_PRIORITY            = $0000001E;  //  todo priority
  PPROPERTY_REPORTEDWORKPLACEID = $0000001F;  //  user, reported the todo - workplace ID
  PPROPERTY_REPORTEDID          = $00000020;  //  user, reported the todo - user ID
  PPROPERTY_REPORTEDON          = $00000021;  //  user, reported the todo - report date
  PPROPERTY_FIXEDWORKPLACEID    = $00000022;  //  user, fixed    the todo - workplace ID
  PPROPERTY_FIXEDID             = $00000023;  //  user, fixed    the todo - user ID
  PPROPERTY_FIXEDON             = $00000024;  //  user, fixed    the todo - fix date
  PPROPERTY_VERIFIEDWORKPLACEID = $00000025;  //  user, verified the todo - workplace ID
  PPROPERTY_VERIFIEDID          = $00000026;  //  user, verified the todo - user ID
  PPROPERTY_VERIFIEDON          = $00000027;  //  user, verified the todo - verification date
  PPROPERTY_VERSIONNUMBER       = $00000028;  //  version number
  PPROPERTY_SUPPORTTYPE         = $00000029;  //  techsupport   URL type
  PPROPERTY_SUPPORTPOC          = $0000002A;  //  techsupport   URL
  PPROPERTY_UPLOADTYPE          = $0000002B;  //  upload page   URL type
  PPROPERTY_UPLOADPOC           = $0000002C;  //  upload page   URL
  PPROPERTY_DOWNLOADTYPE        = $0000002D;  //  download page URL type
  PPROPERTY_DOWNLOADPOC         = $0000002E;  //  download page URL
  PPROPERTY_HOMETYPE            = $0000002F;  //  homepage      URL type
  PPROPERTY_HOMEPOC             = $00000030;  //  homepage      URL
  PPROPERTY_REPORTEDNAME        = $00000031;  //  who reported the bug - name
  PPROPERTY_FIXEDNAME           = $00000032;  //  who fixed    the bug - name
  PPROPERTY_VERIFIEDNAME        = $00000033;  //  who verified the bug - name
  PPROPERTY_POCTYPE3            = $00000034;  //  POC3 type
  PPROPERTY_POC3                = $00000035;  //  POC3 URL
  PPROPERTY_COUNT               = $00000036;  //  Number of items in object
  PPROPERTY_CURRITEM            = $00000037;  //  Number of current object item
  PPROPERTY_PRODUCTWORKPLACEID  = $00000038;  //  product workplace ID
  PPROPERTY_PRODUCTID           = $00000039;  //  product ID
  PPROPERTY_QTY                 = $0000003F;  //  quantity
  PPROPERTY_PAYED               = $00000040;  //  how much payed
  PPROPERTY_PURCHASEDON         = $00000041;  //  date of purchase
  PPROPERTY_PAYMETHODWORKPLACEID= $00000042;  //  payment method workplace id
  PPROPERTY_PAYMETHODID         = $00000043;  //  payment method id
  PPROPERTY_PAYMETHODNAME       = $00000044;  //  payment method name
  PPROPERTY_REGNUMBER           = $00000045;  //  registration number
  PPROPERTY_ORDERID             = $00000046;  //  order ID
  PPROPERTY_FOUNDWORKPLACEID    = $00000047;  //  where product was found? workplace ID
  PPROPERTY_FOUNDID             = $00000048;  //  where product was found? ID
  PPROPERTY_FOUNDNAME           = $00000049;  //  where product was found? name
  PPROPERTY_DLOADEDWORKPLACEID  = $0000004A;  //  where product was downloaded? workplace ID
  PPROPERTY_DLOADEDID           = $0000004B;  //  where product was downloaded? ID
  PPROPERTY_DLOADEDNAME         = $0000004C;  //  where product was downloaded? name
  PPROPERTY_REGISTEREDWORKPLACEID = $0000004D;//  where product was registered? workplace ID
  PPROPERTY_REGISTEREDID        = $0000004E;  //  where product was registered? ID
  PPROPERTY_REGISTEREDNAME      = $0000004F;  //  where product was registered? name
  PPROPERTY_PRODUCTPK           = $00000050;  //  product        primary key. Reguires WorkplaceID and ID values both in pczParam parameter in "xxx|xxx" format
  PPROPERTY_VERSIONPK           = $00000051;  //  version        primary key. Reguires WorkplaceID and ID values both in pczParam parameter in "xxx|xxx" format
  PPROPERTY_PAYMETHODPK         = $00000052;  //  payment method primary key. Reguires WorkplaceID and ID values both in pczParam parameter in "xxx|xxx" format
  PPROPERTY_FOUNDPK             = $00000053;  //  site           primary key. Reguires WorkplaceID and ID values both in pczParam parameter in "xxx|xxx" format
  PPROPERTY_DLOADEDPK           = $00000054;  //  site           primary key. Reguires WorkplaceID and ID values both in pczParam parameter in "xxx|xxx" format
  PPROPERTY_REGISTEREDPK        = $00000055;  //  site           primary key. Reguires WorkplaceID and ID values both in pczParam parameter in "xxx|xxx" format
  PPROPERTY_EDITURL             = $00000056;  //  product upload edit page (URL)
  PPROPERTY_PROGRAMID           = $00000057;  //  program ID/username in product upload
  PPROPERTY_PASSWORD            = $00000058;  //  password in product upload
  PPROPERTY_SUBVERSION          = $00000059;  //  subVersion: alpha, beta, gamma, release, etc
  PPROPERTY_RELEASEDATE         = $0000005A;  //  version release date
  PPROPERTY_ICON                = $0000005B;  //  product icon handle
  PPROPERTY_PRICE               = $0000005C;  //  price of the product
  PPROPERTY_PK                  = $0000005D;  //  object's primary key. Reguires WorkplaceID and ID values both in pczParam parameter in "xxx|xxx" format
  PPROPERTY_LANGUAGE            = $0000005E;  //  current language
  PPROPERTY_USERS               = $00000060;  //  users visible?
  PPROPERTY_PRODUCTS            = $00000061;  //  products visible?
  PPROPERTY_TODO                = $00000062;  //  todo visible?
  PPROPERTY_SITES               = $00000063;  //  sites visible?
  PPROPERTY_ERRORSTRING         = $00000064;  //  Error message by code (requires error code in iCookie parameter)
  PPROPERTY_ABOUTPLUGIN         = $00000065;  //  Plugin info in about box
  PPROPERTY_GENERAL             = $00000066;  //  general page in parameter window
  PPROPERTY_COUNTRY             = $00000067;  //  parameter window country page
  PPROPERTY_PRODUCT             = $00000068;  //  parameter window product page
  PPROPERTY_PAYMETHOD           = $00000069;  //  parameter window payment method page
  PPROPERTY_ADV                 = $0000006A;  //  parameter window advertisment page
  PPROPERTY_SITE                = $0000006B;  //  parameter window site page
  PPROPERTY_USER                = $0000006C;  //  parameter window user page
  PPROPERTY_DATE                = $0000006D;  //  date parameter in parameter window
  PPROPERTY_DATERANGE           = $0000006F;  //  date range parameter in parameter window
  PPROPERTY_PURCHASETYPE        = $00000070;  //  purchase type parameter in parameter window
  PPROPERTY_VERSTATUS           = $00000071;  //  version status parameter in parameter window
  PPROPERTY_TODOSTATE           = $00000072;  //  todo state parameter in parameter window
  PPROPERTY_TODOTYPE            = $00000073;  //  todo type parameter in parameter window
  PPROPERTY_VERSION             = $00000074;  //  version parameter in parameter window
  PPROPERTY_DBDIRECTORY         = $00000075;  //  Shareware Centrum database directory

//PACTION : Plugin actions
  PACTION_NONE                  = $00000000;  //  action not specified
  PACTION_INSERT                = $00000001;  //  insert something
  PACTION_DELETE                = $00000002;  //  delete something
  PACTION_UPDATE                = $00000003;  //  update something
  PACTION_SETHINT               = $00000004;  //  set menu item hint
  PACTION_SETVISIBLE            = $00000005;  //  set visible to true/false (according to pczParam parameter)
  PACTION_SETENABLED            = $00000006;  //  set enable  to true/false (according to pczParam parameter)
  PACTION_SETCHECKED            = $00000007;  //  set checked to true/false (according to pczParam parameter)
  PACTION_SETSHORTCUT           = $00000008;  //  sets menu item shortcut
  PACTION_GETDATA               = $00000009;  //  retrieves data from host object
  PACTION_SETDATA               = $0000000A;  //  writes data to host object
  PACTION_SETFOCUS              = $0000000B;  //  object got  focus
  PACTION_KILLFOCUS             = $0000000C;  //  object lost focus
  PACTION_ROWCHANGED            = $0000000D;  //  list row changed
  PACTION_BEFORESAVE            = $0000000E;  //  before object is saved
  PACTION_AFTERSAVE             = $0000000F;  //  after  object is saved
  PACTION_BEFOREDELETE          = $00000010;  //  before object is deleted
  PACTION_AFTERDELETE           = $00000011;  //  after  object is deleted
  PACTION_CHANGED               = $00000012;  //  object changed
  PACTION_LANGCHANGED           = $00000013;  //  user changed interface language
  PACTION_LOADEDFROM            = $00000014;  //  iCookie parameter contains pointer to the DLL path
  PACTION_SAVESETTINGS          = $00000015;  //  user requested to save interface settings
  PACTION_REFRESHTABLES         = $00000016;  //  pluging request host to refresh all database tadles
  PACTION_CREATE                = $00000017;  //  create an object

{ PNOTIFY: Plugin notifications }
  PACTION_OPENPLUGIN            = $00000017;  //  plugin is being loaded.   Use this notification to perform initialization routines if needed
  PACTION_CLOSEPLUGIN           = $00000018;  //  plugin is being unloaded. Use this notification to perform finalization   routines if needed

{ Plugin function types }
type

{=======================================}
//PluginResponse procedure is used to
//transfer function pointers from plugin
//to host application
  TPluginResponse = procedure;
{=======================================}

{=======================================}
//QueryHost function is used by plugins to query
//host application to perform actions
  TQueryHost  = function  (iObject   : Integer;
                           iProperty : Integer;
                           iAction   : Integer;
                         pczParam    : PChar;
                           iCookie   : Integer) : Integer;
{=======================================}

{=======================================}
//NotifyPlugin procedure is used by the host
//application to notify pluginsabout different events
  TNotifyPlugin  = procedure (iSender   : Integer;
                              iAction   : Integer;
                              iCookie   : Integer);
{=======================================}

implementation

end.
