unit main;
interface
uses Windows, scPlugin, SysUtils, Forms, Dialogs, Lang, Graphics;

const
  PROM_KEYNAME  = 'remind to pay';
  PROM_MENUNAME = 'Remind to register';

  PURCHTYPE_CUSTOM             = 0;
  PURCHTYPE_TRIAL              = 4;

var
  QueryHost : TQueryHost;
  sDLL      : String;
  Translator: TLanguage;
  ABitmap   : TBitmap;

function   Payable : Boolean;
function   GetPromissed : Boolean;
procedure  SetPromissed(bValue : Boolean);
procedure  TogglePromissed;
procedure  ListPromissed;
function   HasItems : Boolean;

procedure  CreateUserMenu;
procedure  CreateMainMenu;
procedure  UpdateMenu;
procedure  SetEnabled(bValue : Boolean);
procedure  SetChecked(bValue : Boolean);
procedure  SendAboutStrings;
procedure  LoadBitmap;

function   GetDBDirectory : String;

procedure  NotifyPlugin(iSender   : Integer;
                        iAction   : Integer;
                        iCookie   : Integer);

implementation
uses PromList;
{========================}
{$R sushko.res}

procedure NotifyPlugin(iSender   : Integer;
                       iAction   : Integer;
                       iCookie   : Integer);
begin
  case iAction of
  PACTION_OPENPLUGIN : QueryHost := Pointer(iCookie);
  PACTION_LOADEDFROM : sDLL      := StrPas(PChar(Pointer(iCookie)));
  PACTION_SETFOCUS   : if  (iSender = POBJECT_USER)
                       then begin
                       CreateUserMenu;
                       UpdateMenu;
                       end
                       else if  (iSender = POBJECT_MAINWINDOW)
                       then CreateMainMenu
                       else if  (iSender = POBJECT_ABOUT)
                       then begin
                       LoadBitmap;
                       SendAboutStrings;
                       end;
  PACTION_KILLFOCUS  : if  (iSender = POBJECT_ABOUT)
                       then ABitmap.Free;
  PACTION_ROWCHANGED : if  (iSender = POBJECT_USER)
                       then UpdateMenu;
  PACTION_CHANGED    : if  (iSender = POBJECT_USER)
                       then begin
                       if (not Payable and GetPromissed) then
                         SetPromissed(False);
                       UpdateMenu;
                       end;
  end;
end;
{==========================}
procedure CreateUserMenu;
var pczParam, pczHint : PChar;
begin
  GetMem( pczParam, PCOMMON_MAXSTRLEN);
  GetMem( pczHint,  PCOMMON_MAXSTRLEN);

  StrPCopy(pczParam, PROM_MENUNAME);
  StrPCopy(pczHint,  'Promissed to pay. Necessary to remind.');
  QueryHost(POBJECT_USER, PPROPERTY_MENUITEM, PACTION_INSERT,  pczParam, Integer(@TogglePromissed));
  QueryHost(POBJECT_USER, PPROPERTY_MENUITEM, PACTION_SETHINT, pczParam, Integer(Pointer(pczHint)));

  FreeMem(pczParam, PCOMMON_MAXSTRLEN);
  FreeMem(pczHint,  PCOMMON_MAXSTRLEN);
end;
{==========================}
procedure CreateMainMenu;
var pczParam, pczHint : PChar;
begin
  GetMem( pczParam, PCOMMON_MAXSTRLEN);
  GetMem( pczHint,  PCOMMON_MAXSTRLEN);

  StrPCopy(pczParam, '&Tools' + PCOMMON_SEPARATOR + PROM_MENUNAME);
  StrPCopy(pczHint,  'Remind users, who promissed to register, but have not done it yet');
  QueryHost(POBJECT_MAINWINDOW, PPROPERTY_MENUITEM, PACTION_INSERT,  pczParam, Integer(@ListPromissed));
  QueryHost(POBJECT_MAINWINDOW, PPROPERTY_MENUITEM, PACTION_SETHINT, pczParam, Integer(Pointer(pczHint)));

  FreeMem(pczParam, PCOMMON_MAXSTRLEN);
  FreeMem(pczHint,  PCOMMON_MAXSTRLEN);
end;
{==========================}
function HasItems : Boolean;
var pczIndex : PChar;
begin
  GetMem(pczIndex, PCOMMON_MAXSTRLEN);
  QueryHost(POBJECT_USER, PPROPERTY_CURRITEM, PACTION_GETDATA, pczIndex, 0);
  Result := (StrPas(pczIndex) <> '-1');
  FreeMem(pczIndex, PCOMMON_MAXSTRLEN);
end;
{==========================}
function GetPromissed   : Boolean;
var pczResult : PChar;
begin
  if (HasItems) then
    begin
    GetMem(  pczResult, PCOMMON_MAXSTRLEN);
    StrPCopy(pczResult, PROM_KEYNAME);
    QueryHost(POBJECT_USER,
              PPROPERTY_ADDINFO + PMASK_OLDITEM,
              PACTION_GETDATA,
              pczResult, 0);
    Result := (StrPas(pczResult) = '1');
    FreeMem( pczResult, PCOMMON_MAXSTRLEN);
    end
  else
    Result := False;
end;
{==========================}
procedure SetPromissed(bValue : Boolean);
var pczKey, pczValue : PChar;
begin
  if (HasItems) then
    begin
    GetMem(pczKey, PCOMMON_MAXSTRLEN);
    GetMem(pczValue, PCOMMON_MAXSTRLEN);
    StrPCopy(pczKey, PROM_KEYNAME);
    if (bValue)
    then StrPCopy(pczValue, '1')
    else StrPCopy(pczValue,  '');
    QueryHost(POBJECT_USER,
              PPROPERTY_ADDINFO + PMASK_OLDITEM,
              PACTION_SETDATA,
              pczKey, Integer(Pointer(pczValue)));
    FreeMem(pczKey, PCOMMON_MAXSTRLEN);
    FreeMem(pczValue, PCOMMON_MAXSTRLEN);
    end
end;
{==========================}
procedure TogglePromissed;
begin
  SetPromissed(not GetPromissed);
  UpdateMenu;
end;
{==========================}
procedure SetEnabled(bValue : Boolean);
var pczParam : PChar;
begin
  GetMem(  pczParam, PCOMMON_MAXSTRLEN);
  StrPCopy(pczParam, PROM_MENUNAME);

  if (bValue)
  then QueryHost(POBJECT_USER, PPROPERTY_MENUITEM, PACTION_SETENABLED, PROM_MENUNAME, 1)
  else QueryHost(POBJECT_USER, PPROPERTY_MENUITEM, PACTION_SETENABLED, PROM_MENUNAME, 0);

  FreeMem( pczParam, PCOMMON_MAXSTRLEN);
end;
{==========================}
procedure SetChecked(bValue : Boolean);
var pczParam : PChar;
begin
  GetMem(  pczParam, PCOMMON_MAXSTRLEN);
  StrPCopy(pczParam, PROM_MENUNAME);

  if (bValue)
  then QueryHost(POBJECT_USER, PPROPERTY_MENUITEM, PACTION_SETCHECKED, PROM_MENUNAME, 1)
  else QueryHost(POBJECT_USER, PPROPERTY_MENUITEM, PACTION_SETCHECKED, PROM_MENUNAME, 0);

  FreeMem( pczParam, PCOMMON_MAXSTRLEN);
end;
{==========================}
function Payable : Boolean;
var pczResult : PChar;
begin
  if (HasItems) then
    begin
    GetMem(  pczResult, PCOMMON_MAXSTRLEN);
    StrPCopy(pczResult, PROM_KEYNAME);
    QueryHost(POBJECT_USER,
              PPROPERTY_TYPE + PMASK_OLDITEM,
              PACTION_GETDATA,
              pczResult, 0);
    Result := (StrToInt(StrPas(pczResult)) = PURCHTYPE_CUSTOM) or
              (StrToInt(StrPas(pczResult)) = PURCHTYPE_TRIAL);
    FreeMem( pczResult, PCOMMON_MAXSTRLEN);
    end
  else
    Result := False;
end;
{==========================}
procedure UpdateMenu;
begin
  SetEnabled(HasItems and Payable);
  SetChecked(GetPromissed);
end;
{==========================}
procedure ListPromissed;
begin
  with TListWnd.Create(Application) do
    begin
    ShowModal;
    Free;
    end;
end;
{==========================}
procedure  SendAboutStrings;
var pczParam : PChar;
begin
  GetMem( pczParam, PCOMMON_MAXSTRLEN);
  StrPCopy(pczParam,
          'Reminder'                 + PCOMMON_SEPARATOR +
          'Remind users to pay'      + PCOMMON_SEPARATOR +
          'for your shareware'       + PCOMMON_SEPARATOR +
          'sushko@iname.com'         + PCOMMON_SEPARATOR +
          'members.tripod.com/~sushko/sc'
          );
  QueryHost(POBJECT_ABOUT, PPROPERTY_ABOUTPLUGIN,
            PACTION_SETDATA, pczParam, ABitmap.Handle);
  FreeMem(pczParam, PCOMMON_MAXSTRLEN);
end;
{==========================}
procedure LoadBitmap;
var HDLL : THandle;
begin
  HDLL := LoadLibrary(PChar(sDLL));
  if (HDLL <> 0) then
    begin
    ABitmap        := TBitmap.Create;
    ABitmap.Handle := Windows.LoadBitmap(HDLL, 'SUSHKO');
    FreeLibrary(HDLL);
    end
end;
{==========================}
function GetDBDirectory : String;
var pczParam : PChar;
begin
  GetMem(pczParam, PCOMMON_MAXSTRLEN);
  QueryHost(POBJECT_APPLICATION, PPROPERTY_DBDIRECTORY,
            PACTION_GETDATA, pczParam, 0);
  Result := StrPas(pczParam);
  FreeMem(pczParam, PCOMMON_MAXSTRLEN);
end;
{==========================}
end.
