unit PromList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, RXDBCtrl, Db, DBTables, RxQuery, AddInfo, StdCtrls,
  RXLookup, ShellAPI;

type
  TListWnd = class(TForm)
    PromQry: TRxQuery;
    PromQryEMail: TStringField;
    PromQryFullName: TStringField;
    CloseBtn: TButton;
    PromQryProductName: TStringField;
    PromLst: TListBox;
    PromQryFirstName: TStringField;
    PromQryMiddleName: TStringField;
    PromQryLastName: TStringField;
    PromQryUserPOCType1: TSmallintField;
    PromQryUserPOC1: TStringField;
    PromQryUserPOCType2: TSmallintField;
    PromQryUserPOC2: TStringField;
    PromQryUserPOCType3: TSmallintField;
    PromQryUserPOC3: TStringField;
    PromQryProductTitle: TStringField;
    PromQryVersionNumber: TStringField;
    PromQryAddInfo: TMemoField;
    EMailGet: TEdit;
    MailBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PromQryCalcFields(DataSet: TDataSet);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PromLstClick(Sender: TObject);
    procedure MailBtnClick(Sender: TObject);
    procedure EMailGetChange(Sender: TObject);
  private
    { Private declarations }
    function FullUserName(sFirstName, sMiddleName, sLastName : String) : String;
    procedure FillList;
    procedure DropList;
    procedure FillEMail;
  public
    { Public declarations }
  end;

var
  ListWnd: TListWnd;

implementation

uses main, scPlugin;
{$R *.DFM}
{===============================}
procedure TListWnd.FormCreate(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  FillList;
  Screen.Cursor := crDefault;
end;
{=====================}
function TListWnd.FullUserName(sFirstName, sMiddleName, sLastName : String) : String;
var sBuffer : String;
begin
  sBuffer := Trim(sMiddleName);
  Result := Trim(sLastName);
  If (Length(Trim(sFirstName)) > 0)
  then Result := Result + ', ' + sFirstName;
  If (Length(sBuffer) > 0)
  then Result := Result + ' ' + UpperCase(sBuffer[1]) + '.';
end;
{===============================}
procedure TListWnd.PromQryCalcFields(DataSet: TDataSet);
begin
  with DataSet do
    begin
    FieldByName('FullName').AsString    := FullUserName(
                                           FieldByName('FirstName').AsString,
                                           FieldByName('MiddleName').AsString,
                                           FieldByName('LastName').AsString);
    FieldByName('ProductName').AsString := FieldByName('ProductTitle').AsString + ' ' +
                                           FieldByName('VersionNumber').AsString;
    if      (FieldByName('UserPOCType1').AsInteger  = 3)
    and     (FieldByName('UserPOC1').AsString     <> '')
    then     FieldByName('EMail').AsString :=
             FieldByName('UserPOC1').AsString
    else if (FieldByName('UserPOCType2').AsInteger = 3)
    and     (FieldByName('UserPOC2').AsString     <> '')
    then     FieldByName('EMail').AsString :=
             FieldByName('UserPOC2').AsString
    else if (FieldByName('UserPOCType3').AsInteger = 3)
    and     (FieldByName('UserPOC3').AsString     <> '')
    then     FieldByName('EMail').AsString :=
             FieldByName('UserPOC3').AsString
    else     FieldByName('EMail').AsString := 'no e-mail';
    end;
end;
{===============================}
procedure TListWnd.CloseBtnClick(Sender: TObject);
begin
  Close;
end;
{===============================}
procedure TListWnd.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  DropList;
  Action := caFree;
end;
{===============================}
procedure TListWnd.FillList;
var AAddInfo : TAddInfo;
    pczEMail : PChar;
begin
  AAddInfo := TAddInfo.Create(0);
  with PromQry do
    begin
    DatabaseName := GetDBDirectory;
    Open;
    while (not Eof) do
      begin
      AAddInfo.Clear;
      AAddInfo.FromBlob(FieldByName('AddInfo') as TBlobField);
      if (AAddInfo.GetValue(PROM_KEYNAME) = '1') then
        begin
        GetMem(pczEMail,  PCOMMON_MAXSTRLEN);
        StrPCopy(pczEMail, '"' + FieldByName('FullName').AsString + '" <' +
                                 FieldByName('EMail').AsString + '>');
        PromLst.Items.AddObject( FieldByName('FullName').AsString + ' ('    +
                                 FieldByName('EMail').AsString    + ') -- ' +
                                 FieldByName('ProductName').AsString,
                                 Pointer(pczEMail)
                                );
        end;
      Next;
      end;
    Close;
    end;
  AAddInfo.Free;
end;
{===============================}
procedure TListWnd.DropList;
var pczEMail : PChar;
begin
  while (PromLst.Items.Count > 0) do
    begin
    pczEMail := PChar(Pointer(PromLst.Items.Objects[0]));
    FreeMem(pczEMail, PCOMMON_MAXSTRLEN);
    PromLst.Items.Delete(0);
    end;
end;
{===============================}
procedure TListWnd.PromLstClick(Sender: TObject);
begin
  FillEMail;
end;
{===============================}
procedure TListWnd.FillEMail;
var i : Integer;
begin
  EMailGet.Text := '';
  with PromLst do
    for i:=0 to Items.Count-1 do
      if (Selected[i]) then
        begin
        if  (EMailGet.Text  = '')
        then EMailGet.Text := StrPas(PChar(Pointer(Items.Objects[i])))
        else EMailGet.Text := EMailGet.Text + ',' +
                              StrPas(PChar(Pointer(Items.Objects[i])));
        end;
end;
{===============================}
procedure TListWnd.MailBtnClick(Sender: TObject);
begin
  ShellExecute(Application.Handle, nil, PChar('mailto:' + EMailGet.Text), nil, nil, SW_SHOWNOACTIVATE);
end;
{===============================}
procedure TListWnd.EMailGetChange(Sender: TObject);
begin
  MailBtn.Enabled := (Length(Trim(EMailGet.Text)) > 0);
end;
{===============================}
end.
