unit main;
interface

uses scPlugin, SysUtils, Dialogs;

var       sStartDir : String;
          QueryHost : TQueryHost;

procedure ShowMainForm;
function  RemoveBackSlash(sDir : String) : String;
procedure CreateMenus;
procedure NotifyPlugin(iSender   : Integer;
                       iAction   : Integer;
                       iCookie   : Integer);
implementation
{=========================}
function RemoveBackSlash(sDir : String) : String;
begin
  Result := sDir;
  If (sDir[Length(sDir)] = '\') then
    System.Delete(Result, Length(Result), 1);
end;
{========================}
procedure NotifyPlugin(iSender   : Integer;
                       iAction   : Integer;
                       iCookie   : Integer);
begin
  case iAction of
  PNOTIFY_OPENPLUGIN : begin
                       QueryHost := Pointer(iCookie);
                       CreateMenus;
                       end;
  end;
end;
{========================}
procedure CreateMenus;
var pczParam : PChar;
    pczHint  : PChar;
begin
  GetMem(pczParam, PCOMMON_MAXSTRLEN);
  GetMem(pczHint,  PCOMMON_MAXSTRLEN);
  StrPCopy(pczParam, '&' + PCOMMON_SEPARATOR + ' &');
  StrPCopy(pczHint, '     Shareware Centrum');
  QueryHost(POBJECT_MAINWINDOW,
            PPROPERTY_MENUITEM,
            PACTION_INSERT,
            pczParam,
            Integer(@ShowMainForm));
  QueryHost(POBJECT_MAINWINDOW,
            PPROPERTY_MENUITEM,
            PACTION_SETHINT,
            pczParam,
            Integer(Pointer(pczHint)));
  FreeMem(pczParam, PCOMMON_MAXSTRLEN);
  FreeMem(pczHint,  PCOMMON_MAXSTRLEN);
end;
{========================}
procedure ShowMainForm;
begin
  ShowMessage('');
end;
{========================}
end.
