{***********************************************************}
{                                                           }
{         TWAVSampler component                             }
{                                                           }
{         Copyright (C) 1995,1996, by Jan Goyvaerts         }
{         All rights reserved                               }
{                                                           }
{***********************************************************}

{***********************************************************}
{                                                           }
{         Delphi sample project main form                   }
{          - TWAVSamplerTestForm                            }
{                                                           }
{***********************************************************}

unit TestMain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Sampler, Gauges, ExtCtrls;

type
  TWAVSamplerTestForm = class(TForm)
    WAVSampler: TWAVSampler;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    PlayTimer: TTimer;
    Gauge: TGauge;
    Button5: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure PlayTimerTimer(Sender: TObject);
    procedure WAVSamplerPlayStart(Sender: TObject);
    procedure WAVSamplerPlayStop(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WAVSamplerTestForm: TWAVSamplerTestForm;

implementation

{$R *.DFM}

procedure TWAVSamplerTestForm.Button1Click(Sender: TObject);
begin
  if not WAVSampler.RecordNew then MessageDlg('Something went wrong', mtInformation, [mbOk], 0);
end;

procedure TWAVSamplerTestForm.Button2Click(Sender: TObject);
begin
  { Not checking for this is no error, PlayStart will do nothing then }
  if WAVSampler.WaveBuffers = 0 then MessageDlg('Open or record a wave first', mtInformation, [mbOk], 0)
    else WAVSampler.PlayStart;
end;

procedure TWAVSamplerTestForm.Button3Click(Sender: TObject);
begin
  if OpenDialog.Execute then WAVSampler.LoadFromFile(OpenDialog.Filename)
end;

procedure TWAVSamplerTestForm.Button4Click(Sender: TObject);
begin
  { Not checking for this is no error, SaveToFile will do nothing then }
  if WAVSampler.WaveBuffers = 0 then MessageDlg('Open or record a wave first', mtInformation, [mbOk], 0)
    else if SaveDialog.Execute then WAVSampler.SaveToFile(SaveDialog.Filename);
end;

procedure TWAVSamplerTestForm.PlayTimerTimer(Sender: TObject);
begin
  Gauge.Progress := WAVSampler.PlayProgress;
end;

procedure TWAVSamplerTestForm.WAVSamplerPlayStart(Sender: TObject);
begin
  Button2.Enabled := False;
  Button5.Enabled := True;
  PlayTimer.Enabled := True
end;

procedure TWAVSamplerTestForm.WAVSamplerPlayStop(Sender: TObject);
begin
  Button2.Enabled := True;
  Button5.Enabled := False;
  PlayTimer.Enabled := False;
  Gauge.Progress := 100;
end;

procedure TWAVSamplerTestForm.Button5Click(Sender: TObject);
begin
  WAVSampler.PlayStop
end;

end.
